/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import java.util.HashMap;
import java.util.Map;

public class DockableShowingManager
extends DockStationAdapter {
    private DockStationListenerManager listeners;
    private Map<Dockable, Boolean> visibility = new HashMap<Dockable, Boolean>();

    public DockableShowingManager(DockStationListenerManager dockStationListenerManager) {
        if (dockStationListenerManager == null) {
            throw new IllegalArgumentException("Listeners must not be null");
        }
        this.listeners = dockStationListenerManager;
        dockStationListenerManager.addListener(this);
    }

    public void fire() {
        DockStation dockStation = this.listeners.getStation();
        int n = 0;
        int n2 = dockStation.getDockableCount();
        while (n < n2) {
            Dockable dockable = dockStation.getDockable(n);
            boolean bl = dockStation.isChildShowing(dockable);
            if (!this.visibility.containsKey(dockable) || this.visibility.get(dockable) != bl) {
                this.listeners.fireDockableVisibilitySet(dockable, bl);
                this.visibility.put(dockable, bl);
            }
            ++n;
        }
    }

    @Override
    public void dockableAdded(DockStation dockStation, Dockable dockable) {
        boolean bl = dockStation.isChildShowing(dockable);
        this.listeners.fireDockableVisibilitySet(dockable, bl);
        this.visibility.put(dockable, bl);
    }

    @Override
    public void dockableRemoved(DockStation dockStation, Dockable dockable) {
        Boolean bl = this.visibility.remove(dockable);
        if (bl != null && bl.booleanValue()) {
            this.listeners.fireDockableVisibilitySet(dockable, false);
        }
    }
}

