/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.StrategyPlaceholderListItemConverter;
import bibliothek.util.Path;

public class DockablePlaceholderList<P extends PlaceholderListItem<Dockable>>
extends PlaceholderList<Dockable, DockStation, P> {
    public DockablePlaceholderList() {
    }

    public DockablePlaceholderList(PlaceholderMap placeholderMap) {
        this(placeholderMap, new StrategyPlaceholderListItemConverter(null));
    }

    public DockablePlaceholderList(PlaceholderMap placeholderMap, PlaceholderListItemConverter<Dockable, P> placeholderListItemConverter) {
        super(placeholderMap, placeholderListItemConverter);
    }

    public static <P extends PlaceholderListItem<Dockable>> void simulatedRead(PlaceholderMap placeholderMap, PlaceholderListItemConverter<Dockable, P> placeholderListItemConverter) {
        DockablePlaceholderList<P> dockablePlaceholderList = new DockablePlaceholderList<P>();
        dockablePlaceholderList.read(placeholderMap, placeholderListItemConverter, true);
    }

    public PlaceholderMap toMap() {
        return this.toMap(new StrategyPlaceholderListItemConverter(this.getStrategy()));
    }

    @Override
    protected Path getPlaceholder(Dockable dockable) {
        PlaceholderStrategy placeholderStrategy = this.getStrategy();
        if (placeholderStrategy != null) {
            return placeholderStrategy.getPlaceholderFor(dockable);
        }
        return null;
    }

    @Override
    protected DockStation toStation(Dockable dockable) {
        return dockable.asDockStation();
    }

    protected Dockable[] getChildren(DockStation dockStation) {
        Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
        int n = 0;
        while (n < dockableArray.length) {
            dockableArray[n] = dockStation.getDockable(n);
            ++n;
        }
        return dockableArray;
    }

    @Override
    protected PlaceholderMap getPlaceholders(DockStation dockStation) {
        return dockStation.getPlaceholders();
    }

    @Override
    protected void setPlaceholders(DockStation dockStation, PlaceholderMap placeholderMap) {
        dockStation.setPlaceholders(placeholderMap);
    }

    @Override
    protected String toString(Dockable dockable) {
        return "'" + dockable.getTitleText() + "'";
    }
}

