/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import java.util.ArrayList;
import java.util.List;

public class DockStationListenerManager {
    private List<DockStationListener> listeners = new ArrayList<DockStationListener>();
    private DockStation station;

    public DockStationListenerManager(DockStation dockStation) {
        if (dockStation == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = dockStation;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void addListener(DockStationListener dockStationListener) {
        this.listeners.add(dockStationListener);
    }

    public void removeListener(DockStationListener dockStationListener) {
        this.listeners.remove(dockStationListener);
    }

    public void fireDockableVisibilitySet(Dockable dockable, boolean bl) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableShowingChanged(this.station, dockable, bl);
            ++n2;
        }
    }

    public void fireDockableAdded(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableAdded(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableRemoved(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableRemoved(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableAdding(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableAdding(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableRemoving(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableRemoving(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableSelected(Dockable dockable, Dockable dockable2) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockableSelected(this.station, dockable, dockable2);
            ++n2;
        }
    }

    public void fireDockablesRepositioned(Dockable ... dockableArray) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener dockStationListener = dockStationListenerArray[n2];
            dockStationListener.dockablesRepositioned(this.station, dockableArray);
            ++n2;
        }
    }
}

