/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import java.awt.Dimension;

public class Size {
    private Type type;
    private int width;
    private int height;
    private double score;

    public Size(Type type, int n, int n2, double d) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("score out of bounds: " + d);
        }
        this.score = d;
        this.type = type;
        this.width = n;
        this.height = n2;
    }

    public Size(Type type, Dimension dimension, double d) {
        this(type, dimension.width, dimension.height, d);
    }

    public boolean isMinimum() {
        return Type.MINIMUM == this.type;
    }

    public boolean isPreferred() {
        return Type.PREFERRED == this.type;
    }

    public Type getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getScore() {
        return this.score;
    }

    public Dimension toDimension() {
        return new Dimension(this.width, this.height);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@[width=" + this.getWidth() + ", height=" + this.getHeight() + ", type=" + (Object)((Object)this.getType()) + "]";
    }

    public static enum Type {
        MINIMUM,
        PREFERRED;

    }
}

