/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.AbstractTabsLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class LineTabsLayoutBlock
extends AbstractTabsLayoutBlock {
    private boolean sameSize = true;

    public boolean isSameSize() {
        return this.sameSize;
    }

    public void setSameSize(boolean bl) {
        this.sameSize = bl;
    }

    @Override
    public boolean isAllTabs(Size size) {
        return ((LineSize)size).isAllTabs();
    }

    @Override
    public Tab[] getTabs(Size size) {
        return ((LineSize)size).getTabs();
    }

    @Override
    public int getTabsCount(Size size) {
        return ((LineSize)size).getTabCount();
    }

    protected void checkSelection() {
        if (this.getSelectedTab() != null) {
            return;
        }
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            return;
        }
        Dockable dockable = tabPane.getSelectedDockable();
        if (dockable == null) {
            return;
        }
        this.insertTab(tabPane.putOnTab(dockable));
    }

    public LineSize[] getSizes() {
        Tab[] tabArray = this.getTabsOrderedByImportance();
        SizeCollector sizeCollector = new SizeCollector(this.getPane().getDockables());
        LineSize[] lineSizeArray = new LineSize[tabArray.length + 1];
        int n = 0;
        while (n < tabArray.length) {
            sizeCollector.insert(tabArray[n]);
            Dimension dimension = sizeCollector.getMinimumSize();
            Tab[] tabArray2 = new Tab[n + 1];
            System.arraycopy(tabArray, 0, tabArray2, 0, n + 1);
            lineSizeArray[n] = new LineSize(Size.Type.MINIMUM, dimension, tabArray2, n + 1 == tabArray.length, (double)n / (double)tabArray.length);
            ++n;
        }
        Dimension dimension = sizeCollector.getPreferredSize();
        lineSizeArray[tabArray.length] = new LineSize(Size.Type.PREFERRED, dimension, tabArray, true, 1.0);
        return lineSizeArray;
    }

    @Override
    public int getIndexOfTabAt(Point point) {
        Tab[] tabArray = this.getCurrentTabs();
        int[] nArray = this.getOverlapToPrevious(tabArray);
        int[] nArray2 = this.getOverlapToNext(tabArray);
        int n = -1;
        boolean bl = this.getOrientation().isHorizontal();
        int n2 = 0;
        while (n2 < tabArray.length) {
            Rectangle rectangle = tabArray[n2].getBounds();
            if (rectangle.contains(point)) {
                boolean bl2;
                if (bl) {
                    bl2 = point.x >= rectangle.x + nArray[n2] && point.x < rectangle.x + rectangle.width - nArray2[n2];
                } else {
                    boolean bl3 = bl2 = point.y >= rectangle.y + nArray[n2] && point.y < rectangle.y + rectangle.height - nArray2[n2];
                }
                if (bl2) {
                    return n2;
                }
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    protected Tab[] getCurrentTabs() {
        TabPane tabPane = this.getPane();
        Tab[] tabArray = tabPane.getTabs();
        Arrays.sort(tabArray, new Comparator<Tab>(){

            @Override
            public int compare(Tab tab, Tab tab2) {
                return tab.getZOrder() - tab2.getZOrder();
            }
        });
        return tabArray;
    }

    @Override
    public void doLayout() {
        Tab[] tabArray;
        int n;
        Tab[] tabArray2 = this.getTabs();
        Rectangle rectangle = this.getBounds();
        DefaultAxisConversion defaultAxisConversion = new DefaultAxisConversion(rectangle, this.getOrientation());
        rectangle = defaultAxisConversion.viewToModel(rectangle);
        Dimension[] dimensionArray = new Dimension[tabArray2.length];
        Dimension[] dimensionArray2 = new Dimension[tabArray2.length];
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.getOverlapToPrevious(tabArray2);
        int[] nArray2 = this.getOverlapToNext(tabArray2);
        int n4 = 0;
        while (n4 < tabArray2.length) {
            dimensionArray[n4] = defaultAxisConversion.viewToModel(tabArray2[n4].getPreferredSize());
            dimensionArray2[n4] = defaultAxisConversion.viewToModel(tabArray2[n4].getMinimumSize());
            n2 += dimensionArray[n4].width;
            n3 += dimensionArray2[n4].width;
            if (n4 > 0) {
                n = Math.max(nArray[n4], nArray2[n4 - 1]);
                n2 -= n;
                n3 -= n;
            }
            ++n4;
        }
        ZOrder zOrder = new ZOrder(tabArray2);
        if (n2 <= rectangle.width) {
            this.doLayoutPreferred(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray, tabArray2, zOrder, nArray, nArray2);
        } else if (n3 <= rectangle.width) {
            this.doLayoutMinimum(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray2, dimensionArray, tabArray2, zOrder, nArray, nArray2);
        } else {
            this.doLayoutShrinked(defaultAxisConversion, rectangle.width, rectangle.height, dimensionArray2, tabArray2, zOrder, nArray, nArray2);
        }
        n = 0;
        Tab[] tabArray3 = tabArray = zOrder.getOrderedByZ();
        int n5 = tabArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Tab tab = tabArray3[n6];
            if (tab != null) {
                tab.setZOrder(n++);
            }
            ++n6;
        }
    }

    private int[] getOverlapToPrevious(Tab[] tabArray) {
        boolean bl = this.getOrientation().isHorizontal();
        int[] nArray = new int[tabArray.length];
        int n = 1;
        while (n < tabArray.length) {
            Insets insets = tabArray[n].getOverlap(tabArray[n - 1]);
            nArray[n] = bl ? insets.left : insets.top;
            ++n;
        }
        return nArray;
    }

    private int[] getOverlapToNext(Tab[] tabArray) {
        boolean bl = this.getOrientation().isHorizontal();
        int[] nArray = new int[tabArray.length];
        int n = tabArray.length - 2;
        while (n >= 0) {
            Insets insets = tabArray[n].getOverlap(tabArray[n + 1]);
            nArray[n] = bl ? insets.right : insets.bottom;
            --n;
        }
        return nArray;
    }

    private void doLayoutPreferred(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < tabArray.length) {
            Dimension dimension = dimensionArray[n4];
            tabArray[n4].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, dimension.width, this.sameSize ? n2 : Math.min(n2, dimension.height))));
            n3 += dimension.width;
            if (n4 + 1 < tabArray.length) {
                if (nArray2[n4] > nArray[n4 + 1]) {
                    n3 -= nArray2[n4];
                    zOrder.putOrder(tabArray[n4 + 1], tabArray[n4]);
                } else {
                    n3 -= nArray[n4 + 1];
                    zOrder.putOrder(tabArray[n4], tabArray[n4 + 1]);
                }
            }
            ++n4;
        }
    }

    private void doLayoutMinimum(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Dimension[] dimensionArray2, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        Dimension dimension;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Dimension[] dimensionArray3 = dimensionArray;
        int n6 = dimensionArray.length;
        int n7 = 0;
        while (n7 < n6) {
            dimension = dimensionArray3[n7];
            n4 += dimension.width;
            ++n7;
        }
        dimensionArray3 = dimensionArray2;
        n6 = dimensionArray2.length;
        n7 = 0;
        while (n7 < n6) {
            dimension = dimensionArray3[n7];
            n5 += dimension.width;
            ++n7;
        }
        double d = (double)(n - n4) / (double)(n5 - n4);
        n6 = 0;
        while (n6 < tabArray.length - 1) {
            int n8 = (int)((double)dimensionArray[n6].width + d * (double)(dimensionArray2[n6].width - dimensionArray[n6].width));
            tabArray[n6].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, n8, this.sameSize ? n2 : Math.min(n2, dimensionArray2[n6].height))));
            n3 += n8;
            if (nArray2[n6] > nArray[n6 + 1]) {
                n3 -= nArray2[n6];
                zOrder.putOrder(tabArray[n6 + 1], tabArray[n6]);
            } else {
                n3 -= nArray[n6 + 1];
                zOrder.putOrder(tabArray[n6], tabArray[n6 + 1]);
            }
            ++n6;
        }
        if (tabArray.length > 0) {
            n6 = tabArray.length - 1;
            int n9 = Math.min(n - n3, dimensionArray2[n6].width);
            tabArray[n6].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, n9, this.sameSize ? n2 : Math.min(n2, dimensionArray2[n6].height))));
        }
    }

    private void doLayoutShrinked(AxisConversion axisConversion, int n, int n2, Dimension[] dimensionArray, Tab[] tabArray, ZOrder zOrder, int[] nArray, int[] nArray2) {
        int n3 = 0;
        int n4 = 0;
        Dimension[] dimensionArray2 = dimensionArray;
        int n5 = dimensionArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Dimension dimension = dimensionArray2[n6];
            n4 += dimension.width;
            ++n6;
        }
        double d = (double)n4 / (double)n;
        n5 = 0;
        while (n5 < tabArray.length - 1) {
            int n7 = (int)(d * (double)dimensionArray[n5].width);
            tabArray[n5].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, n7, this.sameSize ? n2 : Math.min(n2, dimensionArray[n5].height))));
            n3 += n7;
            if (nArray2[n5] > nArray[n5 + 1]) {
                n3 -= nArray2[n5];
                zOrder.putOrder(tabArray[n5 + 1], tabArray[n5]);
            } else {
                n3 -= nArray[n5 + 1];
                zOrder.putOrder(tabArray[n5], tabArray[n5 + 1]);
            }
            ++n5;
        }
        n5 = tabArray.length - 1;
        if (n5 >= 0) {
            tabArray[n5].setBounds(axisConversion.modelToView(new Rectangle(n3, 0, n - n3, this.sameSize ? n2 : Math.min(n2, dimensionArray[n5].height))));
        }
    }

    public class LineSize
    extends AbstractTabsLayoutBlock.TabsSize {
        private boolean allTabs;

        public LineSize(Size.Type type, Dimension dimension, Tab[] tabArray, boolean bl, double d) {
            super(type, dimension, tabArray, d);
            this.allTabs = bl;
        }

        public boolean isAllTabs() {
            return this.allTabs;
        }
    }

    protected class SizeCollector {
        private Dockable[] dockables;
        private Tab[] tabs;
        private Dimension[] minimum;
        private Dimension[] preferred;
        private int[] overlapPrevious;
        private int[] overlapNext;

        public SizeCollector(Dockable[] dockableArray) {
            this.dockables = dockableArray;
            int n = dockableArray.length;
            this.tabs = new Tab[n];
            this.minimum = new Dimension[n];
            this.preferred = new Dimension[n];
            this.overlapPrevious = new int[n];
            this.overlapNext = new int[n];
        }

        public void insert(Tab tab) {
            Dockable dockable = tab.getDockable();
            int n = 0;
            while (n < this.dockables.length) {
                if (this.dockables[n] == dockable) {
                    this.insert(tab, n);
                    return;
                }
                ++n;
            }
        }

        private Tab[] getVisibleTabs() {
            Object object;
            int n = 0;
            Tab[] tabArray = this.tabs;
            int n2 = this.tabs.length;
            int n3 = 0;
            while (n3 < n2) {
                object = tabArray[n3];
                if (object != null) {
                    ++n;
                }
                ++n3;
            }
            object = new Tab[n];
            n3 = 0;
            Tab[] tabArray2 = this.tabs;
            int n4 = this.tabs.length;
            int n5 = 0;
            while (n5 < n4) {
                Tab tab = tabArray2[n5];
                if (tab != null) {
                    object[n3++] = tab;
                }
                ++n5;
            }
            return object;
        }

        private void insert(Tab tab, int n) {
            this.tabs[n] = tab;
            Tab[] tabArray = this.getVisibleTabs();
            int n2 = 0;
            while (n2 < this.tabs.length) {
                if (this.tabs[n2] != null) {
                    this.minimum[n2] = this.tabs[n2].getMinimumSize(tabArray);
                    this.preferred[n2] = this.tabs[n2].getPreferredSize(tabArray);
                }
                ++n2;
            }
            n2 = LineTabsLayoutBlock.this.getOrientation().isHorizontal() ? 1 : 0;
            int n3 = n - 1;
            while (n3 >= 0) {
                if (this.tabs[n3] != null) {
                    if (n2 != 0) {
                        this.overlapNext[n3] = this.tabs[n3].getOverlap((TabPaneComponent)tab).right;
                        this.overlapPrevious[n] = tab.getOverlap((TabPaneComponent)this.tabs[n3]).left;
                        break;
                    }
                    this.overlapNext[n3] = this.tabs[n3].getOverlap((TabPaneComponent)tab).bottom;
                    this.overlapPrevious[n] = tab.getOverlap((TabPaneComponent)this.tabs[n3]).top;
                    break;
                }
                --n3;
            }
            n3 = n + 1;
            while (n3 < this.tabs.length) {
                if (this.tabs[n3] != null) {
                    if (n2 != 0) {
                        this.overlapNext[n] = tab.getOverlap((TabPaneComponent)this.tabs[n3]).right;
                        this.overlapPrevious[n3] = this.tabs[n3].getOverlap((TabPaneComponent)tab).left;
                        break;
                    }
                    this.overlapNext[n] = tab.getOverlap((TabPaneComponent)this.tabs[n3]).bottom;
                    this.overlapPrevious[n3] = this.tabs[n3].getOverlap((TabPaneComponent)tab).top;
                    break;
                }
                ++n3;
            }
        }

        public Dimension getMinimumSize() {
            return this.getSize(this.minimum);
        }

        public Dimension getPreferredSize() {
            return this.getSize(this.preferred);
        }

        private Dimension getSize(Dimension[] dimensionArray) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            if (LineTabsLayoutBlock.this.getOrientation().isHorizontal()) {
                int n4 = 0;
                while (n4 < this.tabs.length) {
                    if (this.tabs[n4] != null) {
                        Dimension dimension = dimensionArray[n4];
                        n2 = Math.max(n2, dimension.height);
                        n += dimension.width;
                        if (n3 != -1) {
                            n -= Math.max(this.overlapNext[n3], this.overlapPrevious[n4]);
                        }
                        n3 = n4;
                    }
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this.tabs.length) {
                    if (this.tabs[n5] != null) {
                        Dimension dimension = dimensionArray[n5];
                        n = Math.max(n, dimension.width);
                        n2 += dimension.height;
                        if (n3 != -1) {
                            n2 -= Math.max(this.overlapNext[n3], this.overlapPrevious[n5]);
                        }
                        n3 = n5;
                    }
                    ++n5;
                }
            }
            return new Dimension(n, n2);
        }
    }

    protected class ZOrder {
        private Tab[] tabs;
        private List<Integer>[] onTop;
        private List<Integer>[] onBottom;

        public ZOrder(Tab[] tabArray) {
            this.tabs = tabArray;
            this.onTop = new List[tabArray.length];
            this.onBottom = new List[tabArray.length];
            int n = 0;
            while (n < tabArray.length) {
                this.onTop[n] = new ArrayList<Integer>(5);
                this.onBottom[n] = new ArrayList<Integer>(5);
                ++n;
            }
        }

        public void putOrder(Tab tab, Tab tab2) {
            int n = 0;
            while (n < this.tabs.length) {
                if (this.tabs[n] == tab) {
                    int n2 = 0;
                    while (n2 < this.tabs.length) {
                        if (this.tabs[n2] == tab2) {
                            this.onTop[n2].add(n);
                            this.onBottom[n].add(n2);
                            return;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }

        public int[] getZOrders() {
            int[] nArray = new int[this.tabs.length];
            boolean[] blArray = new boolean[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (!blArray[n2] && this.onTop[n2].isEmpty()) {
                        nArray[n2] = nArray.length - n;
                        blArray[n2] = true;
                        Integer n3 = n;
                        for (int n4 : this.onBottom[n2]) {
                            this.onTop[n4].remove(n3);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            return nArray;
        }

        public Tab[] getOrderedByZ() {
            Tab[] tabArray = new Tab[this.tabs.length];
            boolean[] blArray = new boolean[tabArray.length];
            int n = 0;
            while (n < tabArray.length) {
                int n2 = 0;
                while (n2 < tabArray.length) {
                    if (!blArray[n2] && this.onTop[n2].isEmpty()) {
                        tabArray[n] = this.tabs[n2];
                        blArray[n2] = true;
                        Integer n3 = n;
                        for (int n4 : this.onBottom[n2]) {
                            this.onTop[n4].remove(n3);
                        }
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            return tabArray;
        }
    }
}

