/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractTabsLayoutBlock
implements TabsLayoutBlock {
    private List<Tab> tabs = new ArrayList<Tab>();
    private Rectangle bounds = new Rectangle();
    private TabPane pane;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;

    public void setPane(TabPane tabPane) {
        this.pane = tabPane;
    }

    public TabPane getPane() {
        return this.pane;
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            for (Tab tab : this.tabs) {
                tab.setOrientation(tabPlacement);
            }
        }
    }

    public Tab getSelectedTab() {
        if (this.pane == null) {
            return null;
        }
        Dockable dockable = this.pane.getSelectedDockable();
        for (Tab tab : this.tabs) {
            if (tab.getDockable() != dockable) continue;
            return tab;
        }
        return null;
    }

    public void checkExistence() {
        ListIterator<Tab> listIterator = this.tabs.listIterator();
        Tab[] tabArray = this.pane.getTabs();
        while (listIterator.hasNext()) {
            Tab tab = listIterator.next();
            boolean bl = false;
            Tab[] tabArray2 = tabArray;
            int n = tabArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab2 = tabArray2[n2];
                if (tab == tab2) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            listIterator.remove();
        }
    }

    public Tab[] getTabs() {
        return this.tabs.toArray(new Tab[this.tabs.size()]);
    }

    public int getTabsCount() {
        return this.tabs.size();
    }

    public void addTab(Tab tab) {
        this.insertTab(tab, this.tabs.size());
    }

    public void insertTab(Tab tab) {
        int[] nArray = this.getOriginalTabLocations();
        TabPane tabPane = this.getPane();
        Dockable[] dockableArray = tabPane.getDockables();
        int n = -1;
        int n2 = 0;
        while (n2 < dockableArray.length) {
            if (dockableArray[n2] == tab.getDockable()) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new IllegalArgumentException(tab.getDockable() + " is not a child of the TabPane");
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] < n) {
                ++n2;
            }
            ++n4;
        }
        n4 = 0;
        int n5 = n3 + n2;
        int n6 = 0;
        while (n6 < nArray.length) {
            if (nArray[n6] < n) {
                --n2;
            } else if (nArray[n6] > n) {
                ++n3;
            }
            int n7 = n2 + n3;
            if (n7 < n5) {
                n5 = n7;
                n4 = n6 + 1;
            }
            ++n6;
        }
        this.insertTab(tab, n4);
    }

    public int indexOfTab(Tab tab) {
        return this.tabs.indexOf(tab);
    }

    public Tab[] getTabsOrderedByImportance() {
        if (this.pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Dockable[] dockableArray = this.pane.getDockables();
        Tab[] tabArray = new Tab[dockableArray.length];
        int[] nArray = this.getOriginalTabLocations();
        int n = 0;
        while (n < tabArray.length) {
            tabArray[n] = this.pane.getOnTab(dockableArray[n]);
            ++n;
        }
        Tab[] tabArray2 = new Tab[tabArray.length];
        int n2 = 0;
        Dockable dockable = this.pane.getSelectedDockable();
        Tab tab = null;
        Tab[] tabArray3 = tabArray;
        int n3 = tabArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Tab tab2 = tabArray3[n4];
            if (tab2.getDockable() == dockable) {
                tab = tab2;
                break;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < tabArray.length) {
            if (tab == tabArray[n5]) {
                tabArray[n5] = null;
                tabArray2[n2++] = tab;
                break;
            }
            ++n5;
        }
        int n6 = n5 = tab == null ? -1 : this.indexOfTab(tab);
        if (n5 == -1) {
            n4 = 0;
            while (n4 < nArray.length) {
                Tab tab3;
                if (nArray[n4] != -1 && (tab3 = tabArray[nArray[n4]]) != null) {
                    tabArray2[n2++] = tab3;
                    tabArray[nArray[n4]] = null;
                }
                ++n4;
            }
        } else {
            n4 = n5 - 1;
            while (n4 >= 0) {
                Tab tab4;
                if (nArray[n4] != -1 && (tab4 = tabArray[nArray[n4]]) != null) {
                    tabArray2[n2++] = tab4;
                    tabArray[nArray[n4]] = null;
                }
                --n4;
            }
            n4 = n5 + 1;
            while (n4 < nArray.length) {
                Tab tab5;
                if (nArray[n4] != -1 && (tab5 = tabArray[nArray[n4]]) != null) {
                    tabArray2[n2++] = tab5;
                    tabArray[nArray[n4]] = null;
                }
                ++n4;
            }
        }
        n4 = -1;
        n3 = -1;
        int n7 = 0;
        while (n7 < tabArray.length) {
            if (tabArray[n7] == null) {
                n4 = n7;
                break;
            }
            ++n7;
        }
        n7 = tabArray.length - 1;
        while (n7 >= 0) {
            if (tabArray[n7] == null) {
                n3 = n7;
                break;
            }
            --n7;
        }
        n7 = n4 + 1;
        while (n7 < n3) {
            if (tabArray[n7] != null) {
                tabArray2[n2++] = tabArray[n7];
                tabArray[n7] = null;
            }
            ++n7;
        }
        n7 = n4 - 1;
        while (n7 >= 0) {
            if (tabArray[n7] != null) {
                tabArray2[n2++] = tabArray[n7];
                tabArray[n7] = null;
            }
            --n7;
        }
        n7 = Math.max(0, n3);
        while (n7 < tabArray.length) {
            if (tabArray[n7] != null) {
                tabArray2[n2++] = tabArray[n7];
                tabArray[n7] = null;
            }
            ++n7;
        }
        return tabArray2;
    }

    public int[] getOriginalTabLocations() {
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Tab[] tabArray = this.getTabs();
        Dockable[] dockableArray = tabPane.getDockables();
        int[] nArray = new int[tabArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < tabArray.length) {
            Dockable dockable = tabArray[n2].getDockable();
            nArray[n2] = -1;
            int n3 = 0;
            while (n3 < dockableArray.length) {
                if (dockableArray[n] == dockable) {
                    nArray[n2] = n;
                    break;
                }
                n = (n + 1) % dockableArray.length;
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    public Tab[] getDockableTabMap() {
        TabPane tabPane = this.getPane();
        if (tabPane == null) {
            throw new IllegalStateException("missing the TabPane");
        }
        Tab[] tabArray = this.getTabs();
        Dockable[] dockableArray = tabPane.getDockables();
        Tab[] tabArray2 = new Tab[dockableArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < tabArray.length) {
            Dockable dockable = tabArray[n2].getDockable();
            int n3 = 0;
            while (n3 < dockableArray.length) {
                if (dockableArray[n] == dockable) {
                    tabArray2[n] = tabArray[n2];
                    break;
                }
                n = (n + 1) % dockableArray.length;
                ++n3;
            }
            ++n2;
        }
        return tabArray2;
    }

    public void insertTab(Tab tab, int n) {
        if (tab == null) {
            throw new IllegalArgumentException("tab must not be null");
        }
        this.tabs.add(n, tab);
        tab.setOrientation(this.getOrientation());
    }

    public boolean removeTab(Tab tab) {
        return this.tabs.remove(tab);
    }

    public Tab removeTab(int n) {
        return this.tabs.remove(n);
    }

    public void removeAllTabs() {
        this.tabs.clear();
    }

    public abstract void doLayout();

    @Override
    public void setLayout(Size size) {
        if (size instanceof TabsSize) {
            int n;
            Tab[] tabArray;
            Tab[] tabArray2 = ((TabsSize)size).getTabs();
            if (tabArray2.length == (tabArray = this.getTabs()).length) {
                boolean bl = true;
                n = 0;
                while (n < tabArray2.length && bl) {
                    bl = tabArray2[n] == tabArray[n];
                    ++n;
                }
                if (bl) {
                    return;
                }
            }
            this.removeAllTabs();
            Tab[] tabArray3 = tabArray2;
            int n2 = tabArray2.length;
            n = 0;
            while (n < n2) {
                Tab tab = tabArray3[n];
                tab = this.pane.putOnTab(tab.getDockable());
                this.insertTab(tab);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("not a size created by this block");
        }
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds.setBounds(n, n2, n3, n4);
        this.doLayout();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    protected class TabsSize
    extends Size {
        private Tab[] tabs;

        public TabsSize(Size.Type type, Dimension dimension, Tab[] tabArray, double d) {
            super(type, dimension, d);
            this.tabs = tabArray;
        }

        public Tab[] getTabs() {
            return this.tabs;
        }

        public int getTabCount() {
            return this.tabs.length;
        }

        @Override
        public String toString() {
            return "[width=" + this.getWidth() + ", height=" + this.getHeight() + ", tabs=" + Arrays.toString(this.tabs) + "]";
        }
    }
}

