/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TabComponentLayoutManager
implements LayoutManager {
    private int freeSpaceToSideBorder;
    private int freeSpaceToParallelBorder;
    private int freeSpaceBetweenLabelAndActions;
    private int freeSpaceToOpenSide;
    private Insets labelInsets = new Insets(0, 0, 0, 0);
    private Insets actionInsets = new Insets(0, 0, 0, 0);
    private TabPlacement orientation;
    private OrientedLabel label;
    private ButtonPanel actions;
    private TabConfiguration configuration;

    public TabComponentLayoutManager(OrientedLabel orientedLabel, ButtonPanel buttonPanel, TabConfiguration tabConfiguration) {
        this.label = orientedLabel;
        this.actions = buttonPanel;
        this.setOrientation(TabPlacement.TOP_OF_DOCKABLE);
        this.setConfiguration(tabConfiguration);
    }

    public ButtonPanel getActions() {
        return this.actions;
    }

    public OrientedLabel getLabel() {
        return this.label;
    }

    public TabConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TabConfiguration tabConfiguration) {
        if (tabConfiguration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = tabConfiguration;
        this.label.revalidate();
    }

    public void setFreeSpaceToOpenSide(int n) {
        this.freeSpaceToOpenSide = n;
    }

    public int getFreeSpaceToOpenSide() {
        return this.freeSpaceToOpenSide;
    }

    public void setFreeSpaceBetweenLabelAndActions(int n) {
        this.freeSpaceBetweenLabelAndActions = n;
    }

    public int getFreeSpaceBetweenLabelAndActions() {
        return this.freeSpaceBetweenLabelAndActions;
    }

    public void setFreeSpaceToParallelBorder(int n) {
        this.freeSpaceToParallelBorder = n;
    }

    public int getFreeSpaceToParallelBorder() {
        return this.freeSpaceToParallelBorder;
    }

    public void setFreeSpaceToSideBorder(int n) {
        this.freeSpaceToSideBorder = n;
    }

    public int getFreeSpaceToSideBorder() {
        return this.freeSpaceToSideBorder;
    }

    public void setLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.labelInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setActionInsets(Insets insets) {
        if (this.labelInsets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.actionInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public Insets getActionInsets() {
        return this.actionInsets;
    }

    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            this.label.setHorizontal(tabPlacement.isHorizontal());
            switch (tabPlacement) {
                case BOTTOM_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.EAST_SIDED);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    break;
                }
                case TOP_OF_DOCKABLE: {
                    this.actions.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                }
            }
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (component != this.label && component != this.actions) {
            throw new IllegalArgumentException("must add either label or panel");
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Dimension dimension2 = this.label.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            dimension = new Dimension(dimension2.width + 2 * this.freeSpaceToSideBorder + this.labelInsets.left + this.labelInsets.right, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                dimension.width += this.freeSpaceBetweenLabelAndActions;
                dimension2 = this.actions.getPreferredSize();
                dimension.width += dimension2.width + this.actionInsets.left + this.actionInsets.right;
                dimension.height = Math.max(dimension.height, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.top + this.actionInsets.bottom);
            } else {
                dimension.width += this.actionInsets.right;
                dimension.height = Math.max(dimension.height, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.bottom);
            }
        } else {
            dimension = new Dimension(dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.left + this.labelInsets.right, dimension2.height + 2 * this.freeSpaceToSideBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                dimension.height += this.freeSpaceBetweenLabelAndActions;
                dimension2 = this.actions.getPreferredSize();
                dimension.height += dimension2.height + this.actionInsets.top + this.actionInsets.bottom;
                dimension.width = Math.max(dimension.width, dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.left + this.actionInsets.right);
            } else {
                dimension.height += this.actionInsets.bottom;
                dimension.width = Math.max(dimension.width, dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.right);
            }
        }
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Dimension dimension2 = this.label.getMinimumSize();
        if (this.orientation.isHorizontal()) {
            dimension = new Dimension(dimension2.width + 2 * this.freeSpaceToSideBorder + this.labelInsets.left + this.labelInsets.right, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                dimension.width += this.freeSpaceBetweenLabelAndActions;
                dimension2 = this.actions.getMinimumSize();
                dimension.width += dimension2.width + this.actionInsets.left + this.actionInsets.right;
                dimension.height = Math.max(dimension.height, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.top + this.actionInsets.bottom);
            } else {
                dimension.width += this.actionInsets.right;
                dimension.height = Math.max(dimension.height, dimension2.height + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.bottom);
            }
        } else {
            dimension = new Dimension(dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.labelInsets.left + this.labelInsets.right, dimension2.height + 2 * this.freeSpaceToSideBorder + this.labelInsets.top + this.labelInsets.bottom);
            if (this.actions.hasActions()) {
                dimension.height += this.freeSpaceBetweenLabelAndActions;
                dimension2 = this.actions.getMinimumSize();
                dimension.height += dimension2.height + this.actionInsets.top + this.actionInsets.bottom;
                dimension.width = Math.max(dimension.width, dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.left + this.actionInsets.right);
            } else {
                dimension.height += this.actionInsets.bottom;
                dimension.width = Math.max(dimension.width, dimension2.width + this.freeSpaceToOpenSide + this.freeSpaceToParallelBorder + this.actionInsets.right);
            }
        }
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension;
        int n = container.getWidth();
        int n2 = container.getHeight();
        boolean bl = this.shouldShowActions(container);
        if (bl) {
            this.actions.setVisible(true);
            dimension = this.actions.getPreferredSize();
            dimension = new Dimension(dimension.width + this.actionInsets.left + this.actionInsets.right, dimension.height + this.actionInsets.top + this.actionInsets.bottom);
        } else {
            this.actions.setVisible(false);
            dimension = this.configuration.isHiddenActionUsingSpace() ? new Dimension(this.actionInsets.right, this.actionInsets.bottom) : new Dimension(0, 0);
        }
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToSideBorder + this.labelInsets.left, this.freeSpaceToOpenSide + this.labelInsets.top, this.labelSize(container, n - 2 * this.freeSpaceToSideBorder - dimension.width - this.labelInsets.left - this.labelInsets.right, this.freeSpaceToSideBorder + this.labelInsets.left, bl), n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.top - this.labelInsets.bottom);
                if (!bl) break;
                int n3 = Math.min(dimension.height, n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int n4 = n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - n3 - this.actionInsets.top - this.actionInsets.bottom;
                this.actions.setBounds(Math.max(0, n - this.freeSpaceToOpenSide - dimension.width + this.actionInsets.left), n2 - n3 - this.freeSpaceToParallelBorder - n4 / 2 + this.actionInsets.top, dimension.width - this.actionInsets.left - this.actionInsets.right, n3 - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToSideBorder + this.labelInsets.left, this.freeSpaceToParallelBorder + this.labelInsets.top, this.labelSize(container, n - 2 * this.freeSpaceToSideBorder - dimension.width - this.labelInsets.left - this.labelInsets.right, this.freeSpaceToSideBorder + this.labelInsets.left, bl), n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.top - this.labelInsets.bottom);
                if (!bl) break;
                int n5 = Math.min(dimension.height, n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int n6 = n2 - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - n5 - this.actionInsets.top - this.actionInsets.bottom;
                this.actions.setBounds(Math.max(0, n - this.freeSpaceToOpenSide - dimension.width + this.actionInsets.left), this.freeSpaceToParallelBorder + n6 / 2 + this.actionInsets.top, dimension.width - this.actionInsets.left - this.actionInsets.right, n5 - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToParallelBorder + this.labelInsets.left, this.freeSpaceToSideBorder + this.labelInsets.top, n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.left - this.labelInsets.right, this.labelSize(container, n2 - 2 * this.freeSpaceToSideBorder - dimension.height - this.labelInsets.top - this.labelInsets.bottom, this.freeSpaceToSideBorder + this.labelInsets.top, bl));
                if (!bl) break;
                int n7 = Math.min(dimension.width, n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int n8 = n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - n7 - this.actionInsets.left - this.actionInsets.right;
                this.actions.setBounds(this.freeSpaceToParallelBorder + n8 / 2 + this.actionInsets.left, Math.max(0, n2 - this.freeSpaceToOpenSide - dimension.height + this.actionInsets.top), n7 - this.actionInsets.left - this.actionInsets.right, dimension.height - this.actionInsets.top - this.actionInsets.bottom);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.label.setBounds(this.freeSpaceToOpenSide + this.labelInsets.left, this.freeSpaceToSideBorder + this.labelInsets.top, n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - this.labelInsets.left - this.labelInsets.right, this.labelSize(container, n2 - 2 * this.freeSpaceToSideBorder - dimension.height - this.labelInsets.top - this.labelInsets.bottom, this.freeSpaceToSideBorder + this.labelInsets.top, bl));
                if (!bl) break;
                int n9 = Math.min(dimension.width, n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder);
                int n10 = n - this.freeSpaceToOpenSide - this.freeSpaceToParallelBorder - n9 - this.actionInsets.left - this.actionInsets.right;
                this.actions.setBounds(n - n9 - this.freeSpaceToParallelBorder - n10 / 2 + this.actionInsets.left, Math.max(0, n2 - this.freeSpaceToOpenSide - dimension.height + this.actionInsets.top), n9 - this.actionInsets.left - this.actionInsets.right, dimension.height - this.actionInsets.top - this.actionInsets.bottom);
            }
        }
        this.label.setIconHidden(!this.shouldShowIcon());
    }

    private int labelSize(Container container, int n, int n2, boolean bl) {
        if (bl) {
            return n;
        }
        if (this.configuration.isKeepLabelBig() && this.label.getIcon() != null) {
            if (this.orientation.isHorizontal()) {
                return Math.min(Math.max(n, this.label.getIconOffset() + this.label.getIcon().getIconWidth()), container.getWidth() - n2);
            }
            return Math.min(Math.max(n, this.label.getIconOffset() + this.label.getIcon().getIconHeight()), container.getHeight() - n2);
        }
        return n;
    }

    protected boolean shouldShowActions(Container container) {
        if (!this.actions.hasActions()) {
            return false;
        }
        if (this.orientation.isHorizontal()) {
            int n = -1;
            int n2 = this.actions.getPreferredSize().width;
            int n3 = this.freeSpaceToSideBorder + this.freeSpaceBetweenLabelAndActions + this.freeSpaceToOpenSide + this.labelInsets.left + this.labelInsets.right + this.actionInsets.left + this.actionInsets.right;
            switch (this.getConfiguration().getActionHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    n = n2;
                    break;
                }
                case TEXT_DISAPPEARING: {
                    n = n3 + this.label.getPreferredSize().width + n2;
                    break;
                }
                case ICON_DISAPPEARING: {
                    n = this.label.getIcon() == null ? -1 : n3 + this.label.getIconOffset() + this.label.getIcon().getIconWidth() + n2;
                }
            }
            return n <= container.getWidth();
        }
        int n = -1;
        int n4 = this.actions.getPreferredSize().height;
        int n5 = this.freeSpaceToSideBorder + this.freeSpaceBetweenLabelAndActions + this.freeSpaceToOpenSide + this.labelInsets.top + this.labelInsets.bottom + this.actionInsets.top + this.actionInsets.bottom;
        switch (this.getConfiguration().getActionHiding()) {
            case NEVER: {
                return true;
            }
            case NO_SPACE_LEFT: {
                n = n4;
                break;
            }
            case TEXT_DISAPPEARING: {
                n = n5 + this.label.getPreferredSize().height + n4;
                break;
            }
            case ICON_DISAPPEARING: {
                n = this.label.getIcon() == null ? -1 : n5 + this.label.getIconOffset() + this.label.getIcon().getIconHeight() + n4;
            }
        }
        return n <= container.getHeight();
    }

    protected boolean shouldShowIcon() {
        if (this.label.getIcon() == null) {
            return true;
        }
        if (this.orientation.isHorizontal()) {
            switch (this.getConfiguration().getIconHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    return this.label.getWidth() >= this.label.getIconOffset() + this.label.getIcon().getIconWidth();
                }
                case TEXT_DISAPPEARING: {
                    return (double)this.label.getWidth() >= this.label.getPreferredSize().getWidth();
                }
            }
        } else {
            switch (this.getConfiguration().getIconHiding()) {
                case NEVER: {
                    return true;
                }
                case NO_SPACE_LEFT: {
                    return this.label.getHeight() >= this.label.getIconOffset() + this.label.getIcon().getIconHeight();
                }
                case TEXT_DISAPPEARING: {
                    return (double)this.label.getHeight() >= this.label.getPreferredSize().getHeight();
                }
            }
        }
        return true;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        throw new IllegalArgumentException("must not remove any components");
    }
}

