/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutOrder;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutPane;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;

public class MenuLineLayoutPossibility {
    private MenuLineLayoutPane pane;
    private Size menuSize;
    private Size infoSize;
    private Size tabSize;
    private static /* synthetic */ int[] $SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item;

    public MenuLineLayoutPossibility(MenuLineLayoutPane menuLineLayoutPane, Size size, Size size2, Size size3) {
        this.pane = menuLineLayoutPane;
        this.menuSize = size2;
        this.tabSize = size;
        this.infoSize = size3;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@[menu=" + this.menuSize + ", info=" + this.infoSize + ", tabs=" + this.tabSize + "]";
    }

    public double getScore() {
        return this.pane.getLayout().getStrategy().getScore(this, this.menuSize, this.infoSize, this.tabSize);
    }

    public boolean isPreferred() {
        if (this.tabSize == null || !this.tabSize.isPreferred() || !this.getPane().getTabs().isAllTabs(this.tabSize)) {
            return false;
        }
        return this.menuSize == null;
    }

    public MenuLineLayoutPane getPane() {
        return this.pane;
    }

    public Dimension getSize() {
        int n = this.tabSize.getWidth();
        int n2 = this.tabSize.getHeight();
        if (this.getPane().getPane().getDockTabPlacement().isHorizontal()) {
            if (this.menuSize != null) {
                n += this.menuSize.getWidth();
                n2 = Math.max(n2, this.menuSize.getHeight());
            }
            if (this.infoSize != null) {
                n += this.infoSize.getWidth();
                n2 = Math.max(n2, this.infoSize.getHeight());
            }
        } else {
            if (this.menuSize != null) {
                n = Math.max(n, this.menuSize.getWidth());
                n2 += this.menuSize.getHeight();
            }
            if (this.infoSize != null) {
                n = Math.max(n, this.infoSize.getWidth());
                n2 += this.infoSize.getHeight();
            }
        }
        return new Dimension(n, n2);
    }

    public void apply() {
        int n;
        Cloneable cloneable;
        MenuLineLayoutPane menuLineLayoutPane = this.getPane();
        TabPane tabPane = menuLineLayoutPane.getPane();
        MenuLineLayoutOrder menuLineLayoutOrder = menuLineLayoutPane.getLayout().getFactory().createOrder(menuLineLayoutPane.getLayout(), tabPane);
        AxisConversion axisConversion = menuLineLayoutPane.getLayout().getConversion(tabPane);
        TabPlacement tabPlacement = tabPane.getDockTabPlacement();
        MenuLayoutBlock menuLayoutBlock = menuLineLayoutPane.getMenu();
        LayoutBlock layoutBlock = menuLineLayoutPane.getInfo();
        TabsLayoutBlock tabsLayoutBlock = menuLineLayoutPane.getTabs();
        tabsLayoutBlock.setLayout(this.tabSize);
        if (this.infoSize != null && layoutBlock != null) {
            layoutBlock.setLayout(this.infoSize);
        }
        if (this.menuSize == null) {
            menuLayoutBlock.getMenu().setPaneVisible(false);
        } else {
            menuLayoutBlock.getMenu().setPaneVisible(true);
            menuLayoutBlock.setLayout(this.menuSize);
        }
        if (this.menuSize != null) {
            Object object;
            cloneable = new HashSet();
            Object object2 = tabPane.getDockables();
            int n2 = ((Dockable[])object2).length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                cloneable.add(object);
                ++n3;
            }
            object2 = tabsLayoutBlock.getTabs(this.tabSize);
            n2 = ((Tab[])object2).length;
            n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                cloneable.remove(object.getDockable());
                ++n3;
            }
            object = menuLayoutBlock.getMenu();
            Iterator iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                Dockable dockable = (Dockable)iterator.next();
                tabPane.putInMenu((TabMenu)object, dockable);
            }
        }
        cloneable = axisConversion.viewToModel(tabPane.getAvailableArea());
        if (tabPlacement.isHorizontal()) {
            n = this.tabSize.getHeight();
            if (this.infoSize != null) {
                n = Math.max(n, this.infoSize.getHeight());
            }
            if (this.menuSize != null) {
                n = Math.max(n, this.menuSize.getHeight());
            }
        } else {
            n = this.tabSize.getWidth();
            if (this.infoSize != null) {
                n = Math.max(n, this.infoSize.getWidth());
            }
            if (this.menuSize != null) {
                n = Math.max(n, this.menuSize.getWidth());
            }
        }
        n = Math.max(0, Math.min(n, ((Rectangle)cloneable).height / 2));
        tabPane.setSelectedBounds(axisConversion.modelToView(new Rectangle(((Rectangle)cloneable).x, ((Rectangle)cloneable).y + n, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height - n)));
        int[] nArray = this.calculateWidths(tabPlacement, menuLineLayoutOrder, ((Rectangle)cloneable).width, this.tabSize, this.menuSize, this.infoSize);
        int n4 = ((Rectangle)cloneable).x;
        for (Object object2 : menuLineLayoutOrder) {
            int n5 = 0;
            Size size = null;
            switch (MenuLineLayoutPossibility.$SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item()[((Enum)object2).ordinal()]) {
                case 2: {
                    n5 = nArray[0];
                    size = this.tabSize;
                    break;
                }
                case 1: {
                    n5 = nArray[1];
                    size = this.menuSize;
                    break;
                }
                case 3: {
                    n5 = nArray[2];
                    if (layoutBlock == null) break;
                    size = this.infoSize;
                }
            }
            if (size == null) continue;
            int n6 = this.calculateWidth(menuLineLayoutOrder, (MenuLineLayoutOrder.Item)((Object)object2), size, n5, tabPlacement);
            int n7 = this.calculateDeltaX(menuLineLayoutOrder, (MenuLineLayoutOrder.Item)((Object)object2), n6, n5);
            switch (MenuLineLayoutPossibility.$SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item()[((Enum)object2).ordinal()]) {
                case 3: {
                    int n8 = tabPlacement.isHorizontal() ? Math.max(0, n - this.infoSize.getHeight()) : Math.max(0, n - this.infoSize.getWidth());
                    Rectangle rectangle = new Rectangle(n4 + n7, ((Rectangle)cloneable).y + n8 / 2, n6, n - n8);
                    n4 += n5;
                    rectangle = axisConversion.modelToView(rectangle);
                    layoutBlock.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    break;
                }
                case 1: {
                    Rectangle rectangle = new Rectangle(n4 + n7, ((Rectangle)cloneable).y, n6, n);
                    n4 += n5;
                    rectangle = axisConversion.modelToView(rectangle);
                    menuLayoutBlock.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    break;
                }
                case 2: {
                    Rectangle rectangle = new Rectangle(n4 + n7, ((Rectangle)cloneable).y, n6, n);
                    rectangle = axisConversion.modelToView(rectangle);
                    n4 += n5;
                    tabsLayoutBlock.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }

    private int calculateWidth(MenuLineLayoutOrder menuLineLayoutOrder, MenuLineLayoutOrder.Item item, Size size, int n, TabPlacement tabPlacement) {
        int n2 = tabPlacement.isHorizontal() ? size.getWidth() : size.getHeight();
        int n3 = n - n2;
        if (n3 <= 0) {
            return n;
        }
        return n2 + (int)(menuLineLayoutOrder.getFill(item) * (float)n3);
    }

    private int calculateDeltaX(MenuLineLayoutOrder menuLineLayoutOrder, MenuLineLayoutOrder.Item item, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 0) {
            return 0;
        }
        return (int)((float)n3 * menuLineLayoutOrder.getAlignment(item));
    }

    private int[] calculateWidths(TabPlacement tabPlacement, MenuLineLayoutOrder menuLineLayoutOrder, int n, Size size, Size size2, Size size3) {
        int n2;
        int n3;
        int n4;
        int[] nArray = new int[3];
        int n5 = 0;
        int n6 = 0;
        float f = menuLineLayoutOrder.getWeight(MenuLineLayoutOrder.Item.TABS);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = f;
        if (tabPlacement.isHorizontal()) {
            n3 = n4 = size.getWidth();
            if (size3 != null) {
                n6 = size3.getWidth();
                f2 = menuLineLayoutOrder.getWeight(MenuLineLayoutOrder.Item.INFO);
                n3 += n6;
                f4 += f2;
            }
            if (size2 != null) {
                n5 = size2.getWidth();
                n3 += n5;
                f3 = menuLineLayoutOrder.getWeight(MenuLineLayoutOrder.Item.MENU);
                f4 += f3;
            }
        } else {
            n3 = n4 = size.getHeight();
            if (size3 != null) {
                n6 = size3.getHeight();
                n3 += n6;
                f2 = menuLineLayoutOrder.getWeight(MenuLineLayoutOrder.Item.INFO);
                f4 += f2;
            }
            if (size2 != null) {
                n5 = size2.getHeight();
                n3 += n5;
                f3 = menuLineLayoutOrder.getWeight(MenuLineLayoutOrder.Item.MENU);
                f4 += f3;
            }
        }
        int n7 = n - n3;
        float f5 = f4 == 0.0f ? 0.0f : f / f4;
        float f6 = f4 == 0.0f ? 0.0f : f3 / f4;
        float f7 = f4 == 0.0f ? 0.0f : f2 / f4;
        int n8 = 1;
        if (n7 >= 0) {
            nArray[0] = (int)((float)n4 + f5 * (float)n7);
            if (size2 != null) {
                nArray[1] = (int)((float)n5 + f6 * (float)n7);
                ++n8;
            }
            if (size3 != null) {
                nArray[2] = (int)((float)n6 + f7 * (float)n7);
                ++n8;
            }
        } else {
            float[] fArray = new float[]{n4, n5, n6};
            float[] fArray2 = new float[]{(float)n * f, (float)n * f3, (float)n * f2};
            if (size2 == null) {
                fArray2[1] = -1.0f;
            }
            if (size3 == null) {
                fArray2[2] = -1.0f;
            }
            n2 = 0;
            while (n2 < n) {
                float f8 = -1.0f;
                int n9 = -1;
                int n10 = 0;
                while (n10 < 3) {
                    if (fArray2[n10] > f8) {
                        f8 = fArray2[n10];
                        n9 = n10;
                    }
                    ++n10;
                }
                if (n9 >= 0) {
                    int n11 = n9;
                    fArray2[n11] = fArray2[n11] - 1.0f;
                    if (fArray2[n9] < 0.0f) {
                        fArray2[n9] = -0.5f;
                    }
                    int n12 = n9;
                    nArray[n12] = nArray[n12] + 1;
                    if ((float)nArray[n9] >= fArray[n9]) {
                        fArray2[n9] = -1.0f;
                    }
                }
                ++n2;
            }
            if (size2 != null) {
                ++n8;
            }
            if (size3 != null) {
                ++n8;
            }
        }
        int n13 = 0;
        int[] nArray2 = nArray;
        int n14 = nArray.length;
        n2 = 0;
        while (n2 < n14) {
            int n15 = nArray2[n2];
            n13 += n15;
            ++n2;
        }
        int n16 = n - n13;
        if (n16 != 0) {
            nArray[0] = nArray[0] + n16 / n8;
            if (size2 != null) {
                nArray[1] = nArray[1] + n16 / n8;
            }
            if (size3 != null) {
                nArray[2] = nArray[2] + n16 / n8;
            }
            n16 -= n8 * (n16 / n8);
            nArray[0] = nArray[0] + n16;
        }
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item() {
        if ($SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item != null) {
            return $SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item;
        }
        int[] nArray = new int[MenuLineLayoutOrder.Item.values().length];
        try {
            nArray[MenuLineLayoutOrder.Item.INFO.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MenuLineLayoutOrder.Item.MENU.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MenuLineLayoutOrder.Item.TABS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$bibliothek$gui$dock$station$stack$tab$MenuLineLayoutOrder$Item = nArray;
        return nArray;
    }
}

