/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManagerPane;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayout;
import bibliothek.gui.dock.station.stack.tab.MenuLineLayoutPossibility;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.MenuLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class MenuLineLayoutPane
extends AbstractTabLayoutManagerPane {
    private MenuLayoutBlock menu;
    private LayoutBlock info;
    private TabsLayoutBlock tabs;
    private MenuLineLayout layout;

    public MenuLineLayoutPane(MenuLineLayout menuLineLayout, TabPane tabPane) {
        super(tabPane);
        this.layout = menuLineLayout;
        this.menu = menuLineLayout.getFactory().createMenu(menuLineLayout, tabPane);
        this.info = menuLineLayout.getFactory().createInfo(menuLineLayout, tabPane);
        this.tabs = menuLineLayout.getFactory().createTabs(menuLineLayout, tabPane);
    }

    public TabsLayoutBlock getTabs() {
        return this.tabs;
    }

    public LayoutBlock getInfo() {
        return this.info;
    }

    public MenuLayoutBlock getMenu() {
        return this.menu;
    }

    public Dimension getPreferredSize() {
        List<MenuLineLayoutPossibility> list = this.listLayouts();
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = new Dimension();
        TabPane tabPane = this.getPane();
        Dockable[] dockableArray = tabPane.getDockables();
        int n = dockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dockable object = dockableArray[n2];
            Dimension dimension3 = tabPane.getPreferredSize(object);
            dimension2.width = Math.max(dimension2.width, dimension3.width);
            dimension2.height = Math.max(dimension2.height, dimension3.height);
            ++n2;
        }
        if (this.getPane().getDockTabPlacement().isHorizontal()) {
            for (MenuLineLayoutPossibility menuLineLayoutPossibility : list) {
                if (!menuLineLayoutPossibility.isPreferred()) continue;
                Dimension dimension4 = menuLineLayoutPossibility.getSize();
                if (dimension4.width <= dimension.width) continue;
                dimension = dimension4;
            }
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        } else {
            for (MenuLineLayoutPossibility menuLineLayoutPossibility : list) {
                if (!menuLineLayoutPossibility.isPreferred()) continue;
                Dimension dimension5 = menuLineLayoutPossibility.getSize();
                if (dimension5.height <= dimension.height) continue;
                dimension = dimension5;
            }
            dimension.width += dimension2.width;
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        List<MenuLineLayoutPossibility> list = this.listLayouts();
        Dimension dimension = null;
        Dimension dimension2 = new Dimension();
        TabPane tabPane = this.getPane();
        Dockable[] dockableArray = tabPane.getDockables();
        int n = dockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dockable object = dockableArray[n2];
            Dimension dimension3 = tabPane.getMinimumSize(object);
            dimension2.width = Math.max(dimension2.width, dimension3.width);
            dimension2.height = Math.max(dimension2.height, dimension3.height);
            ++n2;
        }
        if (this.getPane().getDockTabPlacement().isHorizontal()) {
            for (MenuLineLayoutPossibility menuLineLayoutPossibility : list) {
                Dimension dimension4 = menuLineLayoutPossibility.getSize();
                if (dimension != null && dimension4.width >= dimension.width) continue;
                dimension = dimension4;
            }
            dimension.width = this.isUseSmallMinimumSize() ? dimension2.width : Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        } else {
            for (MenuLineLayoutPossibility menuLineLayoutPossibility : list) {
                Dimension dimension5 = menuLineLayoutPossibility.getSize();
                if (dimension != null && dimension5.height >= dimension.height) continue;
                dimension = dimension5;
            }
            dimension.width += dimension2.width;
            dimension.height = this.isUseSmallMinimumSize() ? dimension2.height : Math.max(dimension.height, dimension2.height);
        }
        return dimension;
    }

    public void destroy() {
        this.getPane().destroyMenu(this.menu.getMenu());
    }

    public MenuLineLayout getLayout() {
        return this.layout;
    }

    public int getIndexOfTabAt(Point point) {
        return this.tabs.getIndexOfTabAt(point);
    }

    public void layout() {
        AxisConversion axisConversion = this.getLayout().getConversion(this.getPane());
        List<MenuLineLayoutPossibility> list = this.listLayouts();
        Rectangle rectangle = axisConversion.viewToModel(this.getPane().getAvailableArea());
        int n = rectangle.width;
        MenuLineLayoutPossibility menuLineLayoutPossibility = null;
        int n2 = -1;
        double d = 0.0;
        MenuLineLayoutPossibility menuLineLayoutPossibility2 = null;
        int n3 = -1;
        for (MenuLineLayoutPossibility menuLineLayoutPossibility3 : list) {
            Dimension dimension = axisConversion.viewToModel(menuLineLayoutPossibility3.getSize());
            if (dimension.width <= n) {
                double d2 = menuLineLayoutPossibility3.getScore();
                if (menuLineLayoutPossibility == null || d == d2 && n2 < dimension.width || d < d2) {
                    d = d2;
                    menuLineLayoutPossibility = menuLineLayoutPossibility3;
                }
            }
            if (menuLineLayoutPossibility2 != null && dimension.width >= n3) continue;
            menuLineLayoutPossibility2 = menuLineLayoutPossibility3;
            n3 = dimension.width;
        }
        if (menuLineLayoutPossibility != null) {
            menuLineLayoutPossibility.apply();
        } else if (menuLineLayoutPossibility2 != null) {
            menuLineLayoutPossibility2.apply();
        }
    }

    private List<MenuLineLayoutPossibility> listLayouts() {
        ArrayList<MenuLineLayoutPossibility> arrayList = new ArrayList<MenuLineLayoutPossibility>();
        TabPlacement tabPlacement = this.getPane().getDockTabPlacement();
        this.tabs.setOrientation(tabPlacement);
        Size[] sizeArray = this.tabs.getSizes();
        this.menu.setOrientation(tabPlacement);
        Size[] sizeArray2 = this.menu.getSizes();
        if (this.info != null) {
            Size[] sizeArray3;
            this.info.setOrientation(tabPlacement);
            Size[] sizeArray4 = sizeArray3 = this.info.getSizes();
            int n = sizeArray3.length;
            int n2 = 0;
            while (n2 < n) {
                Size size = sizeArray4[n2];
                this.listLayouts(arrayList, size, sizeArray2, sizeArray);
                ++n2;
            }
        } else {
            this.listLayouts(arrayList, null, sizeArray2, sizeArray);
        }
        return arrayList;
    }

    private void listLayouts(List<MenuLineLayoutPossibility> list, Size size, Size[] sizeArray, Size[] sizeArray2) {
        Size[] sizeArray3 = sizeArray2;
        int n = sizeArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Size size2 = sizeArray3[n2];
            if (this.tabs.isAllTabs(size2)) {
                this.listLayouts(list, size, null, size2);
            } else {
                Size[] sizeArray4 = sizeArray;
                int n3 = sizeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Size size3 = sizeArray4[n4];
                    this.listLayouts(list, size, size3, size2);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void listLayouts(List<MenuLineLayoutPossibility> list, Size size, Size size2, Size size3) {
        boolean bl;
        boolean bl2 = size != null && size.isMinimum() || size2 != null;
        boolean bl3 = size2 != null && size2.isMinimum();
        boolean bl4 = bl = size2 != null && size2.isMinimum();
        if (bl2 && !size3.isMinimum()) {
            return;
        }
        if (bl3 && this.tabs.getTabsCount(size3) > 1) {
            return;
        }
        if (bl && size != null && !size.isMinimum()) {
            return;
        }
        list.add(this.getLayout(size3, size2, size));
    }

    protected MenuLineLayoutPossibility getLayout(Size size, Size size2, Size size3) {
        return new MenuLineLayoutPossibility(this, size, size2, size3);
    }

    @Override
    public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
        super.infoComponentChanged(tabPane, lonelyTabPaneComponent, lonelyTabPaneComponent2);
        this.info = lonelyTabPaneComponent2 == null ? null : lonelyTabPaneComponent2.toLayoutBlock();
    }
}

