/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import java.util.Iterator;

public class MenuLineLayoutOrder
implements Iterable<Item> {
    private ItemConstraints[] order;

    public MenuLineLayoutOrder(Item item, Item item2, Item item3) {
        if (item == null) {
            throw new IllegalArgumentException("first must not be null");
        }
        if (item2 == null) {
            throw new IllegalArgumentException("second must not be null");
        }
        if (item3 == null) {
            throw new IllegalArgumentException("third must not be null");
        }
        if (item == item2) {
            throw new IllegalArgumentException("first and second are the same: " + (Object)((Object)item));
        }
        if (item == item3) {
            throw new IllegalArgumentException("first and third are the same: " + (Object)((Object)item));
        }
        if (item2 == item3) {
            throw new IllegalArgumentException("second and third are the same: " + (Object)((Object)item2));
        }
        this.order = new ItemConstraints[]{new ItemConstraints(item), new ItemConstraints(item2), new ItemConstraints(item3)};
    }

    @Override
    public Iterator<Item> iterator() {
        return new Iterator<Item>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < MenuLineLayoutOrder.this.order.length;
            }

            @Override
            public Item next() {
                return MenuLineLayoutOrder.this.order[this.index++].item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Item getFirst() {
        return this.order[0].item;
    }

    public Item getSecond() {
        return this.order[1].item;
    }

    public Item getThird() {
        return this.order[2].item;
    }

    private ItemConstraints get(Item item) {
        ItemConstraints[] itemConstraintsArray = this.order;
        int n = this.order.length;
        int n2 = 0;
        while (n2 < n) {
            ItemConstraints itemConstraints = itemConstraintsArray[n2];
            if (itemConstraints.item == item) {
                return itemConstraints;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unknown item: " + (Object)((Object)item));
    }

    public void setConstraints(Item item, float f, float f2, float f3) {
        this.setAlignment(item, f2);
        this.setWeight(item, f);
        this.setFill(item, f3);
    }

    public void setAlignment(Item item, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Alignment must be between 0 and 1: " + f);
        }
        this.get(item).alignment = f;
    }

    public float getAlignment(Item item) {
        return this.get(item).alignment;
    }

    public void setWeight(Item item, float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Weight must be at least 0: " + f);
        }
        this.get(item).weight = f;
    }

    public float getWeight(Item item) {
        return this.get(item).weight;
    }

    public void setFill(Item item, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Fill must be between 0 and 1: " + f);
        }
        this.get(item).fill = f;
    }

    public float getFill(Item item) {
        return this.get(item).fill;
    }

    public static enum Item {
        MENU,
        TABS,
        INFO;

    }

    private static class ItemConstraints {
        private Item item;
        private float alignment;
        private float weight;
        private float fill;

        public ItemConstraints(Item item) {
            this.item = item;
            this.alignment = 0.0f;
            this.weight = 1.0f;
            this.fill = 0.0f;
        }
    }
}

