/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTabContentFilter
implements TabContentFilter {
    private List<TabContentFilterListener> listeners = new ArrayList<TabContentFilterListener>();
    protected List<StackDockStation> stations = new ArrayList<StackDockStation>();
    protected List<StackDockComponent> components = new ArrayList<StackDockComponent>();
    private DockStationListener stationListener = new DockStationAdapter(){

        @Override
        public void dockableAdding(DockStation dockStation, Dockable dockable) {
            AbstractTabContentFilter.this.added((StackDockStation)dockStation, dockable);
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            AbstractTabContentFilter.this.removed((StackDockStation)dockStation, dockable);
        }

        @Override
        public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            if (dockable != dockable2) {
                if (dockable != null) {
                    AbstractTabContentFilter.this.deselected((StackDockStation)dockStation, dockable);
                }
                if (dockable2 != null) {
                    AbstractTabContentFilter.this.selected((StackDockStation)dockStation, dockable2);
                }
            }
        }
    };
    private StackDockComponentListener componentListener = new StackDockComponentListener(){

        @Override
        public void tabChanged(StackDockComponent stackDockComponent, Dockable dockable) {
        }

        @Override
        public void selectionChanged(StackDockComponent stackDockComponent) {
            AbstractTabContentFilter.this.selectionChanged(stackDockComponent);
        }
    };

    @Override
    public void addListener(TabContentFilterListener tabContentFilterListener) {
        if (tabContentFilterListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(tabContentFilterListener);
    }

    @Override
    public void removeListener(TabContentFilterListener tabContentFilterListener) {
        this.listeners.remove(tabContentFilterListener);
    }

    protected TabContentFilterListener[] listeners() {
        return this.listeners.toArray(new TabContentFilterListener[this.listeners.size()]);
    }

    protected void fireChanged() {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener tabContentFilterListener = tabContentFilterListenerArray[n2];
            tabContentFilterListener.contentChanged();
            ++n2;
        }
    }

    protected void fireChanged(Dockable dockable) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener tabContentFilterListener = tabContentFilterListenerArray[n2];
            tabContentFilterListener.contentChanged(dockable);
            ++n2;
        }
    }

    protected void fireChanged(StackDockStation stackDockStation) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener tabContentFilterListener = tabContentFilterListenerArray[n2];
            tabContentFilterListener.contentChanged(stackDockStation);
            ++n2;
        }
    }

    protected void fireChanged(StackDockComponent stackDockComponent) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener tabContentFilterListener = tabContentFilterListenerArray[n2];
            tabContentFilterListener.contentChanged(stackDockComponent);
            ++n2;
        }
    }

    @Override
    public void install(StackDockStation stackDockStation) {
        this.stations.add(stackDockStation);
        stackDockStation.addDockStationListener(this.stationListener);
    }

    @Override
    public void install(StackDockComponent stackDockComponent) {
        this.components.add(stackDockComponent);
        stackDockComponent.addStackDockComponentListener(this.componentListener);
    }

    @Override
    public void uninstall(StackDockStation stackDockStation) {
        this.stations.remove(stackDockStation);
        stackDockStation.removeDockStationListener(this.stationListener);
    }

    @Override
    public void uninstall(StackDockComponent stackDockComponent) {
        this.components.remove(stackDockComponent);
        stackDockComponent.removeStackDockComponentListener(this.componentListener);
    }

    @Override
    public TabContent filter(TabContent tabContent, StackDockStation stackDockStation, Dockable dockable) {
        return tabContent;
    }

    @Override
    public TabContent filter(TabContent tabContent, StackDockComponent stackDockComponent, Dockable dockable) {
        return tabContent;
    }

    protected void added(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void removed(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void selected(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void deselected(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void selectionChanged(StackDockComponent stackDockComponent) {
    }
}

