/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupCombinedMenuContent
implements CombinedMenuContent {
    private JPopupMenu menu;
    private List<CombinedMenuContentListener> listeners = new ArrayList<CombinedMenuContentListener>();

    @Override
    public void addCombinedMenuContentListener(CombinedMenuContentListener combinedMenuContentListener) {
        this.listeners.add(combinedMenuContentListener);
    }

    @Override
    public void removeCombinedMenuContentListener(CombinedMenuContentListener combinedMenuContentListener) {
        this.listeners.remove(combinedMenuContentListener);
    }

    protected CombinedMenuContentListener[] listeners() {
        return this.listeners.toArray(new CombinedMenuContentListener[this.listeners.size()]);
    }

    @Override
    public void open(DockController dockController, Component component, int n, int n2, CombinedMenuContent.Item[] itemArray) {
        Object object;
        this.cancel();
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                PopupCombinedMenuContent.this.cancel();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        Object[] objectArray = itemArray;
        int n3 = itemArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            this.menu.add(new ItemAction((CombinedMenuContent.Item)object));
            ++n4;
        }
        this.menu.show(component, n, n2);
        objectArray = this.listeners();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            object.opened(this);
            ++n4;
        }
    }

    @Override
    public void cancel() {
        if (this.menu != null) {
            JPopupMenu jPopupMenu = this.menu;
            this.menu = null;
            jPopupMenu.setVisible(false);
            CombinedMenuContentListener[] combinedMenuContentListenerArray = this.listeners();
            int n = combinedMenuContentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedMenuContentListener combinedMenuContentListener = combinedMenuContentListenerArray[n2];
                combinedMenuContentListener.canceled(this);
                ++n2;
            }
        }
    }

    public void select(Dockable dockable) {
        if (this.menu != null) {
            JPopupMenu jPopupMenu = this.menu;
            this.menu = null;
            jPopupMenu.setVisible(false);
            CombinedMenuContentListener[] combinedMenuContentListenerArray = this.listeners();
            int n = combinedMenuContentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedMenuContentListener combinedMenuContentListener = combinedMenuContentListenerArray[n2];
                combinedMenuContentListener.selected(this, dockable);
                ++n2;
            }
        }
    }

    private class ItemAction
    extends AbstractAction {
        private Dockable dockable;

        public ItemAction(CombinedMenuContent.Item item) {
            this.dockable = item.getDockable();
            this.putValue("Name", item.getText());
            this.putValue("ShortDescription", item.getToolTip());
            this.putValue("SmallIcon", item.getIcon());
            this.setEnabled(item.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PopupCombinedMenuContent.this.select(this.dockable);
        }
    }
}

