/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import javax.swing.Icon;

public abstract class ButtonCombinedMenu<B extends Component>
extends AbstractCombinedMenu {
    private B button;
    private TabMenuDockIcon icon = new TabMenuDockIcon("dock.menu.overflow", this){

        @Override
        protected void changed(Icon icon, Icon icon2) {
            ButtonCombinedMenu.this.currentIcon = icon2;
            if (ButtonCombinedMenu.this.button != null) {
                ButtonCombinedMenu.this.getModel(ButtonCombinedMenu.this.button).setIcon(ActionContentModifier.NONE, icon2);
            }
        }
    };
    private Icon currentIcon;

    public ButtonCombinedMenu(TabPane tabPane, CombinedHandler<? super AbstractCombinedMenu> combinedHandler) {
        super(tabPane, combinedHandler);
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        if (dockController == null) {
            this.icon.setManager(null);
        } else {
            this.icon.setManager(dockController.getIcons());
        }
    }

    @Override
    protected void backgroundChanged(BackgroundPaint backgroundPaint) {
        if (this.button != null) {
            this.getModel(this.button).setBackground(backgroundPaint, this.getBackground());
        }
    }

    @Override
    protected Component createComponent() {
        BasicTrigger basicTrigger = new BasicTrigger(){

            @Override
            public void triggered() {
                ButtonCombinedMenu.this.open();
            }

            @Override
            public DockAction getAction() {
                return null;
            }

            @Override
            public Dockable getDockable() {
                return null;
            }
        };
        this.button = this.createButton(basicTrigger);
        this.getModel(this.button).setIcon(ActionContentModifier.NONE, this.currentIcon);
        return this.button;
    }

    public B getButton() {
        return this.button;
    }

    protected abstract B createButton(BasicTrigger var1);

    protected abstract BasicButtonModel getModel(B var1);

    @Override
    protected void ensureComponent() {
        boolean bl = this.button == null;
        super.ensureComponent();
        if (bl) {
            BackgroundAlgorithm backgroundAlgorithm = this.getBackground();
            this.getModel(this.button).setBackground(backgroundAlgorithm.getPaint(), backgroundAlgorithm);
        }
    }

    @Override
    protected void selected(Dockable dockable) {
        this.getTabParent().setSelectedDockable(dockable);
    }
}

