/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuListener;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneMenuBackgroundComponent;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractCombinedMenu
extends AbstractTabPaneComponent
implements CombinedMenu {
    private Component component;
    private Background background = new Background();
    private PropertyValue<CombinedMenuContent> content = new PropertyValue<CombinedMenuContent>(CombinedMenuContent.MENU_CONTENT){

        @Override
        protected void valueChanged(CombinedMenuContent combinedMenuContent, CombinedMenuContent combinedMenuContent2) {
        }
    };
    private List<Entry> entries = new ArrayList<Entry>();
    private DockController controller;
    private CombinedHandler<? super AbstractCombinedMenu> handler;
    private List<TabMenuListener> listeners = new ArrayList<TabMenuListener>();

    public AbstractCombinedMenu(TabPane tabPane, CombinedHandler<? super AbstractCombinedMenu> combinedHandler) {
        super(tabPane);
        this.handler = combinedHandler;
    }

    protected void ensureComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
    }

    protected BackgroundAlgorithm getBackground() {
        return this.background;
    }

    protected void backgroundChanged(BackgroundPaint backgroundPaint) {
    }

    protected abstract Component createComponent();

    public void open() {
        Handler handler = new Handler();
        handler.open();
    }

    protected void closed() {
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        this.content.setProperties(dockController);
        this.background.setController(dockController);
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addTabMenuListener(TabMenuListener tabMenuListener) {
        if (tabMenuListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(tabMenuListener);
    }

    @Override
    public void removeTabMenuListener(TabMenuListener tabMenuListener) {
        this.listeners.remove(tabMenuListener);
    }

    protected TabMenuListener[] tabMenuListeners() {
        return this.listeners.toArray(new TabMenuListener[this.listeners.size()]);
    }

    @Override
    public void setPaneVisible(boolean bl) {
        this.handler.setVisible(this, bl);
    }

    @Override
    public boolean isPaneVisible() {
        return this.handler.isVisible(this);
    }

    @Override
    public void setZOrder(int n) {
        this.handler.setZOrder(this, n);
    }

    @Override
    public int getZOrder() {
        return this.handler.getZOrder(this);
    }

    protected abstract void selected(Dockable var1);

    @Override
    public Component getComponent() {
        this.ensureComponent();
        return this.component;
    }

    @Override
    public void setIcon(int n, Icon icon) {
        this.entries.get((int)n).icon = icon;
    }

    @Override
    public void setText(int n, String string) {
        this.entries.get((int)n).text = string;
    }

    @Override
    public void setTooltip(int n, String string) {
        this.entries.get((int)n).tooltip = string;
    }

    @Override
    public void setEnabled(int n, boolean bl) {
        this.entries.get((int)n).enabled = bl;
    }

    @Override
    public void insert(int n, Dockable dockable) {
        Entry entry = new Entry();
        entry.dockable = dockable;
        entry.icon = dockable.getTitleIcon();
        entry.text = dockable.getTitleText();
        entry.tooltip = dockable.getTitleToolTip();
        this.entries.add(n, entry);
        TabMenuListener[] tabMenuListenerArray = this.tabMenuListeners();
        int n2 = tabMenuListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TabMenuListener tabMenuListener = tabMenuListenerArray[n3];
            tabMenuListener.dockablesAdded(this, n, 1);
            ++n3;
        }
    }

    @Override
    public void remove(Dockable dockable) {
        int n = 0;
        int n2 = this.entries.size();
        while (n < n2) {
            if (this.entries.get((int)n).dockable == dockable) {
                this.entries.remove(n);
                TabMenuListener[] tabMenuListenerArray = this.tabMenuListeners();
                int n3 = tabMenuListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    TabMenuListener tabMenuListener = tabMenuListenerArray[n4];
                    tabMenuListener.dockablesRemoved(this, n, 1);
                    ++n4;
                }
                return;
            }
            ++n;
        }
    }

    @Override
    public Dockable[] getDockables() {
        Dockable[] dockableArray = new Dockable[this.entries.size()];
        int n = 0;
        while (n < dockableArray.length) {
            dockableArray[n] = this.entries.get((int)n).dockable;
            ++n;
        }
        return dockableArray;
    }

    @Override
    public int getDockableCount() {
        return this.entries.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.entries.get((int)n).dockable;
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneMenuBackgroundComponent {
        public Background() {
            super(TabPaneMenuBackgroundComponent.KIND, "dock.background.tabPane.child.menu");
        }

        @Override
        public void set(BackgroundPaint backgroundPaint) {
            super.set(backgroundPaint);
            AbstractCombinedMenu.this.backgroundChanged(this.getPaint());
        }

        @Override
        public TabMenu getMenu() {
            return AbstractCombinedMenu.this;
        }

        @Override
        public TabPaneComponent getChild() {
            return AbstractCombinedMenu.this;
        }

        @Override
        public TabPane getPane() {
            return this.getMenu().getTabParent();
        }

        @Override
        public Component getComponent() {
            return AbstractCombinedMenu.this.component;
        }
    }

    private static class Entry {
        public Dockable dockable;
        public String text;
        public String tooltip;
        public Icon icon;
        public boolean enabled = true;

        private Entry() {
        }

        public CombinedMenuContent.Item toItem() {
            return new CombinedMenuContent.Item(this.dockable, this.text, this.tooltip, this.icon, this.enabled);
        }
    }

    private class Handler
    implements CombinedMenuContentListener {
        private CombinedMenuContent menu;

        public Handler() {
            this.menu = (CombinedMenuContent)AbstractCombinedMenu.this.content.getValue();
        }

        public void open() {
            if (this.menu == null) {
                return;
            }
            Component component = AbstractCombinedMenu.this.getComponent();
            CombinedMenuContent.Item[] itemArray = new CombinedMenuContent.Item[AbstractCombinedMenu.this.entries.size()];
            int n = 0;
            while (n < itemArray.length) {
                itemArray[n] = ((Entry)AbstractCombinedMenu.this.entries.get(n)).toItem();
                ++n;
            }
            this.menu.addCombinedMenuContentListener(this);
            this.menu.open(AbstractCombinedMenu.this.controller, component, 0, component.getHeight(), itemArray);
        }

        @Override
        public void opened(CombinedMenuContent combinedMenuContent) {
        }

        @Override
        public void canceled(CombinedMenuContent combinedMenuContent) {
            combinedMenuContent.removeCombinedMenuContentListener(this);
        }

        @Override
        public void selected(CombinedMenuContent combinedMenuContent, Dockable dockable) {
            combinedMenuContent.removeCombinedMenuContentListener(this);
            AbstractCombinedMenu.this.selected(dockable);
        }
    }
}

