/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DockActionDistributorSource
extends AbstractDockActionSource {
    private DockActionDistributor.Target target;
    private DockActionSource source;
    private Dockable dockable;
    private boolean buildSourceCheck = false;
    private DockHierarchyListener listener = new DockHierarchyListener(){

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            DockActionDistributorSource.this.reset();
        }
    };
    private PropertyValue<DockActionDistributor> distributor = new PropertyValue<DockActionDistributor>(new PropertyKey("dock.empty")){

        @Override
        protected void valueChanged(DockActionDistributor dockActionDistributor, DockActionDistributor dockActionDistributor2) {
            DockActionDistributorSource.this.buildSource(false);
        }
    };
    private DockActionSourceListener actionListener = new DockActionSourceListener(){

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            DockActionDistributorSource.this.fireRemoved(n, n2);
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            DockActionDistributorSource.this.fireAdded(n, n2);
        }
    };

    public DockActionDistributorSource(DockActionDistributor.Target target, PropertyKey<DockActionDistributor> propertyKey) {
        this.target = target;
        this.distributor.setKey(propertyKey);
    }

    public DockActionDistributorSource(DockActionDistributor.Target target, PropertyKey<DockActionDistributor> propertyKey, Dockable dockable) {
        this(target, propertyKey);
        this.setDockable(dockable);
    }

    private DockActionSource source() {
        if (this.dockable == null) {
            return null;
        }
        if (this.source != null) {
            return this.source;
        }
        DockController dockController = this.dockable.getController();
        if (dockController == null) {
            return null;
        }
        DockActionDistributor dockActionDistributor = dockController.getProperties().get(this.distributor.getKey());
        return dockActionDistributor.createSource(this.dockable, this.target);
    }

    @Override
    public DockAction getDockAction(int n) {
        DockActionSource dockActionSource = this.source();
        return dockActionSource.getDockAction(n);
    }

    @Override
    public int getDockActionCount() {
        DockActionSource dockActionSource = this.source();
        if (dockActionSource == null) {
            return 0;
        }
        return dockActionSource.getDockActionCount();
    }

    @Override
    public LocationHint getLocationHint() {
        DockActionSource dockActionSource = this.source();
        if (dockActionSource == null) {
            return LocationHint.UNKNOWN;
        }
        return dockActionSource.getLocationHint();
    }

    @Override
    public Iterator<DockAction> iterator() {
        DockActionSource dockActionSource = this.source();
        if (dockActionSource == null) {
            return new Iterator<DockAction>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DockAction next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                }
            };
        }
        return dockActionSource.iterator();
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this.listener);
                this.dockable = null;
                this.setSource(null);
            }
            this.dockable = dockable;
            if (this.dockable != null) {
                if (this.hasListeners()) {
                    this.dockable.addDockHierarchyListener(this.listener);
                }
                this.reset();
            }
        }
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (!this.hasListeners() && this.dockable != null) {
            this.dockable.addDockHierarchyListener(this.listener);
            this.distributor.setProperties(this.dockable.getController());
            this.buildSource(true);
        }
        super.addDockActionSourceListener(dockActionSourceListener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (!this.hasListeners() && this.dockable != null) {
            this.dockable.removeDockHierarchyListener(this.listener);
            this.distributor.setProperties((DockProperties)null);
            this.setSource(null);
        }
    }

    private void setSource(DockActionSource dockActionSource) {
        if (this.source != dockActionSource) {
            int n;
            if (this.source != null) {
                n = this.getDockActionCount();
                this.source.removeDockActionSourceListener(this.actionListener);
                this.source = null;
                if (n > 0) {
                    this.fireRemoved(0, n - 1);
                }
            }
            this.source = dockActionSource;
            if (this.source != null) {
                n = this.getDockActionCount();
                if (n > 0) {
                    this.fireAdded(0, n - 1);
                }
                this.source.addDockActionSourceListener(this.actionListener);
            }
        }
    }

    private void reset() {
        if (this.dockable != null && this.hasListeners()) {
            DockController dockController = this.dockable.getController();
            if (dockController == null) {
                this.setSource(null);
            }
            this.buildSourceCheck = true;
            this.distributor.setProperties(dockController);
            if (this.buildSourceCheck) {
                this.buildSource(false);
            }
        }
    }

    private void buildSource(boolean bl) {
        if (bl || this.hasListeners()) {
            this.buildSourceCheck = false;
            if (this.dockable != null) {
                this.setSource(this.distributor.getValue().createSource(this.dockable, this.target));
            }
        }
    }
}

