/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.FilteredDockActionSource;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.InfoDockAction;
import bibliothek.gui.dock.station.stack.action.TabDockAction;
import bibliothek.gui.dock.station.stack.action.TitleDockAction;

public class DefaultDockActionDistributor
implements DockActionDistributor {
    @Override
    public DockActionSource createSource(Dockable dockable, DockActionDistributor.Target target) {
        if (target == DockActionDistributor.Target.TAB) {
            return this.createTabSource(dockable.getGlobalActionOffers());
        }
        if (target == DockActionDistributor.Target.TITLE) {
            return this.createTitleSource(dockable.getGlobalActionOffers());
        }
        if (target == DockActionDistributor.Target.INFO_COMPONENT) {
            return this.createInfoSource(dockable.getGlobalActionOffers());
        }
        throw new IllegalArgumentException("unkown target: " + target);
    }

    protected DockActionSource createTabSource(DockActionSource dockActionSource) {
        return new FilteredDockActionSource(dockActionSource){

            @Override
            protected boolean include(DockAction dockAction) {
                return dockAction.getClass().getAnnotation(TabDockAction.class) != null;
            }
        };
    }

    protected DockActionSource createInfoSource(DockActionSource dockActionSource) {
        return new FilteredDockActionSource(dockActionSource){

            @Override
            protected boolean include(DockAction dockAction) {
                return dockAction.getClass().getAnnotation(InfoDockAction.class) != null;
            }
        };
    }

    protected DockActionSource createTitleSource(DockActionSource dockActionSource) {
        return new FilteredDockActionSource(dockActionSource){

            @Override
            protected boolean include(DockAction dockAction) {
                Class<?> clazz = dockAction.getClass();
                if (clazz.getAnnotation(TitleDockAction.class) != null) {
                    return true;
                }
                return clazz.getAnnotation(TabDockAction.class) == null && clazz.getAnnotation(InfoDockAction.class) == null;
            }
        };
    }
}

