/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.stack.RetroStackDockStationLayout;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class StackDockStationFactory
implements DockFactory<StackDockStation, StackDockPerspective, StackDockStationLayout> {
    public static final String ID = "StackDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public StackDockStationLayout getLayout(StackDockStation stackDockStation, Map<Dockable, Integer> map) {
        Dockable dockable = stackDockStation.getFrontDockable();
        int n = -1;
        if (dockable != null) {
            n = stackDockStation.indexOf(dockable);
        }
        PlaceholderMap placeholderMap = stackDockStation.getPlaceholders(map);
        return new StackDockStationLayout(n, placeholderMap);
    }

    @Override
    public void estimateLocations(StackDockStationLayout stackDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            int[] nArray = retroStackDockStationLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getChild(n3);
                if (dockLayoutInfo != null) {
                    StackDockProperty stackDockProperty = new StackDockProperty(n3, dockLayoutInfo.getPlaceholder());
                    dockLayoutInfo.setLocation(stackDockProperty);
                }
                ++n2;
            }
        } else {
            DockablePlaceholderList.simulatedRead(stackDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<Dockable, PlaceholderListItem<Dockable>>(){

                @Override
                public PlaceholderListItem<Dockable> convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    int n2 = convertedPlaceholderListItem.getInt("index");
                    Path path = null;
                    if (convertedPlaceholderListItem.contains("placeholder")) {
                        path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                    }
                    StackDockProperty stackDockProperty = new StackDockProperty(n2, path);
                    locationEstimationMap.getChild(n).setLocation(stackDockProperty);
                    int n3 = 0;
                    int n4 = locationEstimationMap.getSubChildCount(n);
                    while (n3 < n4) {
                        DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, n3);
                        dockLayoutInfo.setLocation(new StackDockProperty(n2, dockLayoutInfo.getPlaceholder()));
                        ++n3;
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        DockController dockController = stackDockStation.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = stackDockStation.getDockableCount() - 1;
            while (n >= 0) {
                stackDockStation.remove(n);
                --n;
            }
            if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
                RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
                int[] nArray = retroStackDockStationLayout.getChildren();
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray[n3];
                    Dockable dockable = map.get(n4);
                    if (dockable != null) {
                        stackDockStation.drop(dockable);
                    }
                    ++n3;
                }
            } else {
                stackDockStation.setPlaceholders(stackDockStationLayout.getPlaceholders().filter(placeholderStrategy), map);
            }
            Dockable dockable = map.get(stackDockStationLayout.getSelected());
            if (dockable != null) {
                stackDockStation.setFrontDockable(dockable);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public StackDockPerspective layoutPerspective(StackDockStationLayout stackDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        StackDockPerspective stackDockPerspective = new StackDockPerspective();
        this.layoutPerspective(stackDockPerspective, stackDockStationLayout, map);
        return stackDockPerspective;
    }

    @Override
    public void layoutPerspective(StackDockPerspective stackDockPerspective, StackDockStationLayout stackDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        stackDockPerspective.read(stackDockStationLayout.getPlaceholders(), map, stackDockStationLayout.getSelected());
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout, map, placeholderStrategy);
        return stackDockStation;
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout, placeholderStrategy);
        return stackDockStation;
    }

    @Override
    public StackDockStationLayout getPerspectiveLayout(StackDockPerspective stackDockPerspective, Map<PerspectiveDockable, Integer> map) {
        Integer n = null;
        if (map != null) {
            n = map.get(stackDockPerspective.getSelection());
        }
        return new StackDockStationLayout(n == null ? -1 : n, stackDockPerspective.toMap(map));
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            Version.write(dataOutputStream, Version.VERSION_1_0_4);
            dataOutputStream.writeInt(stackDockStationLayout.getSelected());
            dataOutputStream.writeInt(retroStackDockStationLayout.getChildren().length);
            int[] nArray = retroStackDockStationLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                dataOutputStream.writeInt(n3);
                ++n2;
            }
        } else {
            Version.write(dataOutputStream, Version.VERSION_1_0_8);
            dataOutputStream.writeInt(stackDockStationLayout.getSelected());
            stackDockStationLayout.getPlaceholders().write(dataOutputStream);
        }
    }

    @Override
    public StackDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        boolean bl;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        if (bl) {
            int n = dataInputStream.readInt();
            PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new StackDockStationLayout(n, placeholderMap);
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = dataInputStream.readInt();
            ++n3;
        }
        return new RetroStackDockStationLayout(n, nArray);
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, XElement xElement) {
        if (stackDockStationLayout.getSelected() >= 0) {
            xElement.addElement("selected").setInt(stackDockStationLayout.getSelected());
        }
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            XElement xElement2 = xElement.addElement("children");
            int[] nArray = retroStackDockStationLayout.getChildren();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                xElement2.addElement("child").addInt("id", n3);
                ++n2;
            }
        } else {
            stackDockStationLayout.getPlaceholders().write(xElement.addElement("placeholders"));
        }
    }

    @Override
    public StackDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2;
        XElement xElement3 = xElement.getElement("selected");
        int n = -1;
        if (xElement3 != null) {
            n = xElement3.getInt();
        }
        if ((xElement2 = xElement.getElement("placeholders")) == null) {
            int[] nArray;
            XElement xElement4 = xElement.getElement("children");
            if (xElement4 != null) {
                XElement[] xElementArray = xElement4.getElements("child");
                nArray = new int[xElementArray.length];
                int n2 = 0;
                int n3 = xElementArray.length;
                while (n2 < n3) {
                    nArray[n2] = xElementArray[n2].getInt("id");
                    ++n2;
                }
            } else {
                nArray = new int[]{};
            }
            return new RetroStackDockStationLayout(n, nArray);
        }
        PlaceholderMap placeholderMap = new PlaceholderMap(xElement2, placeholderStrategy);
        return new StackDockStationLayout(n, placeholderMap);
    }

    protected StackDockStation createStation() {
        return new StackDockStation();
    }
}

