/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class StackDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectivePlaceholderList<PerspectiveDockable> dockables = new PerspectivePlaceholderList();
    private PerspectiveDockable selection;
    private PerspectiveStation parent;

    public StackDockPerspective() {
    }

    public StackDockPerspective(PerspectiveDockable[] perspectiveDockableArray, PerspectiveDockable perspectiveDockable) {
        boolean bl = false;
        PerspectiveDockable[] perspectiveDockableArray2 = perspectiveDockableArray;
        int n = perspectiveDockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            PerspectiveDockable perspectiveDockable2 = perspectiveDockableArray2[n2];
            DockUtilities.ensureTreeValidity(this, perspectiveDockable2);
            perspectiveDockable2.setParent(this);
            this.dockables.dockables().add(perspectiveDockable2);
            if (perspectiveDockable2 == perspectiveDockable) {
                bl = true;
            }
            ++n2;
        }
        if (perspectiveDockable != null && !bl) {
            throw new IllegalArgumentException("selected dockable is not child of this station");
        }
        this.selection = perspectiveDockable;
    }

    public void read(PlaceholderMap placeholderMap, final Map<Integer, PerspectiveDockable> map, int n) {
        PerspectivePlaceholderList<PerspectiveDockable> perspectivePlaceholderList = new PerspectivePlaceholderList<PerspectiveDockable>();
        perspectivePlaceholderList.read(placeholderMap, new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                if (map == null) {
                    return null;
                }
                int n = convertedPlaceholderListItem.getInt("id");
                PerspectiveDockable perspectiveDockable = (PerspectiveDockable)map.get(n);
                perspectiveDockable.setParent(StackDockPerspective.this);
                return perspectiveDockable;
            }
        });
        this.dockables = perspectivePlaceholderList;
        if (map != null) {
            this.selection = map.get(n);
        }
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholderMap);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap toMap(final Map<PerspectiveDockable, Integer> map) {
        return this.dockables.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, PerspectiveDockable perspectiveDockable) {
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", (Integer)map.get(perspectiveDockable));
                convertedPlaceholderListItem.putInt("index", n);
                Path path = perspectiveDockable.getPlaceholder();
                if (path != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    public void addPlaceholder(PerspectiveDockable perspectiveDockable) {
        this.insertPlaceholder(this.getDockableCount(), perspectiveDockable);
    }

    public void addPlaceholder(Path path) {
        this.insertPlaceholder(this.getDockableCount(), path, PlaceholderList.Level.DOCKABLE);
    }

    public void insertPlaceholder(int n, PerspectiveDockable perspectiveDockable) {
        this.insertPlaceholder(n, perspectiveDockable.getPlaceholder(), PlaceholderList.Level.DOCKABLE);
    }

    public void insertPlaceholder(int n, Path path, PlaceholderList.Level level) {
        switch (level) {
            case BASE: {
                this.dockables.list().insertPlaceholder(n, path);
                break;
            }
            case DOCKABLE: {
                this.dockables.dockables().insertPlaceholder(n, path);
                break;
            }
            case PLACEHOLDER: {
                this.dockables.purePlaceholders().insertPlaceholder(n, path);
            }
        }
    }

    public void add(PerspectiveDockable perspectiveDockable) {
        this.insert(this.getDockableCount(), perspectiveDockable);
    }

    public void insert(int n, PerspectiveDockable perspectiveDockable) {
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        if (perspectiveDockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockables.dockables().add(n, perspectiveDockable);
    }

    public int indexOf(PerspectiveDockable perspectiveDockable) {
        return this.dockables.dockables().indexOf(perspectiveDockable);
    }

    public int indexOf(Path path) {
        return this.dockables.getDockableIndex(path);
    }

    @Override
    public boolean remove(PerspectiveDockable perspectiveDockable) {
        int n = this.indexOf(perspectiveDockable);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public PerspectiveDockable remove(int n) {
        PerspectiveDockable perspectiveDockable = (PerspectiveDockable)this.dockables.dockables().get(n);
        this.dockables.remove(perspectiveDockable);
        perspectiveDockable.setParent(null);
        if (this.selection == perspectiveDockable) {
            this.selection = null;
        }
        return perspectiveDockable;
    }

    @Override
    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.indexOf(perspectiveDockable);
        if (n < 0) {
            throw new IllegalArgumentException("oldDockable is not a child of this station");
        }
        DockUtilities.ensureTreeValidity(this, perspectiveDockable2);
        boolean bl = this.selection == perspectiveDockable;
        this.remove(n);
        this.insert(n, perspectiveDockable2);
        if (bl) {
            this.setSelection(perspectiveDockable2);
        }
    }

    public void setSelection(PerspectiveDockable perspectiveDockable) {
        if (perspectiveDockable != null && this.indexOf(perspectiveDockable) < 0) {
            throw new IllegalArgumentException("dockable is not a child of this station");
        }
        this.selection = perspectiveDockable;
    }

    public PerspectiveDockable getSelection() {
        return this.selection;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.indexOf(perspectiveDockable);
        Path path = null;
        path = perspectiveDockable2 != null ? perspectiveDockable2.getPlaceholder() : perspectiveDockable.getPlaceholder();
        return new StackDockProperty(n, path);
    }

    @Override
    public void setParent(PerspectiveStation perspectiveStation) {
        this.parent = perspectiveStation;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    @Override
    public PerspectiveDockable getDockable(int n) {
        return (PerspectiveDockable)this.dockables.dockables().get(n);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    public int getItemCount() {
        return this.dockables.list().size();
    }
}

