/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Component;
import java.awt.Dimension;

public abstract class DockActionCombinedInfoComponent
extends AbstractTabPaneComponent
implements CombinedInfoComponent,
LayoutBlock {
    private CombinedStackDockComponent<?, ?, ?> pane;
    private ButtonPanel buttons;
    private Dockable dockable;
    private TabPaneListener listener = new TabPaneListener(){

        @Override
        public void selectionChanged(TabPane tabPane) {
            DockActionCombinedInfoComponent.this.setSelection(tabPane.getSelectedDockable());
        }

        @Override
        public void removed(TabPane tabPane, Dockable dockable) {
        }

        @Override
        public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
        }

        @Override
        public void added(TabPane tabPane, Dockable dockable) {
        }

        @Override
        public void controllerChanged(TabPane tabPane, DockController dockController) {
            DockActionCombinedInfoComponent.this.setController(dockController);
        }
    };

    public DockActionCombinedInfoComponent(CombinedStackDockComponent<?, ?, ?> combinedStackDockComponent) {
        super(combinedStackDockComponent);
        this.pane = combinedStackDockComponent;
        this.buttons = new ButtonPanel(true);
        combinedStackDockComponent.addTabPaneListener(this.listener);
        this.setController(combinedStackDockComponent.getController());
    }

    public void destroy() {
        this.pane.removeTabPaneListener(this.listener);
        this.setController(null);
    }

    public void setSelection(Dockable dockable) {
        this.dockable = dockable;
        this.updateContent();
    }

    public Dockable getSelection() {
        return this.dockable;
    }

    public void setController(DockController dockController) {
        this.buttons.setController(dockController);
    }

    protected void updateContent() {
        if (this.dockable == null) {
            this.buttons.set(null, null);
        } else {
            this.buttons.set(this.dockable, this.createActionSource(this.dockable));
        }
    }

    protected abstract DockActionSource createActionSource(Dockable var1);

    @Override
    public Component getComponent() {
        return this.buttons;
    }

    @Override
    public boolean isPaneVisible() {
        return this.pane.getInfoHandler().isVisible(this);
    }

    @Override
    public void setPaneVisible(boolean bl) {
        this.pane.getInfoHandler().setVisible(this, bl);
    }

    @Override
    public int getZOrder() {
        return this.pane.getInfoHandler().getZOrder(this);
    }

    @Override
    public void setZOrder(int n) {
        this.pane.getInfoHandler().setZOrder(this, n);
    }

    @Override
    public LayoutBlock toLayoutBlock() {
        return this;
    }

    @Override
    public void setOrientation(TabPlacement tabPlacement) {
        super.setOrientation(tabPlacement);
        this.buttons.setOrientation(tabPlacement.toOrientation());
    }

    @Override
    public Size[] getSizes() {
        Dimension[] dimensionArray = this.buttons.getPreferredSizes();
        Size[] sizeArray = new Size[dimensionArray.length];
        int n = 0;
        while (n < dimensionArray.length) {
            Size.Type type = n + 1 == dimensionArray.length ? Size.Type.PREFERRED : Size.Type.MINIMUM;
            sizeArray[n] = new CountingSize(type, dimensionArray[n], n, (double)(n + 1) / (double)dimensionArray.length);
            ++n;
        }
        return sizeArray;
    }

    @Override
    public void setLayout(Size size) {
        if (!(size instanceof CountingSize)) {
            throw new IllegalArgumentException("size not created by this component");
        }
        this.buttons.setVisibleActions(((CountingSize)size).getCount());
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.buttons.setBounds(n, n2, n3, n4);
    }

    private static class CountingSize
    extends Size {
        private int count;

        public CountingSize(Size.Type type, Dimension dimension, int n, double d) {
            super(type, dimension, d);
            this.count = n;
        }

        public int getCount() {
            return this.count;
        }
    }
}

