/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.stack.DefaultDndAutoSelectStrategyRequest;
import bibliothek.gui.dock.station.stack.DndAutoSelectStrategy;
import bibliothek.gui.dock.station.stack.StackDnDAutoSelectSupport;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.util.container.Tuple;
import java.awt.Component;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class DnDAutoSelectSupport
extends TransferHandler
implements StackDnDAutoSelectSupport {
    private Map<JComponent, Tuple<StackDockStation, StackDockComponent>> components = new HashMap<JComponent, Tuple<StackDockStation, StackDockComponent>>();

    @Override
    public void install(StackDockStation stackDockStation, StackDockComponent stackDockComponent) {
        Component component = stackDockComponent.getComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setTransferHandler(this);
            this.components.put(jComponent, Tuple.of(stackDockStation, stackDockComponent));
        }
    }

    @Override
    public void uninstall(StackDockComponent stackDockComponent) {
        Component component = stackDockComponent.getComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setTransferHandler(null);
            this.components.remove(jComponent);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        Tuple<StackDockStation, StackDockComponent> tuple;
        if (transferSupport.isDrop() && (tuple = this.components.get(transferSupport.getComponent())) != null) {
            this.forward((StackDockStation)tuple.getA(), tuple.getB(), transferSupport);
        }
        return false;
    }

    private void forward(StackDockStation stackDockStation, StackDockComponent stackDockComponent, TransferHandler.TransferSupport transferSupport) {
        TransferHandler.DropLocation dropLocation = transferSupport.getDropLocation();
        Point point = dropLocation.getDropPoint();
        int n = stackDockComponent.getIndexOfTabAt(point);
        if (n != -1) {
            this.forward(stackDockStation, stackDockComponent.getDockableAt(n), transferSupport);
        }
    }

    private void forward(StackDockStation stackDockStation, Dockable dockable, TransferHandler.TransferSupport transferSupport) {
        DockController dockController = stackDockStation.getController();
        DndAutoSelectStrategy dndAutoSelectStrategy = dockController.getProperties().get(StackDockStation.DND_AUTO_SELECT_STRATEGY);
        if (dndAutoSelectStrategy != null) {
            dndAutoSelectStrategy.handleRequest(new DefaultDndAutoSelectStrategyRequest(stackDockStation, dockable, transferSupport));
        }
    }
}

