/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.disable.TabDisablingStrategyObserver;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class DefaultStackDockComponent
extends JTabbedPane
implements StackDockComponent {
    private List<Tab> dockables = new ArrayList<Tab>();
    private DockController controller;
    private Tab mouseTarget;
    private List<StackDockComponentListener> listeners = new ArrayList<StackDockComponentListener>();
    private TabDisablingStrategyObserver tabDisabling = new TabDisablingStrategyObserver(){

        @Override
        public void setDisabled(Dockable dockable, boolean bl) {
            int n = DefaultStackDockComponent.this.indexOf(dockable);
            if (n >= 0) {
                DefaultStackDockComponent.this.setEnabledAt(n, !bl);
            }
        }
    };

    public DefaultStackDockComponent() {
        super(3);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addChangeListener(listener);
        this.setOpaque(false);
    }

    @Override
    public void addStackDockComponentListener(StackDockComponentListener stackDockComponentListener) {
        this.listeners.add(stackDockComponentListener);
    }

    @Override
    public void removeStackDockComponentListener(StackDockComponentListener stackDockComponentListener) {
        this.listeners.remove(stackDockComponentListener);
    }

    @Override
    public void setDockTabPlacement(TabPlacement tabPlacement) {
        switch (tabPlacement) {
            case BOTTOM_OF_DOCKABLE: {
                this.setTabPlacement(3);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.setTabPlacement(2);
                break;
            }
            case TOP_OF_DOCKABLE: {
                this.setTabPlacement(1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.setTabPlacement(4);
            }
        }
    }

    @Override
    public TabPlacement getDockTabPlacement() {
        switch (this.getTabPlacement()) {
            case 3: {
                return TabPlacement.BOTTOM_OF_DOCKABLE;
            }
            case 2: {
                return TabPlacement.LEFT_OF_DOCKABLE;
            }
            case 4: {
                return TabPlacement.RIGHT_OF_DOCKABLE;
            }
            case 1: {
                return TabPlacement.TOP_OF_DOCKABLE;
            }
        }
        throw new IllegalStateException("unknown position: " + this.getTabPlacement());
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        this.insertTab(string, icon, component, (String)null, n);
        Tab tab = this.createTab(dockable);
        this.dockables.add(n, tab);
        tab.setController(this.controller);
        this.tabDisabling.add(dockable);
    }

    protected Tab createTab(Dockable dockable) {
        return new Tab(dockable);
    }

    @Override
    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.addTab(string, icon, component);
        Tab tab = this.createTab(dockable);
        this.dockables.add(tab);
        tab.setController(this.controller);
        this.tabDisabling.add(dockable);
    }

    @Override
    public Dockable getDockableAt(int n) {
        return this.dockables.get(n).getDockable();
    }

    @Override
    public DockElementRepresentative getTabAt(int n) {
        return null;
    }

    @Override
    public void moveTab(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n2 < 0 || n2 >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.getSelectedIndex();
        String string = this.getTitleAt(n);
        String string2 = this.getToolTipTextAt(n);
        Icon icon = this.getIconAt(n);
        Component component = this.getComponentAt(n);
        Dockable dockable = this.dockables.get(n).getDockable();
        this.remove(n);
        this.insertTab(string, icon, component, dockable, n2);
        this.setTooltipAt(n2, string2);
        if (n3 == n) {
            n3 = n2;
        } else if (n3 > n && n3 <= n2) {
            ++n3;
        }
        this.setSelectedIndex(n3);
    }

    @Override
    public void removeAll() {
        for (Tab tab : this.dockables) {
            tab.setController(null);
            this.tabDisabling.remove(tab.getDockable());
        }
        super.removeAll();
        this.dockables.clear();
    }

    @Override
    public void remove(int n) {
        Tab tab = this.dockables.remove(n);
        tab.setController(null);
        this.tabDisabling.remove(tab.getDockable());
        super.remove(n);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setTitleAt(int n, String string) {
        super.setTitleAt(n, string == null ? "" : string);
    }

    @Override
    public void setTooltipAt(int n, String string) {
        this.setToolTipTextAt(n, string);
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.mouseTarget != null) {
                if (this.mouseTarget.relocator != null) {
                    this.mouseTarget.relocator.cancel();
                }
                this.mouseTarget = null;
            }
            this.controller = dockController;
            this.tabDisabling.setController(dockController);
            for (Tab tab : this.dockables) {
                tab.setController(dockController);
            }
        }
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean isSingleTabComponent() {
        return false;
    }

    @Override
    public DockElementRepresentative createDefaultRepresentation(DockElement dockElement) {
        return new SimpleDockElementRepresentative(dockElement, this);
    }

    @Override
    public int getIndexOfTabAt(Point point) {
        int n = 0;
        int n2 = this.getTabCount();
        while (n < n2) {
            Rectangle rectangle = this.getBoundsAt(n);
            if (rectangle != null && rectangle.contains(point)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(Dockable dockable) {
        int n = 0;
        for (Tab tab : this.dockables) {
            if (tab.getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(1, 1);
        int n = 0;
        int n2 = this.getTabCount();
        while (n < n2) {
            Dimension dimension2 = this.getComponentAt(n).getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            ++n;
        }
        return dimension;
    }

    private class Listener
    extends MouseInputAdapter
    implements ChangeListener {
        private Listener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            StackDockComponentListener[] stackDockComponentListenerArray = DefaultStackDockComponent.this.listeners.toArray(new StackDockComponentListener[DefaultStackDockComponent.this.listeners.size()]);
            int n = stackDockComponentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackDockComponentListener stackDockComponentListener = stackDockComponentListenerArray[n2];
                stackDockComponentListener.selectionChanged(DefaultStackDockComponent.this);
                ++n2;
            }
        }

        private void updateRelocator(int n, int n2, boolean bl, boolean bl2) {
            boolean bl3;
            boolean bl4 = bl3 = DefaultStackDockComponent.this.controller == null || !DefaultStackDockComponent.this.controller.getRelocator().isDragOnlyTitle();
            if (DefaultStackDockComponent.this.mouseTarget != null) {
                if (!bl3) {
                    DefaultStackDockComponent.this.mouseTarget.relocator.cancel();
                    if (!bl2) {
                        DefaultStackDockComponent.this.mouseTarget = null;
                    }
                }
                return;
            }
            if (!bl3 && !bl2) {
                return;
            }
            if (bl) {
                int n3 = 0;
                int n4 = DefaultStackDockComponent.this.getTabCount();
                while (n3 < n4) {
                    Rectangle rectangle = DefaultStackDockComponent.this.getBoundsAt(n3);
                    if (rectangle != null && rectangle.contains(n, n2)) {
                        DefaultStackDockComponent.this.mouseTarget = (Tab)DefaultStackDockComponent.this.dockables.get(n3);
                    }
                    ++n3;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                if (mouseEvent.isConsumed()) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.init(point.x, point.y, 0, 0, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE: 
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            } else {
                this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drop(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            } else {
                this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), true, true);
                if (DefaultStackDockComponent.this.mouseTarget != null) {
                    DefaultStackDockComponent.this.mouseTarget.popup(mouseEvent);
                    DefaultStackDockComponent.this.mouseTarget = null;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.updateRelocator(mouseEvent.getX(), mouseEvent.getY(), false, false);
            if (DefaultStackDockComponent.this.mouseTarget != null && DefaultStackDockComponent.this.mouseTarget.relocator != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                RemoteRelocator.Reaction reaction = DefaultStackDockComponent.this.mouseTarget.relocator.drag(point.x, point.y, mouseEvent.getModifiersEx());
                switch (reaction) {
                    case BREAK_CONSUMED: {
                        mouseEvent.consume();
                    }
                    case BREAK: {
                        DefaultStackDockComponent.this.mouseTarget = null;
                        break;
                    }
                    case CONTINUE_CONSUMED: {
                        mouseEvent.consume();
                    }
                }
            }
        }
    }

    public class Tab
    extends ActionPopup {
        protected Dockable dockable;
        private RemoteRelocator relocator;

        public Tab(Dockable dockable) {
            super(true);
            this.dockable = dockable;
        }

        @Override
        public Dockable getDockable() {
            return this.dockable;
        }

        public void setController(DockController dockController) {
            this.relocator = dockController == null ? null : dockController.getRelocator().createRemote(this.dockable);
        }

        @Override
        public void popup(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
                super.popup(mouseEvent);
            }
        }

        @Override
        protected DockActionSource getActions() {
            return this.dockable.getGlobalActionOffers();
        }

        @Override
        protected Object getSource() {
            return this;
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }
    }
}

