/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.disable.TabDisablingStrategyObserver;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.CombinedStackDockContentPane;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPane;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabConfigurations;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SimpleDockElementRepresentative;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class CombinedStackDockComponent<T extends CombinedTab, M extends CombinedMenu, I extends CombinedInfoComponent>
extends AbstractTabPane<T, M, I>
implements StackDockComponent {
    private CombinedStackDockContentPane panel;
    private Map<Dockable, Meta> components = new HashMap<Dockable, Meta>();
    private PropertyValue<TabConfigurations> tabConfiguration = new PropertyValue<TabConfigurations>(StackDockStation.TAB_CONFIGURATIONS){

        @Override
        protected void valueChanged(TabConfigurations tabConfigurations, TabConfigurations tabConfigurations2) {
            for (CombinedTab combinedTab : CombinedStackDockComponent.this.getTabsList()) {
                combinedTab.setConfiguration(tabConfigurations2.getConfiguration(combinedTab.getDockable()));
            }
        }
    };
    private BackgroundAlgorithm background;
    private BackgroundPanel componentPanel = new ConfiguredBackgroundPanel(null, Transparency.DEFAULT){

        @Override
        public void doLayout() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 0;
            int n4 = this.getComponentCount();
            while (n3 < n4) {
                this.getComponent(n3).setBounds(0, 0, n, n2);
                ++n3;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            int n2 = this.getComponentCount();
            while (n < n2) {
                Dimension dimension2 = this.getComponent(n).getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            int n2 = this.getComponentCount();
            while (n < n2) {
                Dimension dimension2 = this.getComponent(n).getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            return dimension;
        }
    };
    private List<StackDockComponentListener> listeners = new ArrayList<StackDockComponentListener>();
    private CombinedHandler<CombinedTab> tabHandler = new CombinedHandler<CombinedTab>(){

        @Override
        public void setVisible(CombinedTab combinedTab, boolean bl) {
            DockController dockController = CombinedStackDockComponent.this.getController();
            if (bl) {
                CombinedStackDockComponent.this.panel.add(combinedTab.getComponent());
                if (dockController != null) {
                    dockController.addRepresentative(combinedTab);
                }
            } else {
                CombinedStackDockComponent.this.panel.remove(combinedTab.getComponent());
                if (dockController != null) {
                    dockController.removeRepresentative(combinedTab);
                }
            }
        }

        @Override
        public boolean isVisible(CombinedTab combinedTab) {
            return combinedTab.getComponent() != null && combinedTab.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedTab combinedTab, int n) {
            CombinedStackDockComponent.this.setZOrder(combinedTab.getComponent(), n);
        }

        @Override
        public int getZOrder(CombinedTab combinedTab) {
            return CombinedStackDockComponent.this.getZOrder(combinedTab.getComponent());
        }
    };
    private CombinedHandler<CombinedMenu> menuHandler = new CombinedHandler<CombinedMenu>(){

        @Override
        public void setVisible(CombinedMenu combinedMenu, boolean bl) {
            if (bl) {
                CombinedStackDockComponent.this.panel.add(combinedMenu.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(combinedMenu.getComponent());
            }
        }

        @Override
        public boolean isVisible(CombinedMenu combinedMenu) {
            return combinedMenu.getComponent() != null && combinedMenu.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(CombinedMenu combinedMenu, int n) {
            CombinedStackDockComponent.this.setZOrder(combinedMenu.getComponent(), n);
        }

        @Override
        public int getZOrder(CombinedMenu combinedMenu) {
            return CombinedStackDockComponent.this.getZOrder(combinedMenu.getComponent());
        }
    };
    private CombinedHandler<AbstractTabPaneComponent> infoHandler = new CombinedHandler<AbstractTabPaneComponent>(){

        @Override
        public void setVisible(AbstractTabPaneComponent abstractTabPaneComponent, boolean bl) {
            if (bl) {
                CombinedStackDockComponent.this.panel.add(abstractTabPaneComponent.getComponent());
            } else {
                CombinedStackDockComponent.this.panel.remove(abstractTabPaneComponent.getComponent());
            }
        }

        @Override
        public boolean isVisible(AbstractTabPaneComponent abstractTabPaneComponent) {
            return abstractTabPaneComponent.getComponent() != null && abstractTabPaneComponent.getComponent().getParent() == CombinedStackDockComponent.this.panel;
        }

        @Override
        public void setZOrder(AbstractTabPaneComponent abstractTabPaneComponent, int n) {
            CombinedStackDockComponent.this.setZOrder(abstractTabPaneComponent.getComponent(), n);
        }

        @Override
        public int getZOrder(AbstractTabPaneComponent abstractTabPaneComponent) {
            return CombinedStackDockComponent.this.getZOrder(abstractTabPaneComponent.getComponent());
        }
    };
    private TabDisablingStrategyObserver tabDisabling = new TabDisablingStrategyObserver(){

        @Override
        public void setDisabled(Dockable dockable, boolean bl) {
            CombinedStackDockComponent.this.setEnabledAt(dockable, !bl);
        }
    };

    public CombinedStackDockComponent() {
        this.background = this.createBackground(this);
        this.panel = this.createContentPane(this);
        this.panel.add(this.componentPanel);
        this.panel.setBackground(this.background);
        this.componentPanel.setBackground(this.background);
        this.addTabPaneListener(new TabPaneListener(){

            @Override
            public void added(TabPane tabPane, Dockable dockable) {
            }

            @Override
            public void removed(TabPane tabPane, Dockable dockable) {
            }

            @Override
            public void selectionChanged(TabPane tabPane) {
                StackDockComponentListener[] stackDockComponentListenerArray = CombinedStackDockComponent.this.listeners.toArray(new StackDockComponentListener[CombinedStackDockComponent.this.listeners.size()]);
                int n = stackDockComponentListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackDockComponentListener stackDockComponentListener = stackDockComponentListenerArray[n2];
                    stackDockComponentListener.selectionChanged(CombinedStackDockComponent.this);
                    ++n2;
                }
            }

            @Override
            public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
            }

            @Override
            public void controllerChanged(TabPane tabPane, DockController dockController) {
            }
        });
    }

    protected CombinedStackDockContentPane createContentPane(CombinedStackDockComponent<T, M, I> combinedStackDockComponent) {
        return new CombinedStackDockContentPane(combinedStackDockComponent);
    }

    protected BackgroundAlgorithm createBackground(CombinedStackDockComponent<T, M, I> combinedStackDockComponent) {
        return new Background();
    }

    @Override
    public void revalidate() {
        this.panel.revalidate();
        this.repaint();
    }

    public void repaint() {
        this.panel.repaint();
    }

    @Override
    public void addStackDockComponentListener(StackDockComponentListener stackDockComponentListener) {
        this.listeners.add(stackDockComponentListener);
    }

    @Override
    public void removeStackDockComponentListener(StackDockComponentListener stackDockComponentListener) {
        this.listeners.remove(stackDockComponentListener);
    }

    protected void fireTabChanged(Dockable dockable) {
        for (StackDockComponentListener stackDockComponentListener : this.listeners) {
            stackDockComponentListener.tabChanged(this, dockable);
        }
    }

    @Override
    public void setController(DockController dockController) {
        DockController dockController2 = this.getController();
        if (dockController2 != dockController) {
            List list = this.getTabsList();
            if (dockController2 != null) {
                for (CombinedTab object : list) {
                    dockController2.removeRepresentative(object);
                }
            }
            if (dockController != null) {
                for (CombinedTab combinedTab : list) {
                    dockController.addRepresentative(combinedTab);
                }
            }
            for (Meta meta : this.components.values()) {
                meta.setController(dockController);
            }
            this.background.setController(dockController);
            this.tabDisabling.setController(dockController);
            this.tabConfiguration.setProperties(dockController);
            super.setController(dockController);
        }
    }

    public TabConfiguration getConfiguration(Dockable dockable) {
        return this.tabConfiguration.getValue().getConfiguration(dockable);
    }

    public CombinedHandler<CombinedTab> getTabHandler() {
        return this.tabHandler;
    }

    public CombinedHandler<CombinedMenu> getMenuHandler() {
        return this.menuHandler;
    }

    public CombinedHandler<AbstractTabPaneComponent> getInfoHandler() {
        return this.infoHandler;
    }

    @Override
    public Rectangle getAvailableArea() {
        Insets insets = this.panel.getInsets();
        insets = insets == null ? new Insets(0, 0, 0, 0) : new Insets(insets.top, insets.left, insets.bottom, insets.right);
        return new Rectangle(insets.left, insets.top, Math.max(1, this.panel.getWidth() - insets.left - insets.right), Math.max(1, this.panel.getHeight() - insets.top - insets.bottom));
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Insets insets = this.panel.getInsets();
        if (insets != null) {
            dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Insets insets = this.panel.getInsets();
        if (insets != null) {
            dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public Rectangle getSelectedBounds() {
        return this.componentPanel.getBounds();
    }

    @Override
    public void setSelectedBounds(Rectangle rectangle) {
        this.componentPanel.setBounds(rectangle);
    }

    @Override
    public int getSelectedIndex() {
        return this.indexOf(this.getSelectedDockable());
    }

    @Override
    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.getDockableCount()) {
            this.setSelectedDockable(null);
        } else {
            this.setSelectedDockable(this.getDockable(n));
        }
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        if (this.getSelectedDockable() != dockable) {
            super.setSelectedDockable(dockable);
            for (Meta meta : this.components.values()) {
                meta.component.setVisible(meta.dockable == dockable);
            }
        }
    }

    @Override
    public Rectangle getBoundsAt(int n) {
        CombinedTab combinedTab = (CombinedTab)this.getTab(this.getDockable(n));
        if (combinedTab == null) {
            return null;
        }
        return combinedTab.getBounds();
    }

    @Override
    public int getIndexOfTabAt(Point point) {
        return this.getLayoutManager().getIndexOfTabAt(this, point);
    }

    @Override
    public int getTabCount() {
        return this.getDockableCount();
    }

    @Override
    public void addTab(String string, Icon icon, Component component, Dockable dockable) {
        this.insertTab(string, icon, component, dockable, this.getTabCount());
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, Dockable dockable, int n) {
        Component component2 = this.createLayerAt(component, dockable);
        Meta meta = new Meta(dockable, component2, string, icon, null, !this.tabDisabling.isDisabled(dockable));
        this.components.put(dockable, meta);
        this.componentPanel.add(component2);
        this.insert(n, dockable);
        meta.forward();
        meta.component.setVisible(this.getSelectedDockable() == dockable);
        this.tabDisabling.add(dockable);
    }

    @Override
    public Dimension getMinimumSize(Dockable dockable) {
        return this.components.get(dockable).getComponent().getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(Dockable dockable) {
        return this.components.get(dockable).getComponent().getPreferredSize();
    }

    @Override
    public Dockable getDockableAt(int n) {
        return this.getDockable(n);
    }

    @Override
    public DockElementRepresentative getTabAt(int n) {
        return (DockElementRepresentative)this.getTab(this.getDockableAt(n));
    }

    @Override
    public void moveTab(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n2 < 0 || n2 >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = this.getSelectedIndex();
        this.move(n, n2);
        if (n3 == n) {
            n3 = n2;
        } else if (n3 > n && n3 <= n2) {
            ++n3;
        }
        this.setSelectedIndex(n3);
    }

    @Override
    public void remove(int n) {
        Dockable dockable = this.getDockable(n);
        this.tabDisabling.remove(dockable);
        super.remove(n);
        Meta meta = this.components.remove(dockable);
        meta.setController(null);
        this.componentPanel.remove(meta.component);
        meta.component.setVisible(true);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (Meta meta : this.components.values()) {
            this.componentPanel.remove(meta.component);
            meta.setController(null);
            meta.component.setVisible(true);
            this.tabDisabling.remove(meta.getDockable());
        }
        this.components.clear();
    }

    @Override
    public T putOnTab(Dockable dockable) {
        CombinedTab combinedTab = (CombinedTab)super.putOnTab(dockable);
        Meta meta = this.components.get(dockable);
        combinedTab.setIcon(meta.icon);
        combinedTab.setText(meta.text);
        combinedTab.setTooltip(meta.tooltip);
        combinedTab.setEnabled(meta.enabled);
        return (T)combinedTab;
    }

    @Override
    public T getOnTab(Dockable dockable) {
        CombinedTab combinedTab = (CombinedTab)super.getOnTab(dockable);
        Meta meta = this.components.get(dockable);
        combinedTab.setIcon(meta.icon);
        combinedTab.setText(meta.text);
        combinedTab.setTooltip(meta.tooltip);
        combinedTab.setEnabled(meta.enabled);
        return (T)combinedTab;
    }

    @Override
    protected T putTab(Dockable dockable, T t) {
        CombinedTab combinedTab = (CombinedTab)super.putTab(dockable, t);
        this.fireTabChanged(dockable);
        return (T)combinedTab;
    }

    @Override
    protected T removeTab(Dockable dockable) {
        CombinedTab combinedTab = (CombinedTab)super.removeTab(dockable);
        if (combinedTab != null) {
            this.fireTabChanged(dockable);
        }
        return (T)combinedTab;
    }

    @Override
    protected void clearTabs() {
        super.clearTabs();
        int n = 0;
        int n2 = this.getDockableCount();
        while (n < n2) {
            this.fireTabChanged(this.getDockable(n));
            ++n;
        }
    }

    @Override
    protected void addToMenu(M m, Dockable dockable) {
        int n = m.getDockableCount();
        m.insert(n, dockable);
        Meta meta = this.components.get(dockable);
        m.setIcon(n, meta.icon);
        m.setText(n, meta.text);
        m.setTooltip(n, meta.tooltip);
        m.setEnabled(n, meta.enabled);
    }

    @Override
    protected void removeFromMenu(M m, Dockable dockable) {
        m.remove(dockable);
    }

    protected Component createLayerAt(Component component, Dockable dockable) {
        return component;
    }

    public Component getLayerAt(int n) {
        return this.getContentAt(n).component;
    }

    protected Meta getContentAt(int n) {
        return this.components.get(this.getDockable(n));
    }

    @Override
    public void setTitleAt(int n, String string) {
        Meta meta = this.components.get(this.getDockable(n));
        if (string == null) {
            meta.text = "";
        } else {
            meta.text = string;
        }
        meta.forward();
    }

    @Override
    public void setTooltipAt(int n, String string) {
        Meta meta = this.components.get(this.getDockable(n));
        meta.tooltip = string;
        meta.forward();
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        Meta meta = this.components.get(this.getDockable(n));
        meta.icon = icon;
        meta.forward();
    }

    @Override
    public void setComponentAt(int n, Component component) {
        Meta meta = this.components.get(this.getDockable(n));
        this.componentPanel.remove(meta.component);
        meta.component = this.createLayerAt(component, meta.dockable);
        this.componentPanel.add(meta.component);
        meta.component.setVisible(this.getSelectedDockable() == meta.dockable);
        this.revalidate();
    }

    protected void setEnabledAt(Dockable dockable, boolean bl) {
        Meta meta = this.components.get(dockable);
        if (meta != null && meta.enabled != bl) {
            meta.enabled = bl;
            meta.forward();
        }
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    protected void setZOrder(Component component, int n) {
        this.panel.setComponentZOrder(component, n);
    }

    protected int getZOrder(Component component) {
        return this.panel.getComponentZOrder(component);
    }

    @Override
    public DockElementRepresentative createDefaultRepresentation(DockElement dockElement) {
        return new SimpleDockElementRepresentative(dockElement, this.panel);
    }

    protected BorderForwarder createContentBorderModifier(Dockable dockable, JComponent jComponent) {
        return null;
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneBackgroundComponent {
        public Background() {
            super(TabPaneBackgroundComponent.KIND, "dock.background.tabPane");
        }

        @Override
        public TabPane getPane() {
            return CombinedStackDockComponent.this;
        }

        @Override
        public Component getComponent() {
            return CombinedStackDockComponent.this.panel;
        }
    }

    protected class Meta {
        private Dockable dockable;
        private Component component;
        private String text;
        private Icon icon;
        private String tooltip;
        private BorderForwarder border;
        private boolean enabled = true;

        public Meta(Dockable dockable, Component component, String string, Icon icon, String string2, boolean bl) {
            this.dockable = dockable;
            this.component = component;
            this.text = string;
            this.icon = icon;
            this.tooltip = string2;
            this.enabled = bl;
            if (component instanceof JComponent) {
                this.border = CombinedStackDockComponent.this.createContentBorderModifier(dockable, (JComponent)component);
            }
            this.setController(CombinedStackDockComponent.this.getController());
        }

        public void setController(DockController dockController) {
            if (this.border != null) {
                this.border.setController(dockController);
            }
        }

        public Dockable getDockable() {
            return this.dockable;
        }

        public Component getComponent() {
            return this.component;
        }

        public void setBorder(Border border) {
            if (this.border == null) {
                throw new IllegalStateException("there was no border-modifier created");
            }
            this.border.setBorder(border);
        }

        public void forward() {
            CombinedMenu combinedMenu;
            CombinedTab combinedTab = (CombinedTab)CombinedStackDockComponent.this.getTab(this.dockable);
            if (combinedTab != null) {
                combinedTab.setIcon(this.icon);
                combinedTab.setText(this.text);
                combinedTab.setTooltip(this.tooltip);
                combinedTab.setEnabled(this.enabled);
            }
            if ((combinedMenu = (CombinedMenu)CombinedStackDockComponent.this.getMenu(this.dockable)) != null) {
                Dockable[] dockableArray = combinedMenu.getDockables();
                int n = 0;
                while (n < dockableArray.length) {
                    if (dockableArray[n] == this.dockable) {
                        combinedMenu.setIcon(n, this.icon);
                        combinedMenu.setText(n, this.text);
                        combinedMenu.setTooltip(n, this.tooltip);
                        combinedMenu.setEnabled(n, this.enabled);
                        break;
                    }
                    ++n;
                }
            }
        }
    }
}

