/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class SideSnapDropLayer
implements DockStationDropLayer {
    private SplitDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_LOW;

    public SideSnapDropLayer(SplitDockStation splitDockStation) {
        this.station = splitDockStation;
    }

    @Override
    public LayerPriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(LayerPriority layerPriority) {
        this.priority = layerPriority;
    }

    @Override
    public boolean canCompare(DockStationDropLayer dockStationDropLayer) {
        return false;
    }

    @Override
    public int compare(DockStationDropLayer dockStationDropLayer) {
        return 0;
    }

    @Override
    public Component getComponent() {
        return this.station.getComponent();
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer dockStationDropLayer) {
        return dockStationDropLayer;
    }

    @Override
    public boolean contains(int n, int n2) {
        int n3;
        if (!this.station.isAllowSideSnap()) {
            return false;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle rectangle = this.getComponent().getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        if (rectangle.contains(point)) {
            return false;
        }
        n = point.x;
        n2 = point.y;
        int n4 = Math.min(Math.abs(n), Math.abs(n - rectangle.width));
        if (n > 0 && n < rectangle.width) {
            n4 = 0;
        }
        int n5 = Math.min(Math.abs(n2), Math.abs(n2 - rectangle.height));
        if (n2 > 0 && n2 < rectangle.height) {
            n5 = 0;
        }
        return n4 <= (n3 = this.station.getBorderSideSnapSize()) && n5 <= n3;
    }
}

