/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SpanSplitNode;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.awt.Rectangle;

public class SplitSpanStrategy {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    private SplitDockStation station;
    private StationSpanFactoryValue factory;
    private PutInfo lastPut;

    public SplitSpanStrategy(SplitDockStation splitDockStation) {
        this.station = splitDockStation;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.split", splitDockStation){

            @Override
            protected void changed() {
                SplitSpanStrategy.this.reset();
            }
        };
    }

    public void setPut(PutInfo putInfo) {
        Object object;
        if (putInfo != null && (object = putInfo.getPut()) != PutInfo.Put.LEFT && object != PutInfo.Put.RIGHT && object != PutInfo.Put.TOP && object != PutInfo.Put.BOTTOM) {
            putInfo = null;
        }
        if (putInfo != null && putInfo.willHaveNoEffect()) {
            return;
        }
        if (putInfo != null && this.lastPut != null && putInfo.getPut() == this.lastPut.getPut() && putInfo.getNode() == this.lastPut.getNode()) {
            return;
        }
        if (this.lastPut != null && (object = this.getSpans(this.lastPut)) != null) {
            object[this.putToPosition(this.lastPut.getPut())].mutate(SpanMode.OFF);
        }
        this.lastPut = putInfo;
        if (putInfo != null) {
            object = putInfo.getPut();
            Span[] spanArray = this.getSpans(putInfo);
            if (spanArray != null) {
                int n = this.putToPosition((PutInfo.Put)((Object)object));
                double d = putInfo.getDivider();
                int n2 = 100;
                SplitNode splitNode = putInfo.getNode();
                if (splitNode.getParent() == this.station.getRoot()) {
                    splitNode = splitNode.getParent();
                }
                switch (SplitSpanStrategy.$SWITCH_TABLE$bibliothek$gui$dock$station$split$PutInfo$Put()[((Enum)object).ordinal()]) {
                    case 2: {
                        n2 = (int)((double)splitNode.getSize().width * d);
                        break;
                    }
                    case 3: {
                        n2 = (int)((double)splitNode.getSize().width * (1.0 - d));
                        break;
                    }
                    case 1: {
                        n2 = (int)((double)splitNode.getSize().height * d);
                        break;
                    }
                    case 4: {
                        n2 = (int)((double)splitNode.getSize().height * (1.0 - d));
                    }
                }
                spanArray[n].configureSize(SpanMode.OPEN, n2);
                spanArray[n].mutate(SpanMode.OPEN);
            }
        }
    }

    public int putToPosition(PutInfo.Put put) {
        switch (put) {
            case LEFT: {
                return 0;
            }
            case RIGHT: {
                return 1;
            }
            case TOP: {
                return 2;
            }
            case BOTTOM: {
                return 3;
            }
        }
        throw new IllegalArgumentException("not a side: " + (Object)((Object)put));
    }

    public Span[] getSpans(PutInfo putInfo) {
        SplitNode splitNode = putInfo.getNode();
        if (splitNode instanceof Leaf) {
            return ((Leaf)splitNode).getSpans();
        }
        if (splitNode instanceof Root) {
            return ((Root)splitNode).getSpans();
        }
        if (splitNode.getParent() instanceof Root) {
            return ((Root)splitNode.getParent()).getSpans();
        }
        return null;
    }

    public void unsetPut() {
        if (this.lastPut != null) {
            Span[] spanArray = this.getSpans(this.lastPut);
            this.lastPut = null;
            if (spanArray != null) {
                int n = 0;
                while (n < 4) {
                    spanArray[n].set(SpanMode.OFF);
                    ++n;
                }
            }
        }
    }

    private void reset() {
        this.station.getRoot().visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                root.createSpans();
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
            }

            @Override
            public void handleNode(Node node) {
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                leaf.createSpans();
            }
        });
    }

    public StationSpanFactoryValue getFactory() {
        return this.factory;
    }

    public void setController(DockController dockController) {
        this.factory.setController(dockController);
    }

    public Span[] createSpans(SpanSplitNode spanSplitNode) {
        if (this.factory.get() == null) {
            return null;
        }
        Span[] spanArray = new Span[4];
        int n = 0;
        while (n < 4) {
            spanArray[n] = this.createSpan(n, spanSplitNode);
            ++n;
        }
        return spanArray;
    }

    private Span createSpan(final int n, final SpanSplitNode spanSplitNode) {
        return ((SpanFactory)this.factory.get()).create(new SpanCallback(){

            @Override
            public void resized() {
                spanSplitNode.onSpanResize();
            }

            @Override
            public boolean isVertical() {
                return n == 2 || n == 3;
            }

            @Override
            public boolean isHorizontal() {
                return n == 0 || n == 1;
            }

            @Override
            public DockStation getStation() {
                return SplitSpanStrategy.this.station;
            }

            @Override
            public SpanUsage getUsage() {
                return SpanUsage.INSERTING;
            }
        });
    }

    public Rectangle modifyBounds(Rectangle rectangle, SpanSplitNode spanSplitNode) {
        Span[] spanArray = spanSplitNode.getSpans();
        if (spanArray == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = spanArray[0].getSize();
        int n2 = spanArray[1].getSize();
        int n3 = spanArray[2].getSize();
        int n4 = spanArray[3].getSize();
        rectangle2.x += n;
        rectangle2.width -= n + n2;
        rectangle2.y += n3;
        rectangle2.height -= n3 + n4;
        return rectangle2;
    }
}

