/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;

public class SplitPlaceholderSet {
    private SplitDockAccess access;

    public SplitPlaceholderSet(SplitDockAccess splitDockAccess) {
        this.access = splitDockAccess;
    }

    public void set(SplitNode splitNode, Dockable dockable, SplitNode ... splitNodeArray) {
        Path path;
        RootPlaceholderStrategy rootPlaceholderStrategy = this.access.getOwner().getPlaceholderStrategy();
        if (rootPlaceholderStrategy != null && (path = rootPlaceholderStrategy.getPlaceholderFor(dockable)) != null) {
            this.set(splitNode, path, splitNodeArray);
        }
    }

    public void set(final SplitNode splitNode, final Path path, SplitNode ... splitNodeArray) {
        final ArrayList arrayList = new ArrayList();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                this.handle(root);
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            @Override
            public void handleNode(Node node) {
                this.handle(node);
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                this.handle(leaf);
            }

            private void handle(SplitNode splitNode2) {
                if (splitNode2 != splitNode) {
                    splitNode2.removePlaceholder(path);
                    PlaceholderMap placeholderMap = splitNode2.getPlaceholderMap();
                    if (placeholderMap != null) {
                        placeholderMap.removeAll(path, true);
                    }
                    if (!splitNode2.isOfUse()) {
                        arrayList.add(splitNode2);
                    }
                }
            }
        });
        if (splitNode != null) {
            splitNode.addPlaceholder(path);
        }
        if (this.access.isTreeAutoCleanupEnabled()) {
            SplitNode[] splitNodeArray2 = splitNodeArray;
            int n = splitNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SplitNode splitNode2 = splitNodeArray2[n2];
                arrayList.remove(splitNode2);
                ++n2;
            }
            for (SplitNode splitNode2 : arrayList) {
                splitNode2.delete(true);
            }
        }
    }

    public void removeDoublePlaceholders(final SplitNode splitNode, PlaceholderMap placeholderMap) {
        final HashSet<Path> hashSet = new HashSet<Path>();
        final RootPlaceholderStrategy rootPlaceholderStrategy = this.access.getOwner().getPlaceholderStrategy();
        Root root = this.access.getOwner().getRoot();
        root.visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                this.handle(root);
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(placeholder);
            }

            @Override
            public void handleNode(Node node) {
                this.handle(node);
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (leaf != splitNode) {
                    this.handle(leaf);
                    this.handle(leaf.getDockable());
                }
            }

            private void handle(SplitNode splitNode2) {
                if (splitNode2 != splitNode) {
                    Path[] pathArray = splitNode2.getPlaceholders();
                    int n = pathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Path path = pathArray[n2];
                        hashSet.add(path);
                        ++n2;
                    }
                }
            }

            private void handle(Dockable dockable) {
                if (rootPlaceholderStrategy != null && dockable != null) {
                    DockStation dockStation;
                    Path path = rootPlaceholderStrategy.getPlaceholderFor(dockable);
                    if (path != null) {
                        hashSet.add(path);
                    }
                    if ((dockStation = dockable.asDockStation()) != null) {
                        int n = 0;
                        int n2 = dockStation.getDockableCount();
                        while (n < n2) {
                            this.handle(dockStation.getDockable(n));
                            ++n;
                        }
                    }
                }
            }
        });
        placeholderMap.removeAll(hashSet, true);
    }
}

