/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class SplitFullScreenAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    private SplitDockStation split;
    private DockController controller;
    private DockActionIcon iconNormalize;
    private DockActionIcon iconMaximize;
    private DockActionText textNormalize;
    private DockActionText textMaximize;
    private DockActionText textNormalizeTooltip;
    private DockActionText textMaximizeTooltip;
    private PropertyValue<KeyStroke> accelerator = new PropertyValue<KeyStroke>(SplitDockStation.MAXIMIZE_ACCELERATOR){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
            SplitFullScreenAction.this.setAccelerator(Boolean.TRUE, keyStroke2);
            SplitFullScreenAction.this.setAccelerator(Boolean.FALSE, keyStroke2);
        }
    };

    public SplitFullScreenAction(SplitDockStation splitDockStation) {
        super(null);
        this.split = splitDockStation;
        this.setRemoveEmptyGroups(false);
        splitDockStation.addSplitDockStationListener(new SplitDockListener(){

            @Override
            public void fullScreenDockableChanged(SplitDockStation splitDockStation, Dockable dockable, Dockable dockable2) {
                if (dockable != null) {
                    SplitFullScreenAction.this.change(dockable, Boolean.FALSE);
                }
                if (dockable2 != null) {
                    SplitFullScreenAction.this.change(dockable2, Boolean.TRUE);
                }
            }
        });
        this.textNormalize = new DockActionText("split.normalize", this){

            @Override
            protected void changed(String string, String string2) {
                SplitFullScreenAction.this.setText(Boolean.TRUE, string2);
            }
        };
        this.textMaximize = new DockActionText("split.maximize", this){

            @Override
            protected void changed(String string, String string2) {
                SplitFullScreenAction.this.setText(Boolean.FALSE, string2);
            }
        };
        this.textNormalizeTooltip = new DockActionText("split.normalize.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                SplitFullScreenAction.this.setTooltip(Boolean.TRUE, string2);
            }
        };
        this.textMaximizeTooltip = new DockActionText("split.maximize.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                SplitFullScreenAction.this.setTooltip(Boolean.FALSE, string2);
            }
        };
        this.iconNormalize = new DockActionIcon("split.normalize", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                SplitFullScreenAction.this.setIcon(Boolean.TRUE, icon2);
            }
        };
        this.iconMaximize = new DockActionIcon("split.maximize", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                SplitFullScreenAction.this.setIcon(Boolean.FALSE, icon2);
            }
        };
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
            this.accelerator.setProperties(dockController);
            if (dockController == null) {
                this.iconNormalize.setManager(null);
                this.iconMaximize.setManager(null);
                this.textNormalize.setManager(null);
                this.textMaximize.setManager(null);
                this.textNormalizeTooltip.setManager(null);
                this.textMaximizeTooltip.setManager(null);
            } else {
                this.iconNormalize.setManager(dockController.getIcons());
                this.iconMaximize.setManager(dockController.getIcons());
                this.textNormalize.setManager(dockController.getTexts());
                this.textMaximize.setManager(dockController.getTexts());
                this.textNormalizeTooltip.setManager(dockController.getTexts());
                this.textMaximizeTooltip.setManager(dockController.getTexts());
            }
        }
    }

    @Override
    public void action(Dockable dockable) {
        DockElement dockElement;
        while (dockable.getDockParent() != this.split) {
            dockElement = dockable.getDockParent();
            if (dockElement == null) {
                return;
            }
            dockable = dockElement.asDockable();
            if (dockable != null) continue;
            return;
        }
        dockElement = this.split.getFullScreen();
        if (dockElement == dockable) {
            this.split.setFullScreen(null);
        } else {
            this.split.setFullScreen(dockable);
        }
    }

    private void change(Dockable dockable, Boolean bl) {
        DockStation dockStation;
        if (this.isKnown(dockable)) {
            this.setGroup(bl, dockable);
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = 0;
            int n2 = dockStation.getDockableCount();
            while (n < n2) {
                this.change(dockStation.getDockable(n), bl);
                ++n;
            }
        }
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        while (dockable.getDockParent() != this.split) {
            DockStation dockStation = dockable.getDockParent();
            if (dockStation == null) {
                return Boolean.FALSE;
            }
            dockable = dockStation.asDockable();
            if (dockable != null) continue;
            return Boolean.FALSE;
        }
        if (dockable == this.split.getFullScreen()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

