/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.support.CombinerTarget;

public class SplitDropOperation
implements StationDropOperation {
    private SplitDockAccess access;
    private PutInfo putInfo;
    private StationDropItem item;
    private boolean move;

    public SplitDropOperation(SplitDockAccess splitDockAccess, PutInfo putInfo, StationDropItem stationDropItem, boolean bl) {
        this.access = splitDockAccess;
        this.putInfo = putInfo;
        this.item = stationDropItem;
        this.move = bl;
    }

    @Override
    public boolean isMove() {
        return this.move;
    }

    @Override
    public void draw() {
        this.access.setDropInfo(this.putInfo);
    }

    @Override
    public void destroy(StationDropOperation stationDropOperation) {
        if (this.access.getOwner().getDropInfo() == this.putInfo) {
            this.access.setDropInfo(null);
            if (stationDropOperation == null || !(stationDropOperation instanceof SplitDropOperation) || stationDropOperation.getTarget() != this.getTarget()) {
                this.access.unsetDropInfo();
            }
        }
    }

    @Override
    public DockStation getTarget() {
        return this.access.getOwner();
    }

    @Override
    public Dockable getItem() {
        return this.putInfo.getDockable();
    }

    @Override
    public CombinerTarget getCombination() {
        return this.putInfo.getCombinerTarget();
    }

    @Override
    public DisplayerCombinerTarget getDisplayerCombination() {
        CombinerTarget combinerTarget = this.getCombination();
        if (combinerTarget == null) {
            return null;
        }
        return combinerTarget.getDisplayerCombination();
    }

    @Override
    public void execute() {
        this.access.unsetDropInfo();
        if (this.isMove()) {
            this.access.move(this.putInfo, this.item);
        } else {
            this.access.drop(null, this.putInfo, this.item);
        }
    }
}

