/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

public abstract class SplitDockTree<D> {
    private Key root;
    private Set<D> dockables = new HashSet<D>();

    public abstract D[] array(int var1);

    public D[] array(D d) {
        boolean[] blArray = this.array(true);
        blArray[0] = d;
        return blArray;
    }

    public Key root(D d) {
        this.root = this.put(this.array(d));
        return this.root;
    }

    public Key unroot() {
        Key key = this.root;
        this.root = null;
        return key;
    }

    public SplitDockTree<D> root(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (key.getTree() != this) {
            throw new IllegalArgumentException("Key is not created by this tree");
        }
        if (key.parent != null) {
            throw new IllegalArgumentException("Key has a parent, and can't be the root");
        }
        this.root = key;
        return this;
    }

    public Key put(D d, long l) {
        boolean[] blArray = this.array(true);
        blArray[0] = d;
        return this.put((D[])blArray, (D)null, l);
    }

    public Key put(D ... DArray) {
        return this.put(DArray, (D)null);
    }

    public Key put(D[] DArray, D d) {
        return this.put(DArray, d, -1L);
    }

    public Key put(D[] DArray, D d, long l) {
        return this.put(DArray, d, null, null, l);
    }

    public Key put(Path[] pathArray, PlaceholderMap placeholderMap) {
        return this.put(pathArray, placeholderMap, -1L);
    }

    public Key put(Path[] pathArray, PlaceholderMap placeholderMap, long l) {
        return this.put((D[])null, (D)null, pathArray, placeholderMap, l);
    }

    public Key put(D[] DArray, D d, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
        if (pathArray == null || pathArray.length == 0) {
            if (DArray == null) {
                throw new IllegalArgumentException("Dockables must not be null");
            }
            if (DArray.length == 0) {
                throw new IllegalArgumentException("At least one Dockable is required");
            }
        }
        if (DArray != null) {
            D[] DArray2 = DArray;
            int n = DArray.length;
            int n2 = 0;
            while (n2 < n) {
                D d2 = DArray2[n2];
                if (d2 == null) {
                    throw new IllegalArgumentException("Entries of array must not be null");
                }
                if (!this.dockables.add(d2)) {
                    throw new IllegalArgumentException("Dockable already known");
                }
                ++n2;
            }
        }
        return new Leaf(DArray, d, pathArray, placeholderMap, l);
    }

    public Key horizontal(D d, D d2) {
        return this.horizontal(this.put(this.array(d)), this.put(this.array(d2)));
    }

    public Key horizontal(D d, D d2, double d3) {
        return this.horizontal(this.put(this.array(d)), this.put(this.array(d2)), d3);
    }

    public Key horizontal(Key key, Key key2) {
        return this.horizontal(key, key2, 0.5);
    }

    public Key horizontal(Key key, Key key2, double d) {
        return this.horizontal(key, key2, d, -1L);
    }

    public Key horizontal(Key key, Key key2, double d, long l) {
        return this.horizontal(key, key2, d, null, null, l);
    }

    public Key horizontal(Key key, Key key2, double d, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
        return new Node(key, key2, d, true, pathArray, placeholderMap, l);
    }

    public Key vertical(D d, D d2) {
        return this.vertical(this.put(this.array(d)), this.put(this.array(d2)));
    }

    public Key vertical(D d, D d2, double d3) {
        return this.vertical(this.put(this.array(d)), this.put(this.array(d2)), d3);
    }

    public Key vertical(Key key, Key key2) {
        return this.vertical(key, key2, 0.5);
    }

    public Key vertical(Key key, Key key2, double d) {
        return this.vertical(key, key2, d, -1L);
    }

    public Key vertical(Key key, Key key2, double d, long l) {
        return this.vertical(key, key2, d, null, null, l);
    }

    public Key vertical(Key key, Key key2, double d, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
        return new Node(key, key2, d, false, pathArray, placeholderMap, l);
    }

    public Key getRoot() {
        return this.root;
    }

    public boolean isDockable(Key key) {
        return key.asLeaf() != null;
    }

    public boolean isNode(Key key) {
        return key.asNode() != null;
    }

    public boolean isPlaceholder(Key key) {
        return key.placeholders != null && key.placeholders.length > 0;
    }

    public Path[] getPlaceholders(Key key) {
        return key.placeholders;
    }

    public PlaceholderMap getPlaceholderMap(Key key) {
        return key.placeholderMap;
    }

    public D[] getDockables() {
        return this.dockables.toArray(this.array((D)this.dockables.size()));
    }

    public D[] getDockables(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().dockables;
    }

    public D getSelected(Key key) {
        if (!this.isDockable(key)) {
            throw new IllegalArgumentException("Not a Dockable");
        }
        return key.asLeaf().selected;
    }

    public boolean isHorizontal(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().horizontal;
    }

    public Key getLeft(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getRight(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public Key getTop(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyA;
    }

    public Key getBottom(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().keyB;
    }

    public double getDivider(Key key) {
        if (!this.isNode(key)) {
            throw new IllegalArgumentException("Not a node");
        }
        return key.asNode().divider;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.getClass().getName()) + "[root=\n");
        if (this.root == null) {
            stringBuilder.append("null");
        } else {
            this.root.toString(stringBuilder, 1);
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public abstract class Key {
        private Key parent;
        private long id;
        private Path[] placeholders;
        private PlaceholderMap placeholderMap;

        public Key(Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            this.id = l;
            if (pathArray != null) {
                this.placeholders = (Path[])pathArray.clone();
            }
            if (placeholderMap != null) {
                this.placeholderMap = placeholderMap.copy();
            }
        }

        protected abstract void toString(StringBuilder var1, int var2);

        public SplitDockTree<D> getTree() {
            return SplitDockTree.this;
        }

        public Key getParent() {
            return this.parent;
        }

        private void setParent(Key key) {
            this.parent = key;
        }

        public void setNodeId(long l) {
            this.id = l;
        }

        public long getNodeId() {
            return this.id;
        }

        protected Leaf asLeaf() {
            return null;
        }

        protected Node asNode() {
            return null;
        }
    }

    private class Leaf
    extends Key {
        public D[] dockables;
        public D selected;

        public Leaf(D[] DArray, D d, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            super(pathArray, placeholderMap, l);
            if (DArray != null) {
                this.dockables = (Object[])DArray.clone();
            }
            this.selected = d;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, int n) {
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append("\t");
                ++n2;
            }
            stringBuilder.append("Leaf[dockables: ").append(this.dockables == null ? 0 : this.dockables.length);
            Path[] pathArray = SplitDockTree.this.getPlaceholders(this);
            if (pathArray != null) {
                stringBuilder.append(", placeholders: ");
                Path[] pathArray2 = pathArray;
                int n3 = pathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Path path = pathArray2[n4];
                    stringBuilder.append(path);
                    ++n4;
                }
            }
            stringBuilder.append("]");
        }
    }

    private class Node
    extends Key {
        public Key keyA;
        public Key keyB;
        public double divider;
        public boolean horizontal;

        public Node(Key key, Key key2, double d, boolean bl, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            super(pathArray, placeholderMap, l);
            if (key.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of first argument belongs not to this tree");
            }
            if (key2.getTree() != this.getTree()) {
                throw new IllegalArgumentException("Key of second argument belongs not to this tree");
            }
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("Divider out of bounds, must be between 0 and 1");
            }
            if (key.getParent() != null) {
                throw new IllegalArgumentException("First key already has a parent");
            }
            if (key2.getParent() != null) {
                throw new IllegalArgumentException("Second key already has a parent");
            }
            if (key == key2) {
                throw new IllegalArgumentException("The arguments must not be the same object");
            }
            if (key == SplitDockTree.this.root) {
                throw new IllegalArgumentException("First argument is the root, can't be a child of any other node");
            }
            if (key2 == SplitDockTree.this.root) {
                throw new IllegalArgumentException("Second argument is the root, can't be a child of any other node");
            }
            key.setParent((Key)this);
            key2.setParent((Key)this);
            this.keyA = key;
            this.keyB = key2;
            this.divider = d;
            this.horizontal = bl;
        }

        @Override
        protected Node asNode() {
            return this;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, int n) {
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append("\t");
                ++n2;
            }
            stringBuilder.append("Node[divider: ").append(this.divider);
            Path[] pathArray = SplitDockTree.this.getPlaceholders(this);
            if (pathArray != null) {
                stringBuilder.append(", placeholders: ");
                Path[] pathArray2 = pathArray;
                int n3 = pathArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Path path = pathArray2[n4];
                    stringBuilder.append(path);
                    ++n4;
                }
            }
            stringBuilder.append("]\n");
            this.keyA.toString(stringBuilder, n + 1);
            stringBuilder.append("\n");
            this.keyB.toString(stringBuilder, n + 1);
        }
    }
}

