/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class SplitDockStationLayout {
    private Entry root;
    private int fullscreen;
    private boolean hasFullscreenAction;

    @Deprecated
    public SplitDockStationLayout(Entry entry, int n) {
        this(entry, n, true);
    }

    public SplitDockStationLayout(Entry entry, int n, boolean bl) {
        this.root = entry;
        this.fullscreen = n;
        this.hasFullscreenAction = bl;
    }

    public Entry getRoot() {
        return this.root;
    }

    public int getFullscreen() {
        return this.fullscreen;
    }

    public boolean hasFullscreenAction() {
        return this.hasFullscreenAction;
    }

    public static abstract class Entry {
        private Node parent;
        private long id;
        private Path[] placeholders;
        private PlaceholderMap placeholderMap;

        public Entry(Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            this.placeholders = pathArray;
            this.placeholderMap = placeholderMap;
            this.id = l;
        }

        protected void setParent(Node node) {
            this.parent = node;
        }

        public Node getParent() {
            return this.parent;
        }

        public long getNodeId() {
            return this.id;
        }

        public Leaf asLeaf() {
            return null;
        }

        public Node asNode() {
            return null;
        }

        public abstract boolean isVisible();

        public SplitDockPathProperty createPathProperty() {
            SplitDockPathProperty splitDockPathProperty = null;
            splitDockPathProperty = this.parent != null ? this.parent.createPathProperty(this) : new SplitDockPathProperty();
            splitDockPathProperty.setLeafId(this.getNodeId());
            return splitDockPathProperty;
        }

        public Path[] getPlaceholders() {
            return this.placeholders;
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }
    }

    public static class Leaf
    extends Entry {
        private int id;

        public Leaf(int n, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            super(pathArray, placeholderMap, l);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.id != -1;
        }
    }

    public static class Node
    extends Entry {
        private SplitDockStation.Orientation orientation;
        private double divider;
        private Entry childA;
        private Entry childB;

        public Node(SplitDockStation.Orientation orientation, double d, Entry entry, Entry entry2, Path[] pathArray, PlaceholderMap placeholderMap, long l) {
            super(pathArray, placeholderMap, l);
            this.orientation = orientation;
            this.divider = d;
            this.childA = entry;
            this.childB = entry2;
            if (entry != null) {
                entry.setParent(this);
            }
            if (entry2 != null) {
                entry2.setParent(this);
            }
        }

        @Override
        public Node asNode() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.childA.isVisible() && this.childB.isVisible();
        }

        public SplitDockPathProperty createPathProperty(Entry entry) {
            boolean bl = this.childA.isVisible();
            boolean bl2 = this.childB.isVisible();
            if (bl && bl2) {
                SplitDockPathProperty splitDockPathProperty = this.createPathProperty();
                if (entry == this.childA) {
                    if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                        splitDockPathProperty.add(SplitDockPathProperty.Location.LEFT, this.divider, entry.getNodeId());
                    } else {
                        splitDockPathProperty.add(SplitDockPathProperty.Location.TOP, this.divider, entry.getNodeId());
                    }
                } else if (entry == this.childB) {
                    if (this.orientation == SplitDockStation.Orientation.HORIZONTAL) {
                        splitDockPathProperty.add(SplitDockPathProperty.Location.RIGHT, 1.0 - this.divider, entry.getNodeId());
                    } else {
                        splitDockPathProperty.add(SplitDockPathProperty.Location.BOTTOM, 1.0 - this.divider, entry.getNodeId());
                    }
                }
                return splitDockPathProperty;
            }
            Node node = this.getParent();
            if (node != null) {
                return node.createPathProperty(this);
            }
            return new SplitDockPathProperty();
        }

        public SplitDockStation.Orientation getOrientation() {
            return this.orientation;
        }

        public double getDivider() {
            return this.divider;
        }

        public Entry getChildA() {
            return this.childA;
        }

        public Entry getChildB() {
            return this.childB;
        }
    }
}

