/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockStationLayout;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class SplitDockStationFactory
implements DockFactory<SplitDockStation, SplitDockPerspective, SplitDockStationLayout> {
    public static final String ID = "SplitDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    protected SplitDockStationLayout createLayout(SplitDockStation splitDockStation, SplitDockStationLayout.Entry entry, int n, boolean bl) {
        return this.createLayout(entry, n, bl);
    }

    protected SplitDockStationLayout createLayout(SplitDockPerspective splitDockPerspective, SplitDockStationLayout.Entry entry, int n, boolean bl) {
        return this.createLayout(entry, n, bl);
    }

    protected SplitDockStationLayout createLayout(SplitDockStationLayout.Entry entry, int n, boolean bl) {
        return new SplitDockStationLayout(entry, n, bl);
    }

    @Override
    public SplitDockStationLayout getLayout(SplitDockStation splitDockStation, final Map<Dockable, Integer> map) {
        SplitDockStationLayout.Entry entry = splitDockStation.visit(new SplitTreeFactory<SplitDockStationLayout.Entry>(splitDockStation){
            private PlaceholderStrategy strategy;
            {
                this.strategy = splitDockStation.getPlaceholderStrategy();
            }

            @Override
            public SplitDockStationLayout.Entry leaf(Dockable dockable, long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                Integer n = (Integer)map.get(dockable);
                pathArray = DockUtilities.mergePlaceholders(pathArray, dockable, this.strategy);
                if (n != null) {
                    return new SplitDockStationLayout.Leaf(n, pathArray, placeholderMap, l);
                }
                if (pathArray != null && pathArray.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, pathArray, placeholderMap, l);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry placeholder(long l, Path[] pathArray, PlaceholderMap placeholderMap) {
                if (pathArray != null && pathArray.length > 0) {
                    return new SplitDockStationLayout.Leaf(-1, pathArray, placeholderMap, l);
                }
                return null;
            }

            @Override
            public SplitDockStationLayout.Entry root(SplitDockStationLayout.Entry entry, long l) {
                return entry;
            }

            @Override
            public SplitDockStationLayout.Entry horizontal(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.HORIZONTAL, d, entry, entry2, pathArray, placeholderMap, l);
            }

            @Override
            public SplitDockStationLayout.Entry vertical(SplitDockStationLayout.Entry entry, SplitDockStationLayout.Entry entry2, double d, long l, Path[] pathArray, PlaceholderMap placeholderMap, boolean bl) {
                if (entry == null) {
                    return entry2;
                }
                if (entry2 == null) {
                    return entry;
                }
                return new SplitDockStationLayout.Node(SplitDockStation.Orientation.VERTICAL, d, entry, entry2, pathArray, placeholderMap, l);
            }
        });
        Dockable dockable = splitDockStation.getFullScreen();
        Integer n = null;
        if (dockable != null) {
            n = map.get(dockable);
        }
        if (n == null) {
            return this.createLayout(splitDockStation, entry, -1, splitDockStation.hasFullScreenAction());
        }
        return this.createLayout(splitDockStation, entry, (int)n, splitDockStation.hasFullScreenAction());
    }

    @Override
    public SplitDockStationLayout getPerspectiveLayout(SplitDockPerspective splitDockPerspective, Map<PerspectiveDockable, Integer> map) {
        if (map == null) {
            return this.createLayout(null, -1, splitDockPerspective.hasFullscreenAction());
        }
        SplitDockStationLayout.Entry entry = this.convert(splitDockPerspective.getRoot(), map);
        PerspectiveDockable perspectiveDockable = splitDockPerspective.getFullscreen();
        Integer n = null;
        if (perspectiveDockable != null) {
            n = map.get(perspectiveDockable);
        }
        if (n == null) {
            return this.createLayout(splitDockPerspective, entry, -1, splitDockPerspective.hasFullscreenAction());
        }
        return this.createLayout(splitDockPerspective, entry, (int)n, splitDockPerspective.hasFullscreenAction());
    }

    private SplitDockStationLayout.Entry convert(SplitDockPerspective.Entry entry, Map<PerspectiveDockable, Integer> map) {
        if (entry == null) {
            return null;
        }
        if (entry.asNode() != null) {
            SplitDockPerspective.Node node = entry.asNode();
            SplitDockStationLayout.Entry entry2 = this.convert(node.getChildA(), map);
            SplitDockStationLayout.Entry entry3 = this.convert(node.getChildB(), map);
            if (entry2 == null) {
                return entry3;
            }
            if (entry3 == null) {
                return entry2;
            }
            return new SplitDockStationLayout.Node(node.getOrientation(), node.getDivider(), entry2, entry3, this.toArray(node.getPlaceholders()), node.getPlaceholderMap(), node.getNodeId());
        }
        if (entry.asLeaf() != null) {
            SplitDockPerspective.Leaf leaf = entry.asLeaf();
            Integer n = map.get(leaf.getDockable());
            return new SplitDockStationLayout.Leaf(n == null ? -1 : n, this.toArray(leaf.getPlaceholders()), leaf.getPlaceholderMap(), leaf.getNodeId());
        }
        return this.convert(((SplitDockPerspective.Root)entry).getChild(), map);
    }

    private Path[] toArray(Set<Path> set) {
        if (set == null) {
            return null;
        }
        return set.toArray(new Path[set.size()]);
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        DockableSplitDockTree dockableSplitDockTree = new DockableSplitDockTree();
        SplitDockTree.Key key = null;
        if (splitDockStationLayout.getRoot() != null) {
            key = this.handleEntry(splitDockStationLayout.getRoot(), dockableSplitDockTree, map);
        }
        if (key != null) {
            dockableSplitDockTree.root(key);
        }
        splitDockStation.dropTree(dockableSplitDockTree, false);
        PlaceholderStrategy placeholderStrategy2 = splitDockStation.getPlaceholderStrategy().getStrategy();
        if (placeholderStrategy != placeholderStrategy2 && placeholderStrategy != null) {
            try {
                splitDockStation.setPlaceholderStrategy(placeholderStrategy);
            }
            finally {
                splitDockStation.setPlaceholderStrategy(placeholderStrategy2);
            }
        }
        Dockable dockable = map.get(splitDockStationLayout.getFullscreen());
        splitDockStation.setFullScreen(dockable);
    }

    @Override
    public SplitDockPerspective layoutPerspective(SplitDockStationLayout splitDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        SplitDockPerspective splitDockPerspective = new SplitDockPerspective();
        this.layoutPerspective(splitDockPerspective, splitDockStationLayout, map);
        return splitDockPerspective;
    }

    @Override
    public void layoutPerspective(SplitDockPerspective splitDockPerspective, SplitDockStationLayout splitDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        if (map != null) {
            PerspectiveSplitDockTree perspectiveSplitDockTree = new PerspectiveSplitDockTree();
            SplitDockTree.Key key = null;
            if (splitDockStationLayout.getRoot() != null) {
                key = this.handleEntry(splitDockStationLayout.getRoot(), perspectiveSplitDockTree, map);
            }
            if (key != null) {
                perspectiveSplitDockTree.root(key);
            }
            splitDockPerspective.read(perspectiveSplitDockTree, map.get(splitDockStationLayout.getFullscreen()));
        }
        splitDockPerspective.setHasFullscreenAction(splitDockStationLayout.hasFullscreenAction());
    }

    private <D> SplitDockTree.Key handleEntry(SplitDockStationLayout.Entry entry, SplitDockTree<D> splitDockTree, Map<Integer, D> map) {
        if (entry.asLeaf() != null) {
            return this.handleLeaf(entry.asLeaf(), splitDockTree, map);
        }
        return this.handleNode(entry.asNode(), splitDockTree, map);
    }

    private <D> SplitDockTree.Key handleLeaf(SplitDockStationLayout.Leaf leaf, SplitDockTree<D> splitDockTree, Map<Integer, D> map) {
        D d = map.get(leaf.getId());
        Path[] pathArray = leaf.getPlaceholders();
        PlaceholderMap placeholderMap = leaf.getPlaceholderMap();
        if (d != null) {
            return splitDockTree.put(splitDockTree.array(d), (Object)null, pathArray, placeholderMap, leaf.getNodeId());
        }
        if (pathArray != null && pathArray.length > 0) {
            return splitDockTree.put((D[])splitDockTree.array(false), (Object)null, pathArray, placeholderMap, leaf.getNodeId());
        }
        return null;
    }

    private <D> SplitDockTree.Key handleNode(SplitDockStationLayout.Node node, SplitDockTree<D> splitDockTree, Map<Integer, D> map) {
        SplitDockTree.Key key = this.handleEntry(node.getChildA(), splitDockTree, map);
        SplitDockTree.Key key2 = this.handleEntry(node.getChildB(), splitDockTree, map);
        if (key == null) {
            return key2;
        }
        if (key2 == null) {
            return key;
        }
        switch (node.getOrientation()) {
            case HORIZONTAL: {
                return splitDockTree.horizontal(key, key2, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
            case VERTICAL: {
                return splitDockTree.vertical(key, key2, node.getDivider(), node.getPlaceholders(), node.getPlaceholderMap(), node.getNodeId());
            }
        }
        return null;
    }

    @Override
    public void estimateLocations(SplitDockStationLayout splitDockStationLayout, LocationEstimationMap locationEstimationMap) {
        this.estimateLocations(splitDockStationLayout.getRoot(), locationEstimationMap);
    }

    @Override
    private void estimateLocations(SplitDockStationLayout.Entry entry, LocationEstimationMap locationEstimationMap) {
        Object object;
        if (entry == null) {
            return;
        }
        SplitDockStationLayout.Leaf leaf = entry.asLeaf();
        if (leaf != null && (object = locationEstimationMap.getChild(leaf.getId())) != null) {
            SplitDockPathProperty splitDockPathProperty = leaf.createPathProperty();
            Path path = ((DockLayoutInfo)object).getPlaceholder();
            if (path != null) {
                ((DockLayoutInfo)object).setLocation(new SplitDockPlaceholderProperty(path, splitDockPathProperty));
            } else {
                ((DockLayoutInfo)object).setLocation(splitDockPathProperty);
            }
            int n = 0;
            int n2 = locationEstimationMap.getSubChildCount(leaf.getId());
            while (n < n2) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(leaf.getId(), n);
                path = dockLayoutInfo.getPlaceholder();
                if (path != null) {
                    dockLayoutInfo.setLocation(new SplitDockPlaceholderProperty(path, splitDockPathProperty));
                }
                ++n;
            }
        }
        if ((object = entry.asNode()) != null) {
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildA(), locationEstimationMap);
            this.estimateLocations(((SplitDockStationLayout.Node)object).getChildB(), locationEstimationMap);
        }
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        SplitDockStation splitDockStation = this.createStation(splitDockStationLayout.hasFullscreenAction());
        this.setLayout(splitDockStation, splitDockStationLayout, placeholderStrategy);
        return splitDockStation;
    }

    @Override
    public SplitDockStation layout(SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        SplitDockStation splitDockStation = this.createStation(splitDockStationLayout.hasFullscreenAction());
        this.setLayout(splitDockStation, splitDockStationLayout, map, placeholderStrategy);
        return splitDockStation;
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_0);
        SplitDockStationLayout.Entry entry = splitDockStationLayout.getRoot();
        if (entry == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.writeEntry(entry, dataOutputStream);
        }
        dataOutputStream.writeInt(splitDockStationLayout.getFullscreen());
        dataOutputStream.writeBoolean(splitDockStationLayout.hasFullscreenAction());
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, DataOutputStream dataOutputStream) throws IOException {
        Object object;
        dataOutputStream.writeLong(entry.getNodeId());
        Path[] pathArray = entry.getPlaceholders();
        PlaceholderMap placeholderMap = entry.getPlaceholderMap();
        int n = 0;
        if (entry.asNode() != null) {
            n |= 1;
        }
        if (pathArray != null && pathArray.length > 0) {
            n |= 2;
        }
        if (placeholderMap != null) {
            n |= 4;
        }
        dataOutputStream.writeByte(n);
        if (pathArray != null && pathArray.length > 0) {
            dataOutputStream.writeInt(pathArray.length);
            Path[] pathArray2 = pathArray;
            int n2 = pathArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = pathArray2[n3];
                dataOutputStream.writeUTF(((Path)object).toString());
                ++n3;
            }
        }
        if (placeholderMap != null) {
            placeholderMap.write(dataOutputStream);
        }
        if (entry.asLeaf() != null) {
            dataOutputStream.writeInt(entry.asLeaf().getId());
        } else {
            object = entry.asNode();
            dataOutputStream.writeInt(((SplitDockStationLayout.Node)object).getOrientation().ordinal());
            dataOutputStream.writeDouble(((SplitDockStationLayout.Node)object).getDivider());
            this.writeEntry(((SplitDockStationLayout.Node)object).getChildA(), dataOutputStream);
            this.writeEntry(((SplitDockStationLayout.Node)object).getChildB(), dataOutputStream);
        }
    }

    @Override
    public SplitDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean bl2 = Version.VERSION_1_0_8a.compareTo(version) <= 0;
        boolean bl3 = Version.VERSION_1_1_0.compareTo(version) <= 0;
        SplitDockStationLayout.Entry entry = null;
        if (dataInputStream.readBoolean()) {
            entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
        }
        int n = dataInputStream.readInt();
        boolean bl4 = true;
        if (bl3) {
            bl4 = dataInputStream.readBoolean();
        }
        return this.createLayout(entry, n, bl4);
    }

    private SplitDockStationLayout.Entry readEntry(DataInputStream dataInputStream, boolean bl, boolean bl2, PlaceholderStrategy placeholderStrategy) throws IOException {
        long l = -1L;
        if (bl) {
            l = dataInputStream.readLong();
        }
        if (bl2) {
            byte by = dataInputStream.readByte();
            boolean bl3 = (by & 1) != 0;
            boolean bl4 = (by & 2) != 0;
            boolean bl5 = (by & 4) != 0;
            Path[] pathArray = null;
            if (bl4) {
                pathArray = new Path[dataInputStream.readInt()];
                int n = 0;
                while (n < pathArray.length) {
                    pathArray[n] = new Path(dataInputStream.readUTF());
                    ++n;
                }
            }
            PlaceholderMap placeholderMap = null;
            if (bl5) {
                placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
                placeholderMap.setPlaceholderStrategy(null);
            }
            if (bl3) {
                SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
                double d = dataInputStream.readDouble();
                SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
                SplitDockStationLayout.Entry entry2 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
                return new SplitDockStationLayout.Node(orientation, d, entry, entry2, pathArray, placeholderMap, l);
            }
            return new SplitDockStationLayout.Leaf(dataInputStream.readInt(), pathArray, placeholderMap, l);
        }
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return new SplitDockStationLayout.Leaf(dataInputStream.readInt(), null, null, l);
        }
        if (by == 1) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
            double d = dataInputStream.readDouble();
            SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            SplitDockStationLayout.Entry entry3 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            return new SplitDockStationLayout.Node(orientation, d, entry, entry3, null, null, l);
        }
        if (by == 2) {
            int n = dataInputStream.readInt();
            Path[] pathArray = this.readPlaceholders(dataInputStream, placeholderStrategy);
            return new SplitDockStationLayout.Leaf(n, pathArray, null, l);
        }
        if (by == 3) {
            SplitDockStation.Orientation orientation = SplitDockStation.Orientation.values()[dataInputStream.readInt()];
            double d = dataInputStream.readDouble();
            Path[] pathArray = this.readPlaceholders(dataInputStream, placeholderStrategy);
            SplitDockStationLayout.Entry entry = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            SplitDockStationLayout.Entry entry4 = this.readEntry(dataInputStream, bl, bl2, placeholderStrategy);
            return new SplitDockStationLayout.Node(orientation, d, entry, entry4, pathArray, null, l);
        }
        throw new IOException("unknown kind: " + by);
    }

    private Path[] readPlaceholders(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        int n = dataInputStream.readInt();
        ArrayList<Path> arrayList = new ArrayList<Path>(n);
        int n2 = 0;
        while (n2 < n) {
            Path path = new Path(dataInputStream.readUTF());
            if (placeholderStrategy == null || placeholderStrategy.isValidPlaceholder(path)) {
                arrayList.add(path);
            }
            ++n2;
        }
        return arrayList.toArray(new Path[arrayList.size()]);
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, XElement xElement) {
        if (splitDockStationLayout.getFullscreen() != -1) {
            xElement.addElement("fullscreen").addInt("id", splitDockStationLayout.getFullscreen());
        }
        xElement.addElement("fullscreen-action").setBoolean(splitDockStationLayout.hasFullscreenAction());
        if (splitDockStationLayout.getRoot() != null) {
            this.writeEntry(splitDockStationLayout.getRoot(), xElement);
        }
    }

    private void writeEntry(SplitDockStationLayout.Entry entry, XElement xElement) {
        Object object;
        Object object2;
        XElement xElement2;
        if (entry.asLeaf() != null) {
            xElement2 = xElement.addElement("leaf");
            xElement2.addInt("id", entry.asLeaf().getId()).addLong("nodeId", entry.getNodeId());
        } else {
            xElement2 = xElement.addElement("node");
            xElement2.addLong("nodeId", entry.getNodeId());
            xElement2.addString("orientation", entry.asNode().getOrientation().name());
            xElement2.addDouble("divider", entry.asNode().getDivider());
            this.writeEntry(entry.asNode().getChildA(), xElement2);
            this.writeEntry(entry.asNode().getChildB(), xElement2);
        }
        Path[] pathArray = entry.getPlaceholders();
        if (pathArray != null && pathArray.length > 0) {
            object2 = xElement2.addElement("placeholders");
            Path[] pathArray2 = pathArray;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = pathArray2[n2];
                ((XElement)object2).addElement("placeholder").setString(((Path)object).toString());
                ++n2;
            }
        }
        if ((object2 = entry.getPlaceholderMap()) != null) {
            object = xElement2.addElement("placeholder-map");
            ((PlaceholderMap)object2).write((XElement)object);
        }
    }

    @Override
    public SplitDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        SplitDockStationLayout.Entry entry = null;
        XElement xElement2 = xElement.getElement("node");
        if (xElement2 == null) {
            xElement2 = xElement.getElement("leaf");
        }
        if (xElement2 != null) {
            entry = this.readEntry(xElement2, placeholderStrategy);
        }
        int n = -1;
        XElement xElement3 = xElement.getElement("fullscreen");
        if (xElement3 != null) {
            n = xElement3.getInt("id");
        }
        XElement xElement4 = xElement.getElement("fullscreen-action");
        boolean bl = true;
        if (xElement4 != null) {
            bl = xElement4.getBoolean();
        }
        return this.createLayout(entry, n, bl);
    }

    private SplitDockStationLayout.Entry readEntry(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        Iterable<XElement> iterable;
        Object object;
        long l = -1L;
        if (xElement.attributeExists("nodeId")) {
            l = xElement.getLong("nodeId");
        }
        Path[] pathArray = null;
        XElement xElement2 = xElement.getElement("placeholders");
        if (xElement2 != null && ((XElement[])(object = xElement2.getElements("placeholder"))).length > 0) {
            iterable = new ArrayList(((XElement[])object).length);
            int n = 0;
            while (n < ((Object)object).length) {
                Path path = new Path(((XElement)object[n]).getString());
                if (placeholderStrategy == null || placeholderStrategy.isValidPlaceholder(path)) {
                    iterable.add((Path)path);
                }
                ++n;
            }
            pathArray = iterable.toArray((Path[])new Path[iterable.size()]);
        }
        object = null;
        iterable = xElement.getElement("placeholder-map");
        if (iterable != null) {
            object = new PlaceholderMap((XElement)iterable, placeholderStrategy);
            ((PlaceholderMap)object).setPlaceholderStrategy(null);
        }
        if ("leaf".equals(xElement.getName())) {
            return new SplitDockStationLayout.Leaf(xElement.getInt("id"), pathArray, (PlaceholderMap)object, l);
        }
        if ("node".equals(xElement.getName())) {
            XElement[] xElementArray = xElement.getElements("leaf", "node");
            if (xElementArray.length != 2) {
                throw new XException("node element must have exactly least two children: " + xElement);
            }
            return new SplitDockStationLayout.Node(SplitDockStation.Orientation.valueOf(xElement.getString("orientation")), xElement.getDouble("divider"), this.readEntry(xElementArray[0], placeholderStrategy), this.readEntry(xElementArray[1], placeholderStrategy), pathArray, (PlaceholderMap)object, l);
        }
        throw new XException("element neither leaf nor node: " + xElement);
    }

    protected SplitDockStation createStation(boolean bl) {
        return new SplitDockStation(bl);
    }
}

