/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitDockProperty
extends AbstractDockableProperty {
    public static final SplitDockProperty EAST = new SplitDockProperty(0.75, 0.0, 0.25, 1.0);
    public static final SplitDockProperty WEST = new SplitDockProperty(0.0, 0.0, 0.25, 1.0);
    public static final SplitDockProperty NORTH = new SplitDockProperty(0.0, 0.0, 1.0, 0.25);
    public static final SplitDockProperty SOUTH = new SplitDockProperty(0.0, 0.75, 1.0, 0.25);
    private double x;
    private double y;
    private double width;
    private double height;

    public SplitDockProperty() {
    }

    public SplitDockProperty(double d, double d2, double d3, double d4) {
        this.setX(d);
        this.setY(d2);
        this.setWidth(d3);
        this.setHeight(d4);
    }

    @Override
    public DockableProperty copy() {
        SplitDockProperty splitDockProperty = new SplitDockProperty(this.x, this.y, this.width, this.height);
        this.copy(splitDockProperty);
        return splitDockProperty;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPropertyFactory";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeDouble(this.x);
        dataOutputStream.writeDouble(this.y);
        dataOutputStream.writeDouble(this.width);
        dataOutputStream.writeDouble(this.height);
    }

    @Override
    public void store(XElement xElement) {
        xElement.addElement("x").setDouble(this.x);
        xElement.addElement("y").setDouble(this.y);
        xElement.addElement("width").setDouble(this.width);
        xElement.addElement("height").setDouble(this.height);
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        this.x = dataInputStream.readDouble();
        this.y = dataInputStream.readDouble();
        this.width = dataInputStream.readDouble();
        this.height = dataInputStream.readDouble();
    }

    @Override
    public void load(XElement xElement) {
        this.x = xElement.getElement("x").getDouble();
        this.y = xElement.getElement("y").getDouble();
        this.width = xElement.getElement("width").getDouble();
        this.height = xElement.getElement("height").getDouble();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.height);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.width);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SplitDockProperty)) {
            return false;
        }
        SplitDockProperty splitDockProperty = (SplitDockProperty)object;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(splitDockProperty.height)) {
            return false;
        }
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(splitDockProperty.width)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(splitDockProperty.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(splitDockProperty.y);
    }
}

