/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.util.Path;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitDockPlaceholderProperty
extends AbstractDockableProperty {
    private Path placeholder;
    private DockableProperty backup;

    public SplitDockPlaceholderProperty() {
    }

    public SplitDockPlaceholderProperty(Path path) {
        this(path, (DockableProperty)null);
    }

    public SplitDockPlaceholderProperty(Path path, SplitDockProperty splitDockProperty) {
        this(path, (DockableProperty)splitDockProperty);
    }

    public SplitDockPlaceholderProperty(Path path, SplitDockPathProperty splitDockPathProperty) {
        this(path, (DockableProperty)splitDockPathProperty);
    }

    private SplitDockPlaceholderProperty(Path path, DockableProperty dockableProperty) {
        if (path == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        this.placeholder = path;
        this.backup = dockableProperty;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[placeholder=" + this.getPlaceholder() + ", backup=" + this.getBackup() + ", successor=" + this.getSuccessor() + "]";
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public DockableProperty toLocation(SplitNode splitNode) {
        if (this.backup == null) {
            return this.toSplitLocation(splitNode);
        }
        return this.backup;
    }

    public SplitDockProperty toSplitLocation(SplitNode splitNode) {
        if (this.backup instanceof SplitDockProperty) {
            return (SplitDockProperty)this.backup;
        }
        if (this.backup instanceof SplitDockPathProperty) {
            return ((SplitDockPathProperty)this.backup).toLocation(splitNode);
        }
        SplitDockProperty splitDockProperty = new SplitDockProperty(splitNode.getX(), splitNode.getY(), splitNode.getWidth(), splitNode.getHeight());
        splitDockProperty.setSuccessor(this.getSuccessor());
        return splitDockProperty;
    }

    @Override
    public void setSuccessor(DockableProperty dockableProperty) {
        super.setSuccessor(dockableProperty);
        if (this.backup != null) {
            this.backup.setSuccessor(dockableProperty);
        }
    }

    public DockableProperty getBackup() {
        return this.backup;
    }

    @Override
    public SplitDockPlaceholderProperty copy() {
        SplitDockPlaceholderProperty splitDockPlaceholderProperty = new SplitDockPlaceholderProperty(this.placeholder, this.backup == null ? null : this.backup.copy());
        this.copy(splitDockPlaceholderProperty);
        return splitDockPlaceholderProperty;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPlaceholderProperty";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.placeholder.toString());
        if (this.backup == null) {
            dataOutputStream.writeByte(0);
        } else if (this.backup instanceof SplitDockProperty) {
            dataOutputStream.writeByte(1);
            this.backup.store(dataOutputStream);
        } else if (this.backup instanceof SplitDockPathProperty) {
            dataOutputStream.writeByte(2);
            this.backup.store(dataOutputStream);
        } else {
            throw new IllegalStateException("never happens");
        }
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        this.placeholder = new Path(dataInputStream.readUTF());
        switch (dataInputStream.readByte()) {
            case 0: {
                this.backup = null;
                break;
            }
            case 1: {
                this.backup = new SplitDockProperty();
                this.backup.load(dataInputStream);
                break;
            }
            case 2: {
                this.backup = new SplitDockPathProperty();
                this.backup.load(dataInputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of backup property");
            }
        }
    }

    @Override
    public void store(XElement xElement) {
        xElement.addElement("placeholder").setString(this.placeholder.toString());
        if (this.backup instanceof SplitDockProperty) {
            this.backup.store(xElement.addElement("backup-location"));
        } else if (this.backup instanceof SplitDockPathProperty) {
            this.backup.store(xElement.addElement("backup-path"));
        }
    }

    @Override
    public void load(XElement xElement) {
        this.placeholder = new Path(xElement.getElement("placeholder").getString());
        this.backup = null;
        XElement xElement2 = xElement.getElement("backup-path");
        if (xElement2 != null) {
            this.backup = new SplitDockPathProperty();
            this.backup.load(xElement2);
        } else {
            xElement2 = xElement.getElement("backup-location");
            if (xElement2 != null) {
                this.backup = new SplitDockProperty();
                this.backup.load(xElement2);
            }
        }
    }
}

