/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeAdapter;
import bibliothek.util.Path;
import java.util.ArrayList;

public class SplitDockPlaceholderMapping
implements PlaceholderMapping {
    private SplitDockStation station;

    public SplitDockPlaceholderMapping(SplitDockStation splitDockStation) {
        this.station = splitDockStation;
    }

    @Override
    public SplitDockStation getStation() {
        return this.station;
    }

    @Override
    public void addPlaceholder(Dockable dockable, Path path) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        Leaf leaf = this.station.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("unable to find location of dockable");
        }
        this.removePlaceholder(leaf, path);
        leaf.addPlaceholder(path);
    }

    @Override
    public void removePlaceholder(Path path) {
        this.removePlaceholder(null, path);
    }

    private void removePlaceholder(final Leaf leaf, final Path path) {
        final ArrayList arrayList = new ArrayList();
        this.station.getRoot().visit(new SplitNodeAdapter(){

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                placeholder.removePlaceholder(path);
                if (!placeholder.isOfUse()) {
                    arrayList.add(placeholder);
                }
            }

            @Override
            protected void handle(SplitNode splitNode) {
                if (splitNode != leaf) {
                    splitNode.removePlaceholder(path);
                }
            }
        });
        for (Placeholder placeholder : arrayList) {
            placeholder.delete(true);
        }
    }

    @Override
    public Dockable getDockableAt(Path path) {
        FindDockable findDockable = new FindDockable(path);
        this.station.getRoot().visit(findDockable);
        return findDockable.getResult();
    }

    @Override
    public DockableProperty getLocationAt(Path path) {
        SplitDockPathProperty splitDockPathProperty = this.station.getDockablePathProperty(path);
        return new SplitDockPlaceholderProperty(path, splitDockPathProperty);
    }

    @Override
    public boolean hasPlaceholder(Path path) {
        HasPlaceholderFinder hasPlaceholderFinder = new HasPlaceholderFinder(path);
        this.station.getRoot().visit(hasPlaceholderFinder);
        return hasPlaceholderFinder.isFound();
    }

    private static class FindDockable
    extends SplitNodeAdapter {
        private Path placeholder;
        private Dockable result;

        public FindDockable(Path path) {
            this.placeholder = path;
        }

        @Override
        public void handleLeaf(Leaf leaf) {
            if (leaf.hasPlaceholder(this.placeholder)) {
                this.result = leaf.getDockable();
            }
        }

        public Dockable getResult() {
            return this.result;
        }
    }

    private static class HasPlaceholderFinder
    extends SplitNodeAdapter {
        private Path placeholder;
        private boolean found;

        public HasPlaceholderFinder(Path path) {
            this.placeholder = path;
        }

        @Override
        protected void handle(SplitNode splitNode) {
            if (splitNode.hasPlaceholder(this.placeholder)) {
                this.found = true;
            }
        }

        public boolean isFound() {
            return this.found;
        }
    }
}

