/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitPerspectivePlaceholderConverter;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitDockPerspective
implements PerspectiveDockable,
PerspectiveStation {
    private PerspectiveStation parent;
    private PerspectiveDockable fullscreen;
    private final Root root = new Root();
    private List<PerspectiveDockable> children = new ArrayList<PerspectiveDockable>();
    private List<EntryListener> listeners = new ArrayList<EntryListener>();
    private boolean hasFullscreenAction = true;

    public SplitDockPerspective() {
        this.addListener(new EntryListener(){

            @Override
            public void added(Entry entry, Entry entry2) {
                this.add(entry2);
            }

            @Override
            public void removed(Entry entry, Entry entry2) {
                this.remove(entry2);
            }

            @Override
            public void modified(Leaf leaf, PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
                if (perspectiveDockable != null) {
                    SplitDockPerspective.this.children.remove(perspectiveDockable);
                    perspectiveDockable.setParent(null);
                }
                if (perspectiveDockable2 != null) {
                    DockUtilities.ensureTreeValidity(SplitDockPerspective.this, perspectiveDockable2);
                    SplitDockPerspective.this.children.add(perspectiveDockable2);
                    perspectiveDockable2.setParent(SplitDockPerspective.this);
                }
            }

            private void add(Entry entry) {
                if (entry != null) {
                    if (entry.asLeaf() != null) {
                        PerspectiveDockable perspectiveDockable = entry.asLeaf().getDockable();
                        if (perspectiveDockable != null) {
                            DockUtilities.ensureTreeValidity(SplitDockPerspective.this, perspectiveDockable);
                            perspectiveDockable.setParent(SplitDockPerspective.this);
                            SplitDockPerspective.this.children.add(perspectiveDockable);
                        }
                    } else {
                        this.add(entry.asNode().getChildA());
                        this.add(entry.asNode().getChildB());
                    }
                }
            }

            private void remove(Entry entry) {
                if (entry != null) {
                    if (entry.asLeaf() != null) {
                        PerspectiveDockable perspectiveDockable = entry.asLeaf().getDockable();
                        if (perspectiveDockable != null) {
                            SplitDockPerspective.this.children.remove(perspectiveDockable);
                            perspectiveDockable.setParent(null);
                        }
                    } else {
                        this.remove(entry.asNode().getChildA());
                        this.remove(entry.asNode().getChildB());
                    }
                }
            }
        });
    }

    public void addListener(EntryListener entryListener) {
        if (entryListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(entryListener);
    }

    public void removeListener(EntryListener entryListener) {
        this.listeners.remove(entryListener);
    }

    protected EntryListener[] listeners() {
        return this.listeners.toArray(new EntryListener[this.listeners.size()]);
    }

    protected void fireRemoved(Entry entry, Entry entry2) {
        EntryListener[] entryListenerArray = this.listeners();
        int n = entryListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryListener entryListener = entryListenerArray[n2];
            entryListener.removed(entry, entry2);
            ++n2;
        }
    }

    protected void fireAdded(Entry entry, Entry entry2) {
        EntryListener[] entryListenerArray = this.listeners();
        int n = entryListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntryListener entryListener = entryListenerArray[n2];
            entryListener.added(entry, entry2);
            ++n2;
        }
    }

    public void read(PerspectiveSplitDockTree perspectiveSplitDockTree, PerspectiveDockable perspectiveDockable) {
        this.root.setChild(this.convert(perspectiveSplitDockTree.getRoot()));
        if (perspectiveDockable != null && !this.children.contains(perspectiveDockable)) {
            throw new IllegalArgumentException("fullscreen is not a child of this station");
        }
        this.fullscreen = perspectiveDockable;
    }

    public void setHasFullscreenAction(boolean bl) {
        this.hasFullscreenAction = bl;
    }

    public boolean hasFullscreenAction() {
        return this.hasFullscreenAction;
    }

    protected PerspectiveDockable combine(PerspectiveDockable[] perspectiveDockableArray, PerspectiveDockable perspectiveDockable) {
        return new StackDockPerspective(perspectiveDockableArray, perspectiveDockable);
    }

    private Entry convert(SplitDockTree.Key key) {
        if (key == null) {
            return null;
        }
        SplitDockTree splitDockTree = key.getTree();
        if (splitDockTree.isDockable(key)) {
            PerspectiveDockable[] perspectiveDockableArray = (PerspectiveDockable[])splitDockTree.getDockables(key);
            PerspectiveDockable perspectiveDockable = null;
            if (perspectiveDockableArray != null && perspectiveDockableArray.length != 0) {
                if (perspectiveDockableArray.length == 1) {
                    perspectiveDockable = perspectiveDockableArray[0];
                } else if (perspectiveDockableArray.length > 1) {
                    perspectiveDockable = this.combine(perspectiveDockableArray, (PerspectiveDockable)splitDockTree.getSelected(key));
                }
                if (perspectiveDockable != null) {
                    DockUtilities.ensureTreeValidity(this, perspectiveDockable);
                    perspectiveDockable.setParent(this);
                }
            }
            return new Leaf(perspectiveDockable, this.toSet(splitDockTree.getPlaceholders(key)), splitDockTree.getPlaceholderMap(key), key.getNodeId());
        }
        if (splitDockTree.isNode(key)) {
            Entry entry = this.convert(splitDockTree.getLeft(key));
            Entry entry2 = this.convert(splitDockTree.getRight(key));
            SplitDockStation.Orientation orientation = splitDockTree.isHorizontal(key) ? SplitDockStation.Orientation.HORIZONTAL : SplitDockStation.Orientation.VERTICAL;
            return new Node(orientation, splitDockTree.getDivider(key), entry, entry2, this.toSet(splitDockTree.getPlaceholders(key)), splitDockTree.getPlaceholderMap(key), key.getNodeId());
        }
        throw new IllegalStateException("key does not represent any known kind of element");
    }

    private Set<Path> toSet(Path[] pathArray) {
        HashSet<Path> hashSet = new HashSet<Path>();
        if (pathArray != null) {
            Path[] pathArray2 = pathArray;
            int n = pathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray2[n2];
                hashSet.add(path);
                ++n2;
            }
        }
        return hashSet;
    }

    public PerspectiveDockable getFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(PerspectiveDockable perspectiveDockable) {
        if (perspectiveDockable.getParent() != this) {
            throw new IllegalArgumentException("not a child of this station");
        }
        this.fullscreen = perspectiveDockable;
    }

    public Root getRoot() {
        return this.root;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public void setParent(PerspectiveStation perspectiveStation) {
        this.parent = perspectiveStation;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    @Override
    public PerspectiveDockable getDockable(int n) {
        return this.children.get(n);
    }

    @Override
    public int getDockableCount() {
        return this.children.size();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        SplitPerspectivePlaceholderConverter splitPerspectivePlaceholderConverter = new SplitPerspectivePlaceholderConverter(this);
        splitPerspectivePlaceholderConverter.setPlaceholders(placeholderMap);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        SplitPerspectivePlaceholderConverter splitPerspectivePlaceholderConverter = new SplitPerspectivePlaceholderConverter(this);
        return splitPerspectivePlaceholderConverter.getPlaceholders();
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        Path path = null;
        path = perspectiveDockable2 != null ? perspectiveDockable2.getPlaceholder() : perspectiveDockable.getPlaceholder();
        SplitDockPathProperty splitDockPathProperty = this.getDockablePathProperty(perspectiveDockable);
        if (path == null) {
            return splitDockPathProperty;
        }
        return new SplitDockPlaceholderProperty(path, splitDockPathProperty);
    }

    public SplitDockPathProperty getDockablePathProperty(PerspectiveDockable perspectiveDockable) {
        Leaf leaf = this.getLeaf(perspectiveDockable);
        if (leaf == null) {
            return null;
        }
        SplitDockPathProperty splitDockPathProperty = new SplitDockPathProperty();
        splitDockPathProperty.setLeafId(leaf.getNodeId());
        Entry entry = leaf;
        Node node = leaf.getParent().asNode();
        while (node != null) {
            SplitDockPathProperty.Location location;
            double d;
            if (node.getChildA() == entry) {
                d = node.getDivider();
                location = node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? SplitDockPathProperty.Location.LEFT : SplitDockPathProperty.Location.TOP;
            } else {
                d = 1.0 - node.getDivider();
                location = node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? SplitDockPathProperty.Location.RIGHT : SplitDockPathProperty.Location.BOTTOM;
            }
            splitDockPathProperty.insert(location, d, 0, node.getNodeId());
            entry = node;
            node = node.getParent().asNode();
        }
        return splitDockPathProperty;
    }

    @Override
    public boolean remove(PerspectiveDockable perspectiveDockable) {
        Leaf leaf = this.getLeaf(perspectiveDockable);
        if (leaf != null) {
            leaf.remove();
            return true;
        }
        return false;
    }

    @Override
    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        Leaf leaf = this.getLeaf(perspectiveDockable);
        if (leaf == null) {
            throw new IllegalArgumentException("oldDockable not child of this station");
        }
        DockUtilities.ensureTreeValidity(this, perspectiveDockable2);
        PlaceholderMap placeholderMap = leaf.getPlaceholderMap();
        if (perspectiveDockable.asStation() != null) {
            placeholderMap = perspectiveDockable.asStation().getPlaceholders();
        }
        Leaf leaf2 = new Leaf(perspectiveDockable2, leaf.getPlaceholders(), placeholderMap, leaf.getNodeId());
        leaf.replace(leaf2);
        Path path = perspectiveDockable.getPlaceholder();
        if (path != null) {
            this.addPlaceholder(leaf2, path);
        }
    }

    public Leaf getLeaf(PerspectiveDockable perspectiveDockable) {
        return this.find(this.getRoot().getChild(), perspectiveDockable);
    }

    private Leaf find(Entry entry, PerspectiveDockable perspectiveDockable) {
        if (entry == null) {
            return null;
        }
        if (entry.asLeaf() != null) {
            if (entry.asLeaf().getDockable() == perspectiveDockable) {
                return entry.asLeaf();
            }
            return null;
        }
        Leaf leaf = this.find(entry.asNode().getChildA(), perspectiveDockable);
        if (leaf == null) {
            leaf = this.find(entry.asNode().getChildB(), perspectiveDockable);
        }
        return leaf;
    }

    public void addPlaceholder(Entry entry, Path path) {
        if (!entry.isAnchestor(this.getRoot())) {
            throw new IllegalArgumentException("destination is not child of this perspective");
        }
        this.clearPlaceholder(path, entry);
        entry.getPlaceholders().add(path);
    }

    private void clearPlaceholder(Path path, Entry entry) {
        this.clearPlaceholder(this.getRoot().getChild(), path, entry);
    }

    private void clearPlaceholder(Entry entry, Path path, Entry entry2) {
        if (entry != null && entry != entry2) {
            if (entry.getPlaceholderMap() != null) {
                entry.getPlaceholderMap().removeAll(path, true);
            }
            entry.getPlaceholders().remove(path);
        }
        if (entry.asNode() != null) {
            this.clearPlaceholder(entry.asNode().getChildA(), path, entry2);
            this.clearPlaceholder(entry.asNode().getChildB(), path, entry2);
        }
    }

    public static abstract class Entry {
        private Entry parent;
        private long id;
        private Set<Path> placeholders;
        private PlaceholderMap placeholderMap;

        public Entry(Set<Path> set, PlaceholderMap placeholderMap, long l) {
            this.placeholders = set;
            this.placeholderMap = placeholderMap;
            this.id = l;
        }

        public boolean isAnchestor(Entry entry) {
            Entry entry2 = this;
            while (entry2 != null) {
                if (entry2 == entry) {
                    return true;
                }
                entry2 = entry2.getParent();
            }
            return false;
        }

        public SplitDockPerspective getPerspective() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getPerspective();
        }

        public void delete() {
            Entry entry = this.getParent();
            if (entry == null) {
                return;
            }
            if (entry instanceof Root) {
                ((Root)entry).setChild(null);
            } else {
                Entry entry2;
                Node node = (Node)entry;
                if (node.getChildA() == this) {
                    entry2 = node.getChildB();
                    node.setChildA(null);
                } else {
                    entry2 = node.getChildA();
                    node.setChildB(null);
                }
                entry = node.getParent();
                if (entry == null) {
                    return;
                }
                node.setChildA(null);
                node.setChildB(null);
                if (entry instanceof Root) {
                    ((Root)entry).setChild(entry2);
                } else {
                    Node node2 = (Node)entry;
                    if (node2.getChildA() == node) {
                        node2.setChildA(entry2);
                    } else {
                        node2.setChildB(entry2);
                    }
                }
            }
        }

        public void replace(Entry entry) {
            Entry entry2 = this.getParent();
            if (entry2 == null) {
                return;
            }
            if (entry2 instanceof Root) {
                ((Root)entry2).setChild(entry);
            } else {
                Node node = (Node)entry2;
                if (node.getChildA() == this) {
                    node.setChildA(entry);
                } else {
                    node.setChildB(entry);
                }
            }
        }

        protected void setParent(Entry entry) {
            this.parent = entry;
        }

        public Entry getParent() {
            return this.parent;
        }

        public long getNodeId() {
            return this.id;
        }

        public Leaf asLeaf() {
            return null;
        }

        public Node asNode() {
            return null;
        }

        public Set<Path> getPlaceholders() {
            return this.placeholders;
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }

        public void setPlaceholderMap(PlaceholderMap placeholderMap) {
            this.placeholderMap = placeholderMap;
        }
    }

    public static interface EntryListener {
        public void added(Entry var1, Entry var2);

        public void removed(Entry var1, Entry var2);

        public void modified(Leaf var1, PerspectiveDockable var2, PerspectiveDockable var3);
    }

    public static class Leaf
    extends Entry {
        private PerspectiveDockable dockable;

        public Leaf(PerspectiveDockable perspectiveDockable, Set<Path> set, PlaceholderMap placeholderMap, long l) {
            super(set, placeholderMap, l);
            this.dockable = perspectiveDockable;
        }

        @Override
        public Leaf asLeaf() {
            return this;
        }

        public PerspectiveDockable getDockable() {
            return this.dockable;
        }

        public void setDockable(PerspectiveDockable perspectiveDockable) {
            SplitDockPerspective splitDockPerspective = this.getPerspective();
            if (splitDockPerspective == null) {
                this.dockable = perspectiveDockable;
            } else {
                PerspectiveDockable perspectiveDockable2 = this.dockable;
                this.dockable = perspectiveDockable;
                EntryListener[] entryListenerArray = splitDockPerspective.listeners();
                int n = entryListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EntryListener entryListener = entryListenerArray[n2];
                    entryListener.modified(this, perspectiveDockable2, perspectiveDockable);
                    ++n2;
                }
            }
        }

        public void remove() {
            SplitDockPerspective splitDockPerspective = this.getPerspective();
            if (splitDockPerspective == null) {
                throw new IllegalStateException("this method can only be applied to leafs that have a root as anchestor");
            }
            if (this.dockable != null) {
                Path path = this.dockable.getPlaceholder();
                if (path != null) {
                    splitDockPerspective.addPlaceholder(this, path);
                }
                if (this.dockable.asStation() != null) {
                    PlaceholderMap placeholderMap = this.dockable.asStation().getPlaceholders();
                    this.setPlaceholderMap(placeholderMap);
                    if (placeholderMap != null) {
                        PlaceholderMap.Key[] keyArray = placeholderMap.getPlaceholders();
                        int n = keyArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PlaceholderMap.Key key = keyArray[n2];
                            Path[] pathArray = key.getPlaceholders();
                            int n3 = pathArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Path path2 = pathArray[n4];
                                splitDockPerspective.addPlaceholder(this, path2);
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
                this.setDockable(null);
            }
            if (this.getPlaceholderMap() == null && this.getPlaceholders().isEmpty()) {
                this.delete();
            }
        }
    }

    public static class Node
    extends Entry {
        private SplitDockStation.Orientation orientation;
        private double divider;
        private Entry childA;
        private Entry childB;

        public Node(SplitDockStation.Orientation orientation, double d, Entry entry, Entry entry2, Set<Path> set, PlaceholderMap placeholderMap, long l) {
            super(set, placeholderMap, l);
            this.orientation = orientation;
            this.divider = d;
            this.setChildA(entry);
            this.setChildB(entry2);
        }

        @Override
        public Node asNode() {
            return this;
        }

        public SplitDockStation.Orientation getOrientation() {
            return this.orientation;
        }

        public double getDivider() {
            return this.divider;
        }

        public Entry getChildA() {
            return this.childA;
        }

        public void setChildA(Entry entry) {
            if (entry != null && entry.asLeaf() == null && entry.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (entry != null && this.isAnchestor(entry)) {
                throw new IllegalArgumentException("cannot build a cycle");
            }
            SplitDockPerspective splitDockPerspective = this.getPerspective();
            if (this.childA != null) {
                this.childA.setParent(null);
                if (splitDockPerspective != null) {
                    splitDockPerspective.fireRemoved(this, this.childA);
                }
            }
            this.childA = entry;
            if (this.childA != null) {
                this.childA.setParent(this);
                if (splitDockPerspective != null) {
                    splitDockPerspective.fireAdded(this, this.childA);
                }
            }
        }

        public Entry getChildB() {
            return this.childB;
        }

        public void setChildB(Entry entry) {
            if (entry != null && entry.asLeaf() == null && entry.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (entry != null && this.isAnchestor(entry)) {
                throw new IllegalArgumentException("cannot build a cycle");
            }
            SplitDockPerspective splitDockPerspective = this.getPerspective();
            if (this.childB != null) {
                this.childB.setParent(null);
                if (splitDockPerspective != null) {
                    splitDockPerspective.fireRemoved(this, this.childB);
                }
            }
            this.childB = entry;
            if (this.childB != null) {
                this.childB.setParent(this);
                if (splitDockPerspective != null) {
                    splitDockPerspective.fireAdded(this, this.childB);
                }
            }
        }
    }

    public class Root
    extends Entry {
        private Entry child;

        public Root() {
            super(new HashSet<Path>(), null, -1L);
        }

        @Override
        public SplitDockPerspective getPerspective() {
            return SplitDockPerspective.this;
        }

        @Override
        protected void setParent(Entry entry) {
            throw new IllegalStateException("cannot set the parent of a root");
        }

        public Entry getChild() {
            return this.child;
        }

        public void setChild(Entry entry) {
            if (entry != null && entry.asLeaf() == null && entry.asNode() == null) {
                throw new IllegalArgumentException("child must either be a leaf or a node");
            }
            if (this.child != null) {
                this.child.setParent(null);
                SplitDockPerspective.this.fireRemoved(this, this.child);
            }
            this.child = entry;
            if (this.child != null) {
                this.child.setParent(this);
                SplitDockPerspective.this.fireAdded(this, this.child);
            }
        }
    }
}

