/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SpanSplitNode;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;

public class Root
extends SpanSplitNode {
    private SplitNode child;
    private boolean treeChanged = true;
    private Rectangle baseBounds = null;

    public Root(SplitDockAccess splitDockAccess) {
        this(splitDockAccess, -1L);
    }

    public Root(SplitDockAccess splitDockAccess, long l) {
        super(splitDockAccess, l);
    }

    @Override
    protected void treeChanged() {
        this.treeChanged = true;
    }

    public boolean hasTreeChanged() {
        return this.treeChanged;
    }

    public void setChild(SplitNode splitNode) {
        if (this.child != splitNode) {
            if (this.child != null) {
                this.child.setParent(null);
            }
            this.child = splitNode;
            if (splitNode != null) {
                splitNode.delete(false);
                splitNode.setParent(this);
            }
            this.treeChanged();
            if (splitNode != null) {
                this.ensureIdUniqueAsync();
            }
            this.getAccess().getOwner().revalidate();
            this.getAccess().getOwner().repaint();
            this.getAccess().repositioned(this);
        }
    }

    public SplitNode getChild() {
        return this.child;
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        if (splitNode == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Location invalid: " + n);
        }
        this.setChild(splitNode);
    }

    @Override
    public int getMaxChildrenCount() {
        return 1;
    }

    @Override
    public SplitNode getChild(int n) {
        if (n == 0) {
            return this.getChild();
        }
        return null;
    }

    @Override
    public Root getRoot() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension dimension2 = dimension = this.child == null ? null : this.child.getMinimumSize();
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = dimension = this.child == null ? null : this.child.getPreferredSize();
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return dimension;
    }

    public double getWidthFactor() {
        return this.getBaseBounds().getWidth();
    }

    public double getHeightFactor() {
        return this.getBaseBounds().getHeight();
    }

    public void setBaseBounds(Rectangle rectangle) {
        this.baseBounds = rectangle;
    }

    public Rectangle getBaseBounds() {
        if (this.baseBounds != null) {
            return this.baseBounds;
        }
        JComponent jComponent = this.getAccess().getOwner().getBasePane();
        Insets insets = jComponent.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public PutInfo getPut(int n, int n2, Dockable dockable) {
        double d = this.getWidthFactor();
        double d2 = this.getHeightFactor();
        return this.getPut(n, n2, d, d2, dockable);
    }

    public boolean isInOverrideZone(int n, int n2) {
        double d = this.getWidthFactor();
        double d2 = this.getHeightFactor();
        return this.isInOverrideZone(n, n2, d, d2);
    }

    @Override
    public boolean aside(AsideRequest asideRequest) {
        if (this.child == null) {
            if (asideRequest.getPlaceholder() != null) {
                Placeholder placeholder = this.createPlaceholder(-1L);
                this.setChild(placeholder);
                return placeholder.aside(asideRequest);
            }
        } else {
            return this.child.aside(asideRequest);
        }
        return true;
    }

    @Override
    public boolean aside(SplitDockPathProperty splitDockPathProperty, int n, AsideRequest asideRequest) {
        if (this.child == null) {
            if (asideRequest.getPlaceholder() != null) {
                long l = splitDockPathProperty.getLeafId();
                Placeholder placeholder = this.createPlaceholder(l);
                this.setChild(placeholder);
                placeholder.addPlaceholder(asideRequest.getPlaceholder());
            }
            return true;
        }
        return this.child.aside(splitDockPathProperty, n, asideRequest);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        this.setChild(this.create(key, bl, map));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty splitDockPlaceholderProperty, Dockable dockable) {
        boolean bl;
        boolean bl2 = bl = this.child != null && this.child.insert(splitDockPlaceholderProperty, dockable);
        if (!bl) {
            return this.getAccess().drop(dockable, splitDockPlaceholderProperty.toSplitLocation(this), this);
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (this.child == null) {
            long l = splitDockPathProperty.getLeafId();
            Leaf leaf = this.create(dockable, l);
            if (leaf == null) {
                return false;
            }
            this.setChild(leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        return this.child.insert(splitDockPathProperty, n, dockable);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        if (this.child == null) {
            return splitTreeFactory.root(null, this.getId());
        }
        return splitTreeFactory.root(this.child.submit(splitTreeFactory), this.getId());
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        if (this.child != null) {
            Rectangle rectangle = new Rectangle((int)(d * d5), (int)(d2 * d6), (int)(d3 * d5), (int)(d4 * d6));
            Rectangle rectangle2 = this.getAccess().getSpanStrategy().modifyBounds(rectangle, this);
            if (!rectangle.equals(rectangle2) && d5 > 0.0 && d6 > 0.0) {
                d = (double)rectangle2.x / d5;
                d2 = (double)rectangle2.y / d6;
                d3 = (double)rectangle2.width / d5;
                d4 = (double)rectangle2.height / d6;
            }
            this.child.updateBounds(d, d2, d3, d4, d5, d6, bl);
        }
        this.treeChanged = false;
    }

    @Override
    public void setBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.setBounds(d, d2, d3, d4, d5, d6, bl);
        this.treeChanged = false;
    }

    @Override
    public void onSpanResize() {
        this.getStation().updateBounds();
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        if (!this.getBounds().contains(n, n2)) {
            return null;
        }
        if (this.child != null) {
            return this.child.getPut(n, n2, d, d2, dockable);
        }
        return null;
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        if (!this.getBounds().contains(n, n2)) {
            return false;
        }
        if (this.child != null) {
            return this.child.isInOverrideZone(n, n2, d, d2);
        }
        return false;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return this.child == null ? null : this.child.getLeaf(dockable);
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        if (this.child == null) {
            return null;
        }
        return this.child.getDividerNode(n, n2);
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleRoot(this);
        if (this.child != null) {
            this.child.visit(splitNodeVisitor);
        }
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        stringBuilder.append("Root [id=");
        stringBuilder.append(this.getId());
        stringBuilder.append("]\n");
        int n2 = 0;
        while (n2 < n + 1) {
            stringBuilder.append('\t');
            ++n2;
        }
        if (this.child != null) {
            this.child.toString(n + 1, stringBuilder);
        } else {
            stringBuilder.append("<null>");
        }
    }
}

