/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;

public class PutInfo {
    private SplitNode node;
    private Put put;
    private Dockable dockable;
    private double divider;
    private int oldSize;
    private Leaf leaf;
    private CombinerSource combinerSource;
    private CombinerTarget combinerTarget;
    private boolean combining;

    public PutInfo(SplitNode splitNode, Put put, Dockable dockable, boolean bl) {
        this.node = splitNode;
        this.put = put;
        this.dockable = dockable;
        this.combining = bl;
    }

    public boolean willHaveNoEffect() {
        SplitNode splitNode;
        if (this.node instanceof Leaf && (splitNode = this.node.getParent()) instanceof Node) {
            if (((Node)splitNode).getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                if (this.put == Put.TOP || this.put == Put.BOTTOM) {
                    splitNode = null;
                }
            } else if (this.put == Put.LEFT || this.put == Put.RIGHT) {
                splitNode = null;
            }
            if (splitNode != null) {
                SplitNode splitNode2 = null;
                if (this.put == Put.LEFT || this.put == Put.TOP) {
                    splitNode2 = ((Node)splitNode).getLeft();
                } else if (this.put == Put.RIGHT || this.put == Put.BOTTOM) {
                    splitNode2 = ((Node)splitNode).getRight();
                }
                if (splitNode2 instanceof Leaf && ((Leaf)splitNode2).getDockable() == this.dockable) {
                    return true;
                }
            }
        }
        return false;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void setNode(SplitNode splitNode) {
        this.node = splitNode;
    }

    public SplitNode getNode() {
        return this.node;
    }

    public void setPut(Put put) {
        this.put = put;
    }

    public Put getPut() {
        return this.put;
    }

    public boolean isCombining() {
        return this.combining;
    }

    public void setDivider(double d) {
        this.divider = d;
    }

    public double getDivider() {
        return this.divider;
    }

    public void setOldSize(int n) {
        this.oldSize = n;
    }

    public int getOldSize() {
        return this.oldSize;
    }

    public void setLeaf(Leaf leaf) {
        this.leaf = leaf;
    }

    public Leaf getLeaf() {
        return this.leaf;
    }

    public void setCombination(CombinerSource combinerSource, CombinerTarget combinerTarget) {
        this.combinerSource = combinerSource;
        this.combinerTarget = combinerTarget;
    }

    public CombinerSource getCombinerSource() {
        return this.combinerSource;
    }

    public CombinerTarget getCombinerTarget() {
        return this.combinerTarget;
    }

    public static enum Put {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM,
        CENTER,
        TITLE;

    }
}

