/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.util.Path;
import java.awt.Dimension;
import java.util.Map;

public class Placeholder
extends SplitNode {
    public Placeholder(SplitDockAccess splitDockAccess, long l) {
        super(splitDockAccess, l);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        return -1;
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        return null;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        return null;
    }

    @Override
    public boolean aside(AsideRequest asideRequest) {
        if (asideRequest.getPlaceholder() != null) {
            this.addPlaceholder(asideRequest.getPlaceholder());
            AsideAnswer asideAnswer = asideRequest.forward(this.getStation().getCombiner(), this.getPlaceholderMap());
            if (asideAnswer.isCanceled()) {
                return false;
            }
            this.setPlaceholderMap(asideAnswer.getLayout());
        }
        return true;
    }

    @Override
    public boolean aside(SplitDockPathProperty splitDockPathProperty, int n, AsideRequest asideRequest) {
        if (asideRequest.getPlaceholder() != null) {
            if (n < splitDockPathProperty.size()) {
                Placeholder placeholder = this.createPlaceholder(splitDockPathProperty.getLeafId());
                this.split(splitDockPathProperty, n, placeholder);
                placeholder.aside(asideRequest);
            } else {
                this.aside(asideRequest);
            }
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty splitDockPlaceholderProperty, Dockable dockable) {
        Path path = splitDockPlaceholderProperty.getPlaceholder();
        if (this.hasPlaceholder(path)) {
            return this.replace(path, dockable);
        }
        return false;
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (splitDockPathProperty.getLeafId() == this.getId()) {
            return this.replace(null, dockable);
        }
        if (n < splitDockPathProperty.size()) {
            Leaf leaf = this.create(dockable, splitDockPathProperty.getLeafId());
            if (leaf == null) {
                return false;
            }
            this.split(splitDockPathProperty, n, leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        return false;
    }

    private boolean replace(Path path, Dockable dockable) {
        Leaf leaf = this.create(dockable, this.getId());
        if (leaf == null) {
            return false;
        }
        this.ensureOnlyOnThisNode(path);
        this.ensureOnlyOnThisNode(this.getAccess().getOwner().getPlaceholderStrategy().getPlaceholderFor(dockable));
        leaf.setPlaceholders(this.getPlaceholders());
        this.replace(leaf);
        leaf.setPlaceholderMap(this.getPlaceholderMap());
        leaf.setDockable(dockable, null);
        return true;
    }

    private void ensureOnlyOnThisNode(Path path) {
        if (path != null) {
            this.getAccess().getPlaceholderSet().set((SplitNode)this, path, this);
        }
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        return false;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public SplitNode getChild(int n) {
        return null;
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        return splitTreeFactory.placeholder(this.getId(), this.getPlaceholders(), this.getPlaceholderMap());
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public SplitNode getVisible() {
        return null;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.hasPlaceholders();
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handlePlaceholder(this);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        stringBuilder.append("Placeholder: ");
        boolean bl = true;
        Path[] pathArray = this.getPlaceholders();
        int n2 = pathArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Path path = pathArray[n3];
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(path);
            ++n3;
        }
    }
}

