/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SpanSplitNode;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;

public class Leaf
extends SpanSplitNode {
    private StationChildHandle handle;

    public Leaf(SplitDockAccess splitDockAccess) {
        this(splitDockAccess, -1L);
    }

    public Leaf(SplitDockAccess splitDockAccess, long l) {
        super(splitDockAccess, l);
    }

    public void setHandle(StationChildHandle stationChildHandle) {
        this.handle = stationChildHandle;
    }

    @Override
    public Dimension getMinimumSize() {
        SplitDockStation splitDockStation = this.getStation();
        DockableDisplayer dockableDisplayer = null;
        if (this.handle != null) {
            dockableDisplayer = this.handle.getDisplayer();
        }
        if (dockableDisplayer == null) {
            Dimension dimension = splitDockStation == null ? new Dimension(0, 0) : splitDockStation.getMinimumLeafSize();
            return dimension;
        }
        return dockableDisplayer.getComponent().getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.handle == null) {
            return new Dimension(0, 0);
        }
        DockableDisplayer dockableDisplayer = this.handle.getDisplayer();
        if (dockableDisplayer == null) {
            return new Dimension(0, 0);
        }
        return dockableDisplayer.getComponent().getPreferredSize();
    }

    @Override
    public int getChildLocation(SplitNode splitNode) {
        return -1;
    }

    @Override
    public void setChild(SplitNode splitNode, int n) {
        throw new IllegalStateException("can't add children to a leaf");
    }

    @Override
    public int getMaxChildrenCount() {
        return 0;
    }

    @Override
    public SplitNode getChild(int n) {
        return null;
    }

    public void setDockable(Dockable dockable, DockHierarchyLock.Token token) {
        this.setDockable(dockable, token, true, false);
    }

    public void setDockable(Dockable dockable, DockHierarchyLock.Token token, boolean bl, boolean bl2) {
        if (this.handle != null) {
            if (bl) {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, this.handle.getDockable(), new SplitNode[0]);
            }
            if (bl2) {
                DockStation dockStation = this.handle.getDockable().asDockStation();
                if (dockStation == null) {
                    throw new IllegalStateException("no station as child but storePlaceholderMap is set");
                }
                this.setPlaceholderMap(dockStation.getPlaceholders());
            }
            this.getAccess().removeHandle(this.handle, token);
            this.handle = null;
        }
        if (dockable != null) {
            this.handle = this.getAccess().newHandle(dockable);
            if (bl) {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, dockable, new SplitNode[0]);
            }
            this.getAccess().addHandle(this.handle, token);
        }
        this.treeChanged();
    }

    public Dockable getDockable() {
        return this.handle == null ? null : this.handle.getDockable();
    }

    public DockableDisplayer getDisplayer() {
        return this.handle == null ? null : this.handle.getDisplayer();
    }

    public StationChildHandle getDockableHandle() {
        return this.handle;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        if (!this.getAccess().isTreeAutoCleanupEnabled()) {
            return true;
        }
        return this.handle != null || this.hasPlaceholders();
    }

    public void placehold(boolean bl) {
        Object object;
        Dockable dockable = this.getDockable();
        if (dockable != null) {
            DockStation dockStation;
            object = this.getAccess();
            RootPlaceholderStrategy rootPlaceholderStrategy = object.getOwner().getPlaceholderStrategy();
            if (rootPlaceholderStrategy != null) {
                this.updatePlaceholders(dockable, bl, rootPlaceholderStrategy);
            }
            if ((dockStation = dockable.asDockStation()) != null && bl) {
                this.setPlaceholderMap(dockStation.getPlaceholders());
            }
        }
        if (this.hasPlaceholders()) {
            object = this.createPlaceholder(this.getId());
            ((SplitNode)object).setPlaceholders(this.getPlaceholders());
            this.movePlaceholderMap((SplitNode)object);
            this.replace((SplitNode)object);
        } else {
            this.delete(true);
        }
    }

    private void updatePlaceholders(Dockable dockable, boolean bl, PlaceholderStrategy placeholderStrategy) {
        DockStation dockStation;
        Path path = placeholderStrategy.getPlaceholderFor(dockable);
        if (path != null) {
            if (!bl) {
                this.getAccess().getPlaceholderSet().set(null, path, new SplitNode[0]);
            } else {
                this.getAccess().getPlaceholderSet().set((SplitNode)this, path, new SplitNode[0]);
            }
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = 0;
            int n2 = dockStation.getDockableCount();
            while (n < n2) {
                this.updatePlaceholders(dockStation.getDockable(n), bl, placeholderStrategy);
                ++n;
            }
        }
    }

    @Override
    public void updateBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.updateBounds(d, d2, d3, d4, d5, d6, bl);
        if (bl) {
            this.resetDisplayerBounds();
        }
    }

    @Override
    public void setBounds(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        super.setBounds(d, d2, d3, d4, d5, d6, bl);
        if (bl) {
            this.resetDisplayerBounds();
        }
    }

    @Override
    public void onSpanResize() {
        this.resetDisplayerBounds();
    }

    public void resetDisplayerBounds() {
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        StationChildHandle stationChildHandle = this.getAccess().getFullScreenDockable();
        if (dockableDisplayer != null && (stationChildHandle == null || dockableDisplayer != stationChildHandle.getDisplayer())) {
            Rectangle rectangle = this.getBounds();
            rectangle = this.getAccess().getSpanStrategy().modifyBounds(rectangle, this);
            Component component = dockableDisplayer.getComponent();
            component.setBounds(rectangle);
            if (component instanceof JComponent) {
                ((JComponent)component).revalidate();
            }
        }
    }

    @Override
    public PutInfo getPut(int n, int n2, double d, double d2, Dockable dockable) {
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        if (dockableDisplayer == null) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        PutInfo putInfo = null;
        boolean bl = false;
        if (this.isTitlePut(rectangle = this.removeTitle(rectangle), n, n2)) {
            bl = true;
            putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TITLE, dockable, true));
        }
        if (putInfo != null) {
            return putInfo;
        }
        if (this.isCenterPut(rectangle, n, n2)) {
            bl = true;
            putInfo = this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable, true));
        }
        if (putInfo != null) {
            return putInfo;
        }
        putInfo = this.createSidePut(rectangle, n, n2, dockable, bl);
        if (putInfo != null) {
            return putInfo;
        }
        return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.CENTER, dockable, bl));
    }

    protected Rectangle removeTitle(Rectangle rectangle) {
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        rectangle = new Rectangle(rectangle);
        if (dockableDisplayer.getTitle() != null) {
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.TOP) {
                int n = dockableDisplayer.getTitle().getComponent().getHeight();
                rectangle.y += n;
                rectangle.height -= n;
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.BOTTOM) {
                int n = dockableDisplayer.getTitle().getComponent().getHeight();
                rectangle.height -= n;
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.LEFT) {
                int n = dockableDisplayer.getTitle().getComponent().getWidth();
                rectangle.x += n;
                rectangle.width -= n;
            } else if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.RIGHT) {
                int n = dockableDisplayer.getTitle().getComponent().getWidth();
                rectangle.width -= n;
            }
        }
        return rectangle;
    }

    protected boolean isCenterPut(Rectangle rectangle, int n, int n2) {
        float f = this.getAccess().getOwner().getSideSnapSize();
        return (float)n > (float)rectangle.x + f * (float)rectangle.width && (float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width && (float)n2 > (float)rectangle.y + f * (float)rectangle.height && (float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height;
    }

    protected boolean isTitlePut(Rectangle rectangle, int n, int n2) {
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        if (dockableDisplayer.getTitle() != null) {
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.TOP) {
                return n2 <= rectangle.y;
            }
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.BOTTOM) {
                return n2 >= rectangle.y + rectangle.height;
            }
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.LEFT) {
                return n <= rectangle.x;
            }
            if (dockableDisplayer.getTitleLocation() == DockableDisplayer.Location.RIGHT) {
                return n >= rectangle.x + rectangle.width;
            }
        }
        return false;
    }

    protected PutInfo createSidePut(Rectangle rectangle, int n, int n2, Dockable dockable, boolean bl) {
        if (Leaf.above(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, n, n2)) {
            if (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2)) {
                return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.TOP, dockable, bl));
            }
            return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.RIGHT, dockable, bl));
        }
        if (Leaf.above(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y, n, n2)) {
            return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.LEFT, dockable, bl));
        }
        return this.getAccess().validatePutInfo(new PutInfo(this, PutInfo.Put.BOTTOM, dockable, bl));
    }

    @Override
    public boolean isInOverrideZone(int n, int n2, double d, double d2) {
        float f = this.getAccess().getOwner().getSideSnapSize();
        Rectangle rectangle = this.getBounds();
        return !((float)n > (float)rectangle.x + f * (float)rectangle.width) || !((float)n < (float)(rectangle.x + rectangle.width) - f * (float)rectangle.width) || !((float)n2 > (float)rectangle.y + f * (float)rectangle.height) || !((float)n2 < (float)(rectangle.y + rectangle.height) - f * (float)rectangle.height);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean bl, Map<Leaf, Dockable> map) {
        this.setPlaceholders(key.getTree().getPlaceholders(key));
        this.setPlaceholderMap(key.getTree().getPlaceholderMap(key));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty splitDockPlaceholderProperty, Dockable dockable) {
        Path path = splitDockPlaceholderProperty.getPlaceholder();
        if (this.hasPlaceholder(path)) {
            Object object;
            DockStation dockStation = this.getDockable().asDockStation();
            DockableProperty dockableProperty = splitDockPlaceholderProperty.getSuccessor();
            if (dockStation != null && dockableProperty != null && dockable.accept(dockStation) && dockStation.accept(dockable)) {
                boolean bl;
                MultiDockAcceptance multiDockAcceptance;
                object = this.getAccess().getOwner().getController();
                MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = object == null ? null : ((DockController)object).getAcceptance();
                if ((multiDockAcceptance == null || multiDockAcceptance.accept(dockStation, dockable)) && (bl = dockStation.drop(dockable, dockableProperty))) {
                    this.getAccess().getPlaceholderSet().set(null, path, this);
                    return true;
                }
            }
            object = new SplitDockProperty(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            ((AbstractDockableProperty)object).setSuccessor(splitDockPlaceholderProperty.getSuccessor());
            boolean bl = this.getAccess().drop(dockable, (SplitDockProperty)object, this);
            if (bl) {
                this.removePlaceholder(path);
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean aside(AsideRequest asideRequest) {
        if (asideRequest.getPlaceholder() != null) {
            this.addPlaceholder(asideRequest.getPlaceholder());
            DockStation dockStation = this.getDockable().asDockStation();
            if (dockStation == null) {
                AsideAnswer asideAnswer = asideRequest.forward(this.getStation().getCombiner(), this.getPlaceholderMap());
                if (asideAnswer.isCanceled()) {
                    return false;
                }
                this.setPlaceholderMap(asideAnswer.getLayout());
            } else {
                AsideAnswer asideAnswer = asideRequest.forward(dockStation);
                if (asideAnswer.isCanceled()) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean aside(SplitDockPathProperty splitDockPathProperty, int n, AsideRequest asideRequest) {
        if (asideRequest.getPlaceholder() != null) {
            if (n < splitDockPathProperty.size()) {
                DockStation dockStation = this.getDockable().asDockStation();
                if (dockStation == null) {
                    Placeholder placeholder = this.createPlaceholder(splitDockPathProperty.getLeafId());
                    this.split(splitDockPathProperty, n, placeholder);
                    return placeholder.aside(asideRequest);
                }
            } else {
                return this.aside(asideRequest);
            }
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPathProperty splitDockPathProperty, int n, Dockable dockable) {
        if (n < splitDockPathProperty.size()) {
            Leaf leaf = this.create(dockable, splitDockPathProperty.getLeafId());
            if (leaf == null) {
                return false;
            }
            this.split(splitDockPathProperty, n, leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        DockStation dockStation = this.getDockable().asDockStation();
        DockableProperty dockableProperty = splitDockPathProperty.getSuccessor();
        if (dockStation != null && dockableProperty != null && dockable.accept(dockStation) && dockStation.accept(dockable)) {
            boolean bl;
            MultiDockAcceptance multiDockAcceptance;
            DockController dockController = this.getAccess().getOwner().getController();
            MultiDockAcceptance multiDockAcceptance2 = multiDockAcceptance = dockController == null ? null : dockController.getAcceptance();
            if ((multiDockAcceptance == null || multiDockAcceptance.accept(dockStation, dockable)) && (bl = dockStation.drop(dockable, dockableProperty))) {
                return true;
            }
        }
        return this.getAccess().drop(dockable, splitDockPathProperty.toLocation(this), this);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> splitTreeFactory) {
        DockStation dockStation;
        Dockable dockable;
        PlaceholderMap placeholderMap = this.getPlaceholderMap();
        if (placeholderMap == null && (dockable = this.getDockable()) != null && (dockStation = dockable.asDockStation()) != null) {
            placeholderMap = dockStation.getPlaceholders();
        }
        return splitTreeFactory.leaf(this.getDockable(), this.getId(), this.getPlaceholders(), placeholderMap);
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        Dockable dockable2 = this.getDockable();
        if (dockable2 != null && dockable == this.getDockable()) {
            return this;
        }
        return null;
    }

    @Override
    public Node getDividerNode(int n, int n2) {
        return null;
    }

    @Override
    public void visit(SplitNodeVisitor splitNodeVisitor) {
        splitNodeVisitor.handleLeaf(this);
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        Dockable dockable = this.getDockable();
        stringBuilder.append("Leaf[ ");
        if (dockable != null) {
            stringBuilder.append(dockable.getTitleText());
            stringBuilder.append(", ");
        }
        stringBuilder.append("placeholders={");
        Path[] pathArray = this.getPlaceholders();
        if (pathArray != null) {
            int n2 = 0;
            while (n2 < pathArray.length) {
                if (n2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(pathArray[n2].toString());
                ++n2;
            }
        }
        stringBuilder.append("}, ");
        stringBuilder.append("id=");
        stringBuilder.append(this.getId());
        stringBuilder.append(", bounds=");
        stringBuilder.append(this.getBounds());
        stringBuilder.append(" ]");
    }
}

