/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class DefaultSplitLayoutManager
implements SplitLayoutManager {
    @Override
    public void install(SplitDockStation splitDockStation) {
    }

    @Override
    public void uninstall(SplitDockStation splitDockStation) {
    }

    @Override
    public Dockable willMakeFullscreen(SplitDockStation splitDockStation, Dockable dockable) {
        return dockable;
    }

    @Override
    public PutInfo prepareDrop(SplitDockStation splitDockStation, StationDropItem stationDropItem) {
        if (splitDockStation.isFullScreen()) {
            return null;
        }
        if (splitDockStation.getDockableCount() == 0) {
            PutInfo putInfo = new PutInfo(null, PutInfo.Put.CENTER, stationDropItem.getDockable(), true);
            putInfo = this.validatePutInfo(splitDockStation, putInfo);
            return putInfo;
        }
        Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
        SwingUtilities.convertPointFromScreen(point, splitDockStation);
        PutInfo putInfo = splitDockStation.getRoot().getPut(point.x, point.y, stationDropItem.getDockable());
        if (putInfo == null && splitDockStation.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(splitDockStation, point.x, point.y, null, stationDropItem.getDockable());
            putInfo = this.validatePutInfo(splitDockStation, putInfo);
        }
        if (putInfo != null) {
            putInfo.setDockable(stationDropItem.getDockable());
            this.calculateDivider(splitDockStation, putInfo, null, stationDropItem);
        }
        return putInfo;
    }

    @Override
    public PutInfo prepareMove(SplitDockStation splitDockStation, StationDropItem stationDropItem) {
        if (splitDockStation.isFullScreen()) {
            return null;
        }
        Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
        SwingUtilities.convertPointFromScreen(point, splitDockStation);
        Root root = splitDockStation.getRoot();
        PutInfo putInfo = root.getPut(point.x, point.y, stationDropItem.getDockable());
        Leaf leaf = root.getLeaf(stationDropItem.getDockable());
        if (putInfo == null && splitDockStation.isAllowSideSnap()) {
            putInfo = this.calculateSideSnap(splitDockStation, point.x, point.y, leaf, stationDropItem.getDockable());
            if ((putInfo = this.validatePutInfo(splitDockStation, putInfo)) != null) {
                leaf = null;
            }
        }
        if (putInfo != null && putInfo.getNode() instanceof Leaf && ((Leaf)putInfo.getNode()).getDockable() == stationDropItem.getDockable()) {
            putInfo.setNode(null);
        }
        if (putInfo != null) {
            putInfo.setDockable(stationDropItem.getDockable());
            this.calculateDivider(splitDockStation, putInfo, leaf, stationDropItem);
        }
        return putInfo;
    }

    protected PutInfo calculateSideSnap(SplitDockStation splitDockStation, int n, int n2, Leaf leaf, Dockable dockable) {
        Node node;
        if (splitDockStation.getDockableCount() == 0) {
            return null;
        }
        if (splitDockStation.getDockableCount() == 1 && splitDockStation.getDockable(0) == dockable) {
            return null;
        }
        PutInfo putInfo = SplitNode.above(0.0, 0.0, splitDockStation.getWidth(), splitDockStation.getHeight(), n, n2) ? (SplitNode.above(0.0, splitDockStation.getHeight(), splitDockStation.getWidth(), 0.0, n, n2) ? new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.TOP, dockable, false) : new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.RIGHT, dockable, false)) : (SplitNode.above(0.0, splitDockStation.getHeight(), splitDockStation.getWidth(), 0.0, n, n2) ? new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.LEFT, dockable, false) : new PutInfo(splitDockStation.getRoot().getChild(), PutInfo.Put.BOTTOM, dockable, false));
        if (leaf != null && splitDockStation.getRoot().getChild() instanceof Node && (node = (Node)splitDockStation.getRoot().getChild()).getLeft().isVisible() && node.getRight().isVisible()) {
            if (putInfo.getPut() == PutInfo.Put.TOP && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getLeft() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.BOTTOM && node.getOrientation() == SplitDockStation.Orientation.VERTICAL && node.getRight() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.LEFT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getLeft() == leaf) {
                return null;
            }
            if (putInfo.getPut() == PutInfo.Put.RIGHT && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL && node.getRight() == leaf) {
                return null;
            }
        }
        return putInfo;
    }

    @Override
    public void calculateDivider(SplitDockStation splitDockStation, PutInfo putInfo, Leaf leaf, StationDropItem stationDropItem) {
        Dimension dimension;
        SplitNode splitNode = putInfo.getNode();
        if (splitNode == null) {
            return;
        }
        Dimension dimension2 = dimension = leaf == null ? stationDropItem.getOriginalSize() : leaf.getSize();
        if (splitNode.getParent() instanceof Root) {
            splitNode = splitNode.getParent();
        }
        Dimension dimension3 = splitNode.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (leaf != null) {
            if (leaf.getParent() instanceof Node) {
                Node node = (Node)leaf.getParent();
                if ((putInfo.getPut() == PutInfo.Put.LEFT || putInfo.getPut() == PutInfo.Put.RIGHT) && node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    n = dimension.width;
                } else if ((putInfo.getPut() == PutInfo.Put.TOP || putInfo.getPut() == PutInfo.Put.BOTTOM) && node.getOrientation() == SplitDockStation.Orientation.VERTICAL) {
                    n = dimension.height;
                }
            }
        } else if (putInfo.getOldSize() != 0) {
            n = putInfo.getOldSize();
        }
        double d = 0.5;
        int n2 = splitDockStation.getDividerSize();
        if (putInfo.getPut() == PutInfo.Put.TOP) {
            if (n != 0) {
                d = ((double)n + (double)n2 / 2.0) / (double)dimension3.height;
            }
            if ((d = this.validateDivider(splitDockStation, d, stationDropItem.getMinimumSize(), splitNode.getMinimumSize(), SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight())) > 0.75) {
                d = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
            if (n != 0) {
                d = 1.0 - ((double)n + (double)n2 / 2.0) / (double)dimension3.height;
            }
            if ((d = this.validateDivider(splitDockStation, d, splitNode.getMinimumSize(), stationDropItem.getMinimumSize(), SplitDockStation.Orientation.VERTICAL, splitNode.getWidth(), splitNode.getHeight())) < 0.25) {
                d = 0.25;
            }
        } else if (putInfo.getPut() == PutInfo.Put.LEFT) {
            if (n != 0) {
                d = ((double)n + (double)n2 / 2.0) / (double)dimension3.width;
            }
            if ((d = this.validateDivider(splitDockStation, d, stationDropItem.getMinimumSize(), splitNode.getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight())) > 0.75) {
                d = 0.75;
            }
        } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
            if (n != 0) {
                d = 1.0 - ((double)n + (double)n2 / 2.0) / (double)dimension3.width;
            }
            if ((d = this.validateDivider(splitDockStation, d, splitNode.getMinimumSize(), stationDropItem.getMinimumSize(), SplitDockStation.Orientation.HORIZONTAL, splitNode.getWidth(), splitNode.getHeight())) < 0.25) {
                d = 0.25;
            }
        }
        putInfo.setDivider(d);
        putInfo.setOldSize(n);
    }

    @Override
    public double validateDivider(SplitDockStation splitDockStation, double d, Node node) {
        d = Math.min(1.0, Math.max(0.0, d));
        SplitNode splitNode = node.getLeft();
        SplitNode splitNode2 = node.getRight();
        Dimension dimension = null;
        Dimension dimension2 = null;
        if (splitNode != null) {
            dimension = splitNode.getMinimumSize();
        }
        if (splitNode2 != null) {
            dimension2 = splitNode2.getMinimumSize();
        }
        if (dimension == null) {
            dimension = new Dimension();
        }
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        return this.validateDivider(splitDockStation, d, dimension, dimension2, node.getOrientation(), node.getWidth(), node.getHeight());
    }

    protected double validateDivider(SplitDockStation splitDockStation, double d, Dimension dimension, Dimension dimension2, SplitDockStation.Orientation orientation, double d2, double d3) {
        int n;
        int n2;
        double d4;
        double d5;
        if (orientation == SplitDockStation.Orientation.HORIZONTAL) {
            d5 = splitDockStation.getRoot().getWidthFactor();
            d4 = d2;
            n2 = dimension.width;
            n = dimension2.width;
        } else {
            d5 = splitDockStation.getRoot().getHeightFactor();
            d4 = d3;
            n2 = dimension.height;
            n = dimension2.height;
        }
        if (d5 <= 0.0 || Double.isNaN(d5)) {
            return d;
        }
        double d6 = (double)n2 / d5;
        double d7 = (double)n / d5;
        double d8 = (double)splitDockStation.getDividerSize() / d5;
        if (d6 + d7 + d8 >= d4) {
            d = (d6 + d8 / 2.0) / (d6 + d7 + d8);
        } else if (d * d4 < d6 + d8 / 2.0) {
            d = (d6 + d8 / 2.0) / d4;
        } else if (d * d4 > d4 - d7 - d8 / 2.0) {
            d = (d4 - d7 - d8 / 2.0) / d4;
        }
        return d;
    }

    @Override
    public PutInfo validatePutInfo(SplitDockStation splitDockStation, PutInfo putInfo) {
        if (putInfo != null) {
            if (!splitDockStation.accept(putInfo.getDockable())) {
                return null;
            }
            if (putInfo.getNode() != null && (putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) ? !putInfo.getDockable().accept(splitDockStation, ((Leaf)putInfo.getNode()).getDockable()) || !((Leaf)putInfo.getNode()).getDockable().accept(splitDockStation, putInfo.getDockable()) || !splitDockStation.getController().getAcceptance().accept(splitDockStation, ((Leaf)putInfo.getNode()).getDockable(), putInfo.getDockable()) : !putInfo.getDockable().accept(splitDockStation) || !splitDockStation.getController().getAcceptance().accept(splitDockStation, putInfo.getDockable())) {
                return null;
            }
        }
        return putInfo;
    }

    @Override
    public void updateBounds(Root root, double d, double d2, double d3, double d4) {
        root.updateBounds(d, d2, 1.0, 1.0, d3, d4, true);
    }
}

