/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.security.GlassedPane;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.SplitDividerStrategy;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DefaultSplitDividerStrategy
implements SplitDividerStrategy {
    private Map<SplitDockStation, Handler> handlers = new HashMap<SplitDockStation, Handler>();

    @Override
    public void install(SplitDockStation splitDockStation, Component component) {
        Handler handler = this.createHandlerFor(splitDockStation);
        handler.install(component);
        this.handlers.put(splitDockStation, handler);
    }

    @Override
    public void uninstall(SplitDockStation splitDockStation) {
        Handler handler = this.handlers.remove(splitDockStation);
        if (handler != null) {
            handler.destroy();
        }
    }

    @Override
    public void paint(SplitDockStation splitDockStation, Graphics graphics) {
        Handler handler = this.handlers.get(splitDockStation);
        if (handler != null) {
            handler.paint(graphics);
        }
    }

    protected Handler createHandlerFor(SplitDockStation splitDockStation) {
        return new Handler(splitDockStation);
    }

    public static class Handler
    extends MouseAdapter
    implements MouseListener,
    MouseMotionListener,
    AWTEventListener,
    DockHierarchyListener {
        private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

            @Override
            protected void valueChanged(Boolean bl, Boolean bl2) {
                Handler.this.updateEventListener();
            }
        };
        private DockController controller;
        private Divideable current;
        private double divider;
        private boolean pressed = false;
        private boolean withinBounds = false;
        private boolean awtListenerEnabled = false;
        private Rectangle bounds = new Rectangle();
        private int deltaX;
        private int deltaY;
        private SplitDockStation station;
        private Component container;

        public Handler(SplitDockStation splitDockStation) {
            this.station = splitDockStation;
        }

        public SplitDockStation getStation() {
            return this.station;
        }

        public void install(Component component) {
            if (this.container != null) {
                throw new IllegalStateException("already initialized");
            }
            this.container = component;
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.station.addDockHierarchyListener(this);
            this.setController(this.station.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            this.setController(this.station.getController());
        }

        private void setController(DockController dockController) {
            if (this.controller != dockController) {
                this.controller = dockController;
                this.restricted.setProperties(dockController);
                this.updateEventListener();
            }
        }

        private void updateEventListener() {
            boolean bl;
            boolean bl2 = bl = this.controller != null && !this.controller.isRestrictedEnvironment();
            if (bl != this.awtListenerEnabled) {
                this.awtListenerEnabled = bl;
                if (bl) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
                } else {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if ((aWTEvent.getID() == 503 || aWTEvent.getID() == 502) && (mouseEvent = (MouseEvent)aWTEvent).getSource() != this.container && this.withinBounds) {
                if (mouseEvent.getSource() instanceof GlassedPane.GlassPane) {
                    this.checkMousePositionAsync();
                } else {
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.station);
                    if (this.station.getBounds().contains(point)) {
                        this.setCursor(null);
                        this.withinBounds = false;
                    }
                }
            }
        }

        public Component getContainer() {
            return this.container;
        }

        public void destroy() {
            if (this.container != null) {
                this.setCursor(null);
                this.current = null;
                this.container.removeMouseListener(this);
                this.container.removeMouseMotionListener(this);
                this.container = null;
                try {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.setController(null);
                this.station.removeDockHierarchyListener(this);
            }
        }

        protected void setCursor(Cursor cursor) {
            this.container.setCursor(cursor);
        }

        protected void repaint(int n, int n2, int n3, int n4) {
            this.container.repaint(n, n2, n3, n4);
        }

        protected Divideable getDividerNode(int n, int n2) {
            return this.station.getRoot().getDividerNode(n, n2);
        }

        protected void checkMousePositionAsync() {
            DockController dockController = this.station.getController();
            if (dockController != null && !this.awtListenerEnabled) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Handler.this.container != null) {
                            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                            Point point = pointerInfo.getLocation();
                            SwingUtilities.convertPointFromScreen(point, Handler.this.container);
                            Handler.this.current = Handler.this.getDividerNode(point.x, point.y);
                            if (Handler.this.current == null) {
                                Handler.this.mouseExited(null);
                            } else if (((Handler)Handler.this).bounds.width > 2 && ((Handler)Handler.this).bounds.height > 2 && (point.x <= ((Handler)Handler.this).bounds.x || point.x >= ((Handler)Handler.this).bounds.x + ((Handler)Handler.this).bounds.width - 1 || point.y <= ((Handler)Handler.this).bounds.y || point.y >= ((Handler)Handler.this).bounds.y + ((Handler)Handler.this).bounds.height - 1)) {
                                Handler.this.mouseExited(null);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && !this.pressed) {
                this.pressed = true;
                this.mouseMoved(mouseEvent);
                if (this.current != null) {
                    this.divider = this.current.getDividerAt(mouseEvent.getX() + this.deltaX, mouseEvent.getY() + this.deltaY);
                    this.divider = this.current.validateDivider(this.divider);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && this.pressed && this.current != null) {
                this.divider = this.current.getDividerAt(mouseEvent.getX() + this.deltaX, mouseEvent.getY() + this.deltaY);
                this.divider = this.current.validateDivider(this.divider);
                this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                if (this.station.isContinousDisplay() && this.current != null) {
                    this.setDivider(this.current, this.divider);
                    this.station.updateBounds();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pressed) {
                this.pressed = false;
                if (this.current != null) {
                    this.setDivider(this.current, this.divider);
                    this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.station.updateBounds();
                }
                this.setCursor(null);
                this.mouseMoved(mouseEvent);
                if (this.controller != null && !this.controller.isRestrictedEnvironment() && this.awtListenerEnabled) {
                    this.eventDispatched(mouseEvent);
                } else {
                    this.checkMousePositionAsync();
                }
            }
        }

        protected void setDivider(Divideable divideable, double d) {
            divideable.setDivider(d);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled()) {
                this.current = this.getDividerNode(mouseEvent.getX(), mouseEvent.getY());
                if (this.current == null) {
                    this.setCursor(null);
                } else if (this.current.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
                if (this.current != null) {
                    this.bounds = this.current.getDividerBounds(this.current.getActualDivider(), this.bounds);
                    this.deltaX = this.bounds.width / 2 + this.bounds.x - mouseEvent.getX();
                    this.deltaY = this.bounds.height / 2 + this.bounds.y - mouseEvent.getY();
                    this.withinBounds = true;
                } else {
                    this.withinBounds = false;
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.pressed) {
                this.current = null;
                this.setCursor(null);
                this.withinBounds = false;
            }
        }

        public void paint(Graphics graphics) {
            if (this.station.isResizingEnabled() && !this.station.isDisabled() && this.current != null && this.pressed) {
                this.station.getPaint().drawDivider(graphics, this.bounds);
            }
        }
    }
}

