/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSplitPlaceholderConverter<P, N, D> {
    private P station;

    public AbstractSplitPlaceholderConverter(P p) {
        this.station = p;
    }

    public P getStation() {
        return this.station;
    }

    public PlaceholderMap getPlaceholders() {
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.SplitDockStation"), 0);
        this.handleChild(placeholderMap, this.getRoot(this.station), "");
        return placeholderMap;
    }

    public void setPlaceholders(PlaceholderMap placeholderMap) {
        Object object;
        placeholderMap = placeholderMap.filter(this.getPlaceholderStrategy(this.station));
        PlaceholderMap.Key[] keyArray = placeholderMap.getPlaceholders();
        BuildNode buildNode = new BuildNode();
        PlaceholderMap.Key[] keyArray2 = keyArray;
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = keyArray2[n2];
            this.handleEntry((PlaceholderMap.Key)object, placeholderMap, buildNode);
            ++n2;
        }
        object = this.createTree();
        buildNode.collapse(object);
        this.dropTree(this.station, (SplitDockTree<D>)object);
    }

    protected abstract N getRoot(P var1);

    protected abstract PlaceholderStrategy getPlaceholderStrategy(P var1);

    protected abstract boolean isRoot(N var1);

    protected abstract boolean isNode(N var1);

    protected abstract boolean isLeaf(N var1);

    protected abstract boolean isPlaceholder(N var1);

    protected abstract Path[] getPlaceholders(N var1);

    protected abstract PlaceholderMap getPlaceholderMap(N var1);

    protected abstract long getId(N var1);

    protected abstract N getRootChild(N var1);

    protected abstract N getLeftChild(N var1);

    protected abstract N getRightChild(N var1);

    protected abstract double getDivider(N var1);

    protected abstract SplitDockStation.Orientation getOrientation(N var1);

    protected abstract D getDockable(N var1);

    protected abstract Path getPlaceholderFor(D var1);

    protected abstract SplitDockTree<D> createTree();

    protected abstract void dropTree(P var1, SplitDockTree<D> var2);

    private Set<Path> handleChild(PlaceholderMap placeholderMap, N n, String string) {
        if (this.isRoot(n)) {
            return this.handleRoot(placeholderMap, n, string);
        }
        if (this.isNode(n)) {
            return this.handleNode(placeholderMap, n, string);
        }
        if (this.isLeaf(n)) {
            return this.handleLeaf(placeholderMap, n, string);
        }
        if (this.isPlaceholder(n)) {
            return this.handlePlaceholder(placeholderMap, n, string);
        }
        return null;
    }

    private PlaceholderMap.Key handleBase(PlaceholderMap placeholderMap, N n, String string, Set<Path> set, Set<Path> set2) {
        Object object;
        Path[] pathArray = this.getPlaceholders(n);
        PlaceholderMap placeholderMap2 = this.getPlaceholderMap(n);
        if (pathArray != null) {
            Path[] pathArray2 = pathArray;
            int n2 = pathArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = pathArray2[n3];
                set.add((Path)object);
                if (set2 == null) {
                    set2 = new HashSet<Path>();
                }
                set2.add((Path)object);
                ++n3;
            }
        }
        if (!set.isEmpty()) {
            object = placeholderMap.newKey(set.toArray(new Path[set.size()]));
            placeholderMap.putLong((PlaceholderMap.Key)object, String.valueOf(string) + ".id", this.getId(n));
            if (placeholderMap2 != null) {
                placeholderMap.putMap((PlaceholderMap.Key)object, String.valueOf(string) + ".map", placeholderMap2.copy());
            }
            if (set2 != null && !set2.isEmpty()) {
                PlaceholderMap.Key key = placeholderMap.newKey(set2.toArray(new Path[set2.size()]));
                placeholderMap.put(key, String.valueOf(string) + ".array", true);
            }
            return object;
        }
        return null;
    }

    private Set<Path> handleRoot(PlaceholderMap placeholderMap, N n, String string) {
        PlaceholderMap.Key key;
        Set<Path> set = this.handleChild(placeholderMap, this.getRootChild(n), String.valueOf(string) + "0");
        if (set != null && (key = this.handleBase(placeholderMap, n, string, set, null)) != null) {
            placeholderMap.putString(key, String.valueOf(string) + ".type", "r");
            return set;
        }
        return null;
    }

    private Set<Path> handleNode(PlaceholderMap placeholderMap, N n, String string) {
        Set<Path> set;
        Set<Path> set2 = this.handleChild(placeholderMap, this.getLeftChild(n), String.valueOf(string) + "0");
        Set<Path> set3 = this.handleChild(placeholderMap, this.getRightChild(n), String.valueOf(string) + "1");
        if (set2 == null && set3 == null) {
            return null;
        }
        if (set2 == null) {
            set = set3;
        } else if (set3 == null) {
            set = set2;
        } else {
            set = set2;
            set.addAll(set3);
        }
        PlaceholderMap.Key key = this.handleBase(placeholderMap, n, string, set, null);
        if (key != null) {
            placeholderMap.putString(key, String.valueOf(string) + ".type", "n");
            placeholderMap.putDouble(key, String.valueOf(string) + ".divider", this.getDivider(n));
            placeholderMap.putBoolean(key, String.valueOf(string) + ".orientation", this.getOrientation(n) == SplitDockStation.Orientation.HORIZONTAL);
            return set;
        }
        return null;
    }

    private Set<Path> handlePlaceholder(PlaceholderMap placeholderMap, N n, String string) {
        HashSet<Path> hashSet = new HashSet<Path>();
        PlaceholderMap.Key key = this.handleBase(placeholderMap, n, string, hashSet, null);
        if (key != null) {
            placeholderMap.putString(key, String.valueOf(string) + ".type", "p");
            return hashSet;
        }
        return null;
    }

    private Set<Path> handleLeaf(PlaceholderMap placeholderMap, N n, String string) {
        Object object;
        HashSet<Path> hashSet = new HashSet<Path>();
        HashSet<Path> hashSet2 = new HashSet<Path>();
        D d = this.getDockable(n);
        if (d != null && (object = this.getPlaceholderFor(d)) != null) {
            hashSet.add((Path)object);
            hashSet2.add((Path)object);
        }
        if ((object = this.handleBase(placeholderMap, n, string, hashSet, hashSet2)) != null) {
            placeholderMap.putString((PlaceholderMap.Key)object, String.valueOf(string) + ".type", "l");
            return hashSet;
        }
        return null;
    }

    private void handleEntry(PlaceholderMap.Key key, PlaceholderMap placeholderMap, BuildNode buildNode) {
        String[] stringArray = placeholderMap.getKeys(key);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            BuildNode buildNode2 = buildNode.get(this.path(string));
            String string2 = this.key(string);
            if ("type".equals(string2)) {
                buildNode2.type = placeholderMap.getString(key, string);
            } else if ("id".equals(string2)) {
                buildNode2.id = placeholderMap.getLong(key, string);
            } else if ("map".equals(string2)) {
                buildNode2.map = placeholderMap.getMap(key, string);
            } else if ("array".equals(string2)) {
                buildNode2.placeholders = key.getPlaceholders();
            } else if ("divider".equals(string2)) {
                buildNode2.divider = placeholderMap.getDouble(key, string);
            } else if ("orientation".equals(string2)) {
                buildNode2.orientation = placeholderMap.getBoolean(key, string);
            }
            ++n2;
        }
    }

    private String path(String string) {
        return string.substring(0, string.indexOf(46));
    }

    private String key(String string) {
        return string.substring(string.indexOf(46) + 1);
    }

    private class BuildNode {
        private BuildNode[] children;
        private long id = -1L;
        private String type;
        private Path[] placeholders;
        private PlaceholderMap map;
        private boolean orientation;
        private double divider = 0.5;

        private BuildNode() {
        }

        public BuildNode get(String string) {
            return this.get(string, 0);
        }

        private BuildNode get(String string, int n) {
            if (n == string.length()) {
                return this;
            }
            if ('0' == string.charAt(n)) {
                return this.get(0).get(string, n + 1);
            }
            return this.get(1).get(string, n + 1);
        }

        private BuildNode[] createArray(int n) {
            return new BuildNode[n];
        }

        private BuildNode get(int n) {
            if (this.children == null) {
                this.children = this.createArray(n + 1);
            }
            if (this.children.length <= n) {
                BuildNode[] buildNodeArray = this.createArray(n + 1);
                System.arraycopy(this.children, 0, buildNodeArray, 0, this.children.length);
                this.children = buildNodeArray;
            }
            if (this.children[n] == null) {
                this.children[n] = new BuildNode();
            }
            return this.children[n];
        }

        public SplitDockTree.Key collapse(SplitDockTree<D> splitDockTree) {
            if ("l".equals(this.type) || "p".equals(this.type)) {
                if (this.placeholders != null && this.placeholders.length > 0) {
                    return splitDockTree.put(this.placeholders, this.map, this.id);
                }
                return null;
            }
            if ("n".equals(this.type)) {
                SplitDockTree.Key key = null;
                SplitDockTree.Key key2 = null;
                if (this.children != null && this.children.length > 0 && this.children[0] != null) {
                    key = this.children[0].collapse(splitDockTree);
                }
                if (this.children != null && this.children.length > 1 && this.children[1] != null) {
                    key2 = this.children[1].collapse(splitDockTree);
                }
                if (key == null) {
                    return key2;
                }
                if (key2 == null) {
                    return key;
                }
                if (this.orientation) {
                    return splitDockTree.horizontal(key, key2, this.divider, this.placeholders, this.map, this.id);
                }
                return splitDockTree.vertical(key, key2, this.divider, this.placeholders, this.map, this.id);
            }
            if ("r".equals(this.type)) {
                SplitDockTree.Key key;
                if (this.children != null && this.children.length > 0 && this.children[0] != null && (key = this.children[0].collapse(splitDockTree)) != null) {
                    splitDockTree.root(key);
                    return key;
                }
                return null;
            }
            return null;
        }
    }
}

