/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.station.split.GridNode;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractSplitDockGrid<D> {
    private List<Node<D>> nodes = new ArrayList<Node<D>>();
    private List<Line> lines = new ArrayList<Line>();
    private boolean unpack = true;

    public AbstractSplitDockGrid() {
    }

    public void setUnpack(boolean bl) {
        this.unpack = bl;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public AbstractSplitDockGrid(String string, Map<Character, D[]> map) {
        String[] stringArray = string.split("\n");
        HashSet<Character> hashSet = new HashSet<Character>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            hashSet.add(Character.valueOf(string.charAt(n)));
            ++n;
        }
        for (Character c : hashSet) {
            D[] DArray = map.get(c);
            if (DArray == null) continue;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n7 < stringArray.length) {
                int n8 = 0;
                int n9 = stringArray[n7].length();
                while (n8 < n9) {
                    if (stringArray[n7].charAt(n8) == c.charValue()) {
                        n3 = Math.min(n3, n8);
                        n5 = Math.max(n5, n8);
                        n4 = Math.min(n4, n7);
                        n6 = Math.max(n6, n7);
                    }
                    ++n8;
                }
                ++n7;
            }
            this.addDockable(n3, n4, n5 - n3, n6 - n4, DArray);
        }
    }

    protected abstract D[] array(int var1);

    public void unpack(double d, double d2, double d3, double d4) {
        Node<D> node = this.nodeAt(d, d2, d3, d4);
        if (node != null && node.dockables != null) {
            Object object;
            ArrayList arrayList = new ArrayList();
            D[] DArray = node.dockables;
            int n = node.dockables.length;
            int n2 = 0;
            while (n2 < n) {
                object = DArray[n2];
                D[] DArray2 = this.unpack(object);
                int n3 = DArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object d5 = DArray2[n4];
                    arrayList.add(d5);
                    ++n4;
                }
                ++n2;
            }
            object = arrayList.toArray(this.array(arrayList.size()));
            node.dockables = object;
        }
    }

    protected abstract D[] unpack(D var1);

    public D[] getDockables(double d, double d2, double d3, double d4) {
        Node<D> node = this.nodeAt(d, d2, d3, d4);
        if (node == null) {
            return null;
        }
        D[] DArray = this.array(node.dockables.length);
        System.arraycopy(node.dockables, 0, DArray, 0, DArray.length);
        return DArray;
    }

    public void addDockable(double d, double d2, double d3, double d4, D ... DArray) {
        Object object;
        if (DArray == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (DArray.length == 0) {
            throw new IllegalArgumentException("Dockables must at least have one element");
        }
        D[] DArray2 = DArray;
        int n = DArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = DArray2[n2];
            if (object == null) {
                throw new IllegalArgumentException("Entry of dockables-array is null");
            }
            ++n2;
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        if (this.isUnpack()) {
            this.unpack(d, d2, d3, d4);
        }
        object = this.nodeAt(d, d2, d3, d4);
        n2 = 0;
        if (((Node)object).dockables == null) {
            ((Node)object).dockables = this.array(DArray.length);
        } else {
            D[] DArray3 = ((Node)object).dockables;
            n2 = DArray3.length;
            ((Node)object).dockables = this.array(DArray3.length + DArray.length);
            System.arraycopy(DArray3, 0, ((Node)object).dockables, 0, DArray3.length);
        }
        System.arraycopy(DArray, 0, ((Node)object).dockables, n2, DArray.length);
    }

    public void addPlaceholders(double d, double d2, double d3, double d4, Path ... pathArray) {
        Object object;
        if (pathArray == null) {
            throw new IllegalArgumentException("Placeholders must not be null");
        }
        if (pathArray.length == 0) {
            throw new IllegalArgumentException("Placeholders must at least have one element");
        }
        Path[] pathArray2 = pathArray;
        int n = pathArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = pathArray2[n2];
            if (object == null) {
                throw new IllegalArgumentException("Entry of placeholders-array is null");
            }
            ++n2;
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        if (this.isUnpack()) {
            this.unpack(d, d2, d3, d4);
        }
        object = this.nodeAt(d, d2, d3, d4);
        n2 = 0;
        if (((Node)object).placeholders == null) {
            ((Node)object).placeholders = new Path[pathArray.length];
        } else {
            Path[] pathArray3 = ((Node)object).placeholders;
            n2 = pathArray3.length;
            ((Node)object).placeholders = new Path[pathArray3.length + pathArray.length];
            System.arraycopy(pathArray3, 0, ((Node)object).placeholders, 0, pathArray.length);
        }
        System.arraycopy(pathArray, 0, ((Node)object).placeholders, n2, pathArray.length);
    }

    public void setPlaceholderMap(double d, double d2, double d3, double d4, PlaceholderMap placeholderMap) {
        for (Node<D> node : this.nodes) {
            if (node.x != d || node.y != d2 || node.width != d3 || node.height != d4) continue;
            node.placeholderMap = placeholderMap;
            return;
        }
        throw new IllegalArgumentException("there are no dockables registered with the given coordinates");
    }

    private Node<D> nodeAt(double d, double d2, double d3, double d4) {
        Node node2;
        for (Node node2 : this.nodes) {
            if (node2.x != d || node2.y != d2 || node2.width != d3 || node2.height != d4) continue;
            return node2;
        }
        node2 = new Node();
        node2.x = d;
        node2.y = d2;
        node2.width = d3;
        node2.height = d4;
        this.nodes.add(node2);
        return node2;
    }

    public void setSelected(double d, double d2, double d3, double d4, D d5) {
        if (d5 == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        if (this.isUnpack()) {
            this.unpack(d, d2, d3, d4);
        }
        for (Node<D> node : this.nodes) {
            if (node.x != d || node.y != d2 || node.width != d3 || node.height != d4) continue;
            D[] DArray = node.dockables;
            int n = node.dockables.length;
            int n2 = 0;
            while (n2 < n) {
                Object d6 = DArray[n2];
                if (d6 == d5) {
                    node.selected = d5;
                    return;
                }
                ++n2;
            }
            throw new IllegalArgumentException("dockable is not in the described stack");
        }
        throw new IllegalArgumentException("there are no dockables registered with the given coordinates");
    }

    public void addVerticalDivider(double d, double d2, double d3) {
        Line line = new Line();
        line.horizontal = false;
        line.alpha = d;
        line.betaMin = Math.min(d2, d3);
        line.betaMax = Math.max(d2, d3);
        this.lines.add(line);
    }

    public void addHorizontalDivider(double d, double d2, double d3) {
        Line line = new Line();
        line.horizontal = true;
        line.alpha = d3;
        line.betaMin = Math.min(d, d2);
        line.betaMax = Math.max(d, d2);
        this.lines.add(line);
    }

    protected void fillTree(SplitDockTree<D> splitDockTree) {
        Node<D> node = this.tree();
        if (node != null) {
            SplitDockTree.Key key = node.put(splitDockTree);
            splitDockTree.root(key);
        }
    }

    protected List<Line> getLines() {
        return this.lines;
    }

    protected List<Node<D>> getNodes() {
        return this.nodes;
    }

    public List<GridNode<D>> getGridNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    protected Node<D> getNode(D d) {
        for (Node<D> node : this.nodes) {
            if (node.dockables == null) continue;
            D[] DArray = node.dockables;
            int n = node.dockables.length;
            int n2 = 0;
            while (n2 < n) {
                Object d2 = DArray[n2];
                if (d2 == d) {
                    return node;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected Node<D> tree() {
        var1_1 = new ArrayList<Node<D>>(this.nodes);
        if (!var1_1.isEmpty()) ** GOTO lbl24
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.size();
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 1.7976931348623157E308;
            var7_7 = 0;
            while (var7_7 < var2_2) {
                var8_8 = var7_7 + 1;
                while (var8_8 < var2_2) {
                    var9_9 = this.diff((Node)var1_1.get(var7_7), (Node)var1_1.get(var8_8));
                    if (var9_9 < var5_5) {
                        var5_5 = var9_9;
                        var3_3 = var7_7;
                        var4_4 = var8_8;
                    }
                    ++var8_8;
                }
                ++var7_7;
            }
            var7_6 = this.combine((Node)var1_1.remove(var4_4), (Node)var1_1.remove(var3_3));
            var1_1.add(var7_6);
lbl24:
            // 2 sources

            ** while (var1_1.size() > 1)
        }
lbl25:
        // 1 sources

        return (Node)var1_1.get(0);
    }

    protected Node<D> combine(Node<D> node, Node<D> node2) {
        double d = Math.min(node.x, node2.x);
        double d2 = Math.min(node.y, node2.y);
        double d3 = Math.max(node.x + node.width, node2.x + node2.width) - d;
        double d4 = Math.max(node.y + node.height, node2.y + node2.height) - d2;
        double d5 = node.x + node.width / 2.0;
        double d6 = node.y + node.height / 2.0;
        double d7 = node2.x + node2.width / 2.0;
        double d8 = node2.y + node2.height / 2.0;
        double d9 = (d5 - d7) * d4;
        double d10 = (d6 - d8) * d3;
        Node node3 = new Node();
        if (Math.abs(d9) > Math.abs(d10)) {
            node3.horizontal = true;
            if (d9 > 0.0) {
                node3.childA = node2;
                node3.childB = node;
            } else {
                node3.childA = node;
                node3.childB = node2;
            }
            double d11 = ((node3.childA.x + node3.childA.width + node3.childB.x) / 2.0 - d) / d3;
            Line line = this.bestFittingLine(d, d2, d3, d4, false, d11);
            node3.divider = line == null ? d11 : (line.alpha - d) / d3;
        } else {
            node3.horizontal = false;
            if (d10 > 0.0) {
                node3.childA = node2;
                node3.childB = node;
            } else {
                node3.childA = node;
                node3.childB = node2;
            }
            double d12 = ((node3.childA.y + node3.childA.height + node3.childB.y) / 2.0 - d2) / d4;
            Line line = this.bestFittingLine(d, d2, d3, d4, true, d12);
            node3.divider = line == null ? d12 : (line.alpha - d2) / d4;
        }
        node3.x = d;
        node3.y = d2;
        node3.width = d3;
        node3.height = d4;
        return node3;
    }

    protected double diff(Node<D> node, Node<D> node2) {
        double d = Math.min(node.x, node2.x);
        double d2 = Math.min(node.y, node2.y);
        double d3 = Math.max(node.x + node.width, node2.x + node2.width) - d;
        double d4 = Math.max(node.y + node.height, node2.y + node2.height) - d2;
        double d5 = node.width * node.height;
        double d6 = node2.width * node2.height;
        double d7 = d3 * d4;
        double d8 = (d7 - d5 - d6) / d7;
        for (Line line : this.lines) {
            d8 += this.penalty(d, d2, d3, d4, line);
        }
        return d8;
    }

    protected Line bestFittingLine(double d, double d2, double d3, double d4, boolean bl, double d5) {
        Line line = null;
        double d6 = Double.MAX_VALUE;
        for (Line line2 : this.lines) {
            double d7;
            double d8;
            double d9;
            double d10;
            if (line2.horizontal != bl) continue;
            if (line2.horizontal) {
                if (d2 > line2.alpha || d2 + d4 < line2.alpha || d + d3 < line2.betaMin || d > line2.betaMax) continue;
                d10 = Math.min(d, line2.betaMin);
                d9 = Math.max(d + d3, line2.betaMax);
                d8 = d9 - d10 - Math.min(line2.betaMax - line2.betaMin, d3);
                d7 = d8 / (d9 - d10);
                d7 *= 1.0 + Math.abs(d5 - line2.alpha) / d4;
            } else {
                if (d > line2.alpha || d + d3 < line2.alpha || d2 + d4 < line2.betaMin || d2 > line2.betaMax) continue;
                d10 = Math.min(d2, line2.betaMin);
                d9 = Math.max(d2 + d4, line2.betaMax);
                d8 = d9 - d10 - Math.min(line2.betaMax - line2.betaMin, d4);
                d7 = d8 / (d9 - d10);
                d7 *= 1.0 + Math.abs(d5 - line2.alpha) / d3;
            }
            if (!(d7 < 0.25) || !(d7 < d6)) continue;
            d6 = d7;
            line = line2;
        }
        return line;
    }

    protected double penalty(double d, double d2, double d3, double d4, Line line) {
        double d5;
        double d6;
        double d7;
        if (line.horizontal) {
            if (d2 >= line.alpha || d2 + d4 <= line.alpha) {
                return 0.0;
            }
            if (d + d3 <= line.betaMin || d >= line.betaMax) {
                return 0.0;
            }
            d7 = Math.min(d, line.betaMin);
            d6 = Math.max(d + d3, line.betaMax);
            d5 = d6 - d7 - Math.min(line.betaMax - line.betaMin, d3);
        } else {
            if (d >= line.alpha || d + d3 <= line.alpha) {
                return 0.0;
            }
            if (d2 + d4 <= line.betaMin || d2 >= line.betaMax) {
                return 0.0;
            }
            d7 = Math.min(d2, line.betaMin);
            d6 = Math.max(d2 + d4, line.betaMax);
            d5 = d6 - d7 - Math.min(line.betaMax - line.betaMin, d4);
        }
        return d5 / (d6 - d7);
    }

    protected static class Line {
        public boolean horizontal;
        public double alpha;
        public double betaMin;
        public double betaMax;

        protected Line() {
        }
    }

    protected static class Node<D>
    implements GridNode<D> {
        public double x;
        public double y;
        public double width;
        public double height;
        public Node<D> childA;
        public Node<D> childB;
        public double divider;
        public boolean horizontal;
        public D[] dockables;
        public D selected;
        public Path[] placeholders;
        public PlaceholderMap placeholderMap;

        protected Node() {
        }

        public SplitDockTree.Key put(SplitDockTree<D> splitDockTree) {
            if (this.dockables != null || this.childA == null || this.childB == null) {
                return splitDockTree.put(this.dockables, this.selected, this.placeholders, this.placeholderMap, -1L);
            }
            if (this.horizontal) {
                return splitDockTree.horizontal(this.childA.put(splitDockTree), this.childB.put(splitDockTree), this.divider, this.placeholders, this.placeholderMap, -1L);
            }
            return splitDockTree.vertical(this.childA.put(splitDockTree), this.childB.put(splitDockTree), this.divider, this.placeholders, this.placeholderMap, -1L);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public List<D> getDockables() {
            if (this.dockables == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(Arrays.asList(this.dockables));
        }

        @Override
        public D getSelected() {
            return this.selected;
        }

        @Override
        public List<Path> getPlaceholders() {
            if (this.placeholders == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(Arrays.asList(this.placeholders));
        }
    }
}

