/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.span;

import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import java.util.HashMap;
import java.util.Map;

public class DefaultSpanFactory
implements SpanFactory {
    @Override
    public Span create(SpanCallback spanCallback) {
        return new DefaultSpan(spanCallback);
    }

    private static class DefaultSpan
    implements Span {
        private SpanCallback callback;
        private Map<SpanMode, Integer> sizes = new HashMap<SpanMode, Integer>(2);
        private int size = 0;

        public DefaultSpan(SpanCallback spanCallback) {
            this.callback = spanCallback;
        }

        @Override
        public void mutate(SpanMode spanMode) {
            this.set(spanMode);
        }

        @Override
        public void set(SpanMode spanMode) {
            Integer n = this.sizes.get(spanMode);
            this.size = n == null ? spanMode.getSize() : n.intValue();
            this.callback.resized();
        }

        @Override
        public void configureSize(SpanMode spanMode, int n) {
            this.sizes.put(spanMode, n);
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }
}

