/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class OrderedLayerCollection {
    private Set<DockStation> stations = new HashSet<DockStation>();

    public void add(DockStation dockStation) {
        this.stations.add(dockStation);
    }

    public List<DockStation> sort(int n, int n2) {
        ArrayList<DockStation> arrayList3;
        Object object32;
        HashMap<DockStation, Node> hashMap = new HashMap<DockStation, Node>();
        for (DockStation object22 : this.stations) {
            hashMap.put(object22, new Node(object22));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object32 : hashMap.values()) {
            if (((Node)object32).register(hashMap)) continue;
            arrayList2.add(object32);
        }
        for (Object object32 : arrayList2) {
            ((Node)object32).modify();
        }
        object32 = new ArrayList();
        for (ArrayList<DockStation> arrayList3 : arrayList2) {
            ((Node)((Object)arrayList3)).collect((List<DockStationDropLayer>)object32, n, n2);
        }
        object32 = this.sort((List<DockStationDropLayer>)object32);
        arrayList3 = new ArrayList<DockStation>();
        Iterator<DockStationDropLayer> iterator = object32.iterator();
        while (iterator.hasNext()) {
            DockStationDropLayer dockStationDropLayer = iterator.next();
            if (hashMap.remove(dockStationDropLayer.getStation()) == null) continue;
            arrayList3.add(dockStationDropLayer.getStation());
        }
        return arrayList3;
    }

    protected List<DockStationDropLayer> sort(List<DockStationDropLayer> list) {
        LinkedList<DockStationDropLayer> linkedList = new LinkedList<DockStationDropLayer>();
        for (DockStationDropLayer dockStationDropLayer : list) {
            int n = 0;
            for (DockStationDropLayer dockStationDropLayer2 : linkedList) {
                int n2 = this.compare(dockStationDropLayer2, dockStationDropLayer);
                if (n2 > 0) break;
                ++n;
            }
            linkedList.add(n, dockStationDropLayer);
        }
        return linkedList;
    }

    protected int compare(DockStationDropLayer dockStationDropLayer, DockStationDropLayer dockStationDropLayer2) {
        DockStation dockStation;
        LayerPriority layerPriority;
        LayerPriority layerPriority2;
        int n;
        if (dockStationDropLayer == dockStationDropLayer2) {
            return 0;
        }
        boolean bl = dockStationDropLayer.canCompare(dockStationDropLayer2);
        boolean bl2 = dockStationDropLayer2.canCompare(dockStationDropLayer);
        if (bl && bl2) {
            int n2 = -dockStationDropLayer.compare(dockStationDropLayer2);
            int n3 = dockStationDropLayer2.compare(dockStationDropLayer);
            if (n2 == 0) {
                return n3;
            }
            if (n3 == 0) {
                return n2;
            }
            if (n2 < 0 == n3 < 0) {
                return n2;
            }
        }
        if ((n = (layerPriority2 = dockStationDropLayer.getPriority()).compareTo(layerPriority = dockStationDropLayer2.getPriority())) != 0) {
            return n;
        }
        int n4 = layerPriority2.isReverse() ? -1 : 1;
        DockStation dockStation2 = dockStationDropLayer.getStation();
        if (DockUtilities.isAncestor(dockStation2, dockStation = dockStationDropLayer2.getStation())) {
            return 1 * n4;
        }
        if (DockUtilities.isAncestor(dockStation, dockStation2)) {
            return -1 * n4;
        }
        Component component = dockStationDropLayer.getComponent();
        Component component2 = dockStationDropLayer2.getComponent();
        if (component != null && component2 != null) {
            Window window = SwingUtilities.getWindowAncestor(component);
            Window window2 = SwingUtilities.getWindowAncestor(component2);
            if (window != null && window2 != null) {
                if (window == window2) {
                    if (DockUI.isOverlapping(component, component2)) {
                        return -1 * n4;
                    }
                    if (DockUI.isOverlapping(component2, component)) {
                        return 1 * n4;
                    }
                } else {
                    boolean bl3;
                    if (this.isParent(window, window2)) {
                        return 1 * n4;
                    }
                    if (this.isParent(window2, window)) {
                        return -1 * n4;
                    }
                    boolean bl4 = window.getMousePosition() != null;
                    boolean bl5 = bl3 = window2.getMousePosition() != null;
                    if (bl4 && !bl3) {
                        return -1 * n4;
                    }
                    if (!bl4 && bl3) {
                        return 1 * n4;
                    }
                }
            }
        }
        return 0;
    }

    private boolean isParent(Window window, Window window2) {
        Window window3 = window2.getOwner();
        while (window3 != null) {
            if (window3 == window) {
                return true;
            }
            window3 = window3.getOwner();
        }
        return false;
    }

    private class Node {
        private Node parent;
        private List<Node> children;
        private DockStation station;
        private DockStationDropLayer[] layers;

        public Node(DockStation dockStation) {
            this.station = dockStation;
            if (dockStation.getDockableCount() > 0) {
                this.children = new ArrayList<Node>(dockStation.getDockableCount());
            }
            this.layers = dockStation.getLayers();
        }

        public boolean register(Map<DockStation, Node> map) {
            Dockable dockable = this.station.asDockable();
            while (dockable != null) {
                DockStation dockStation = dockable.getDockParent();
                if (dockStation == null) {
                    return false;
                }
                Node node = map.get(dockStation);
                if (node != null) {
                    node.children.add(this);
                    this.parent = node;
                    return true;
                }
                dockable = dockStation.asDockable();
            }
            return false;
        }

        public DockStationDropLayer[] getLayers() {
            return this.layers;
        }

        public void modify() {
            Node node2;
            if (this.children != null) {
                for (Node node2 : this.children) {
                    node2.modify();
                }
            }
            node2 = this.parent;
            while (node2 != null) {
                int n = 0;
                while (n < this.layers.length) {
                    DockStationDropLayer[] dockStationDropLayerArray = node2.getLayers();
                    int n2 = dockStationDropLayerArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        DockStationDropLayer dockStationDropLayer = dockStationDropLayerArray[n3];
                        this.layers[n] = dockStationDropLayer.modify(this.layers[n]);
                        ++n3;
                    }
                    ++n;
                }
                node2 = node2.parent;
            }
        }

        public void collect(List<DockStationDropLayer> list, int n, int n2) {
            if (this.children != null) {
                for (Node object : this.children) {
                    object.collect(list, n, n2);
                }
            }
            DockStationDropLayer[] dockStationDropLayerArray = this.layers;
            int n3 = this.layers.length;
            int n4 = 0;
            while (n4 < n3) {
                DockStationDropLayer dockStationDropLayer = dockStationDropLayerArray[n4];
                if (dockStationDropLayer.contains(n, n2)) {
                    list.add(dockStationDropLayer);
                }
                ++n4;
            }
        }
    }
}

