/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.layer;

public class LayerPriority
implements Comparable<LayerPriority> {
    public static final LayerPriority FALLBACK = new LayerPriority(0.1f, false);
    public static final LayerPriority OUTSIDE_LOW = new LayerPriority(0.2f, false);
    public static final LayerPriority BASE = new LayerPriority(0.3f, false);
    public static final LayerPriority OVERRIDE_GUESS = new LayerPriority(0.4f, true);
    public static final LayerPriority OVERRIDE_PRECISE = new LayerPriority(0.5f, false);
    public static final LayerPriority OUTSIDE_HIGH = new LayerPriority(0.6f, false);
    public static final LayerPriority FLOAT_ANCHORED = new LayerPriority(0.7f, false);
    public static final LayerPriority FLOAT_FREE = new LayerPriority(0.8f, false);
    private LayerPriority sub;
    private boolean reverse;
    private float priority;

    public LayerPriority(float f, boolean bl) {
        this(f, bl, null);
    }

    public LayerPriority(float f, boolean bl, LayerPriority layerPriority) {
        this.priority = f;
        this.reverse = bl;
        this.sub = layerPriority;
    }

    public LayerPriority merge(LayerPriority layerPriority) {
        return new LayerPriority(this.getPriority(), this.isReverse(), layerPriority);
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public float getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(LayerPriority layerPriority) {
        if (layerPriority == this) {
            return 0;
        }
        int n = this.compareDirect(layerPriority);
        if (n != 0) {
            return n;
        }
        if (this.sub == null && layerPriority.sub == null) {
            return 0;
        }
        if (this.sub == null && layerPriority.sub != null) {
            return 1;
        }
        if (this.sub != null && layerPriority.sub == null) {
            return -1;
        }
        return this.sub.compareTo(layerPriority.sub);
    }

    private int compareDirect(LayerPriority layerPriority) {
        if (this.getPriority() > layerPriority.getPriority()) {
            return -1;
        }
        if (this.getPriority() < layerPriority.getPriority()) {
            return 1;
        }
        if (!this.isReverse() && layerPriority.isReverse()) {
            return -1;
        }
        if (this.isReverse() && !layerPriority.isReverse()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String string = "layer [priority=" + this.getPriority() + ", reverse=" + this.isReverse() + "]";
        if (this.sub != null) {
            string = String.valueOf(string) + " -> " + this.sub;
        }
        return string;
    }
}

