/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class DefaultDropLayer
implements DockStationDropLayer {
    private DockStation station;
    private LayerPriority priority = LayerPriority.BASE;

    public DefaultDropLayer(DockStation dockStation) {
        this.station = dockStation;
    }

    @Override
    public boolean canCompare(DockStationDropLayer dockStationDropLayer) {
        return false;
    }

    @Override
    public int compare(DockStationDropLayer dockStationDropLayer) {
        return 0;
    }

    @Override
    public boolean contains(int n, int n2) {
        Component component = this.getComponent();
        if (component == null) {
            return true;
        }
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, component);
        return component.contains(point);
    }

    @Override
    public Component getComponent() {
        Dockable dockable = this.station.asDockable();
        if (dockable == null) {
            return null;
        }
        return dockable.getComponent();
    }

    @Override
    public LayerPriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(LayerPriority layerPriority) {
        this.priority = layerPriority;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer dockStationDropLayer) {
        return dockStationDropLayer;
    }
}

