/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class FlapSideDropLayer
implements DockStationDropLayer {
    private FlapDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_HIGH;

    public FlapSideDropLayer(FlapDockStation flapDockStation) {
        this.station = flapDockStation;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public Component getComponent() {
        return this.station.getComponent();
    }

    @Override
    public DockStationDropLayer modify(DockStationDropLayer dockStationDropLayer) {
        return dockStationDropLayer;
    }

    @Override
    public boolean contains(int n, int n2) {
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle rectangle = this.getComponent().getBounds();
        if (rectangle.contains(point)) {
            return false;
        }
        n = point.x;
        n2 = point.y;
        int n3 = Math.min(Math.abs(n), Math.abs(n - rectangle.width));
        if (n > 0 && n < rectangle.width) {
            n3 = 0;
        }
        int n4 = Math.min(Math.abs(n2), Math.abs(n2 - rectangle.height));
        if (n2 > 0 && n2 < rectangle.height) {
            n4 = 0;
        }
        if (this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? n3 > 0 : n4 > 0) {
            return false;
        }
        int n5 = this.station.getBorderSideSnapSize();
        return n3 <= n5 && n4 <= n5;
    }

    @Override
    public LayerPriority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(LayerPriority layerPriority) {
        this.priority = layerPriority;
    }

    @Override
    public boolean canCompare(DockStationDropLayer dockStationDropLayer) {
        return false;
    }

    @Override
    public int compare(DockStationDropLayer dockStationDropLayer) {
        return 0;
    }
}

