/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.layer;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class FlapOverrideDropLayer
extends DefaultDropLayer {
    private FlapDockStation station;

    public FlapOverrideDropLayer(FlapDockStation flapDockStation) {
        super(flapDockStation);
        this.station = flapDockStation;
        this.setPriority(LayerPriority.OVERRIDE_PRECISE);
    }

    @Override
    public boolean contains(int n, int n2) {
        if (super.contains(n, n2)) {
            DockTitle dockTitle;
            if (this.station.isOverButtons(n, n2)) {
                return true;
            }
            FlapWindow flapWindow = this.station.getFlapWindow();
            if (flapWindow != null && flapWindow.isWindowVisible() && (dockTitle = flapWindow.getDockTitle()) != null) {
                Component component = dockTitle.getComponent();
                Point point = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point, component);
                if (component.contains(point)) {
                    return true;
                }
            }
        }
        return false;
    }
}

