/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.button;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.flap.button.AbstractButtonContentCondition;
import bibliothek.gui.dock.station.flap.button.ButtonContentCondition;
import bibliothek.gui.dock.station.flap.button.ButtonContentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ButtonContent {
    public static final ButtonContentCondition TRUE = new ButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return true;
        }

        @Override
        public void install(Dockable dockable, ButtonContent buttonContent) {
        }

        @Override
        public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        }
    };
    public static final ButtonContentCondition FALSE = new ButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return false;
        }

        @Override
        public void install(Dockable dockable, ButtonContent buttonContent) {
        }

        @Override
        public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        }
    };
    public static final ButtonContentCondition THEME = new ButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return bl;
        }

        @Override
        public void install(Dockable dockable, ButtonContent buttonContent) {
        }

        @Override
        public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        }
    };
    public static final ButtonContentCondition NOT_IF_ICON = new AbstractButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return dockable.getTitleIcon() == null;
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            this.fire(dockable);
        }
    };
    public static final ButtonContentCondition NOT_IF_TEXT = new AbstractButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            String string = dockable.getTitleText();
            return string == null || string.length() == 0;
        }

        @Override
        public void titleTextChanged(Dockable dockable, String string, String string2) {
            this.fire(dockable);
        }
    };
    public static final ButtonContentCondition IF_STATION = new ButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return dockable.asDockStation() != null;
        }

        @Override
        public void install(Dockable dockable, ButtonContent buttonContent) {
        }

        @Override
        public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        }
    };
    public static final ButtonContentCondition IF_DOCKABLE = new ButtonContentCondition(){

        @Override
        public boolean shouldShow(Dockable dockable, boolean bl) {
            return dockable.asDockStation() == null;
        }

        @Override
        public void install(Dockable dockable, ButtonContent buttonContent) {
        }

        @Override
        public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        }
    };
    public static final ButtonContent THEME_DEPENDENT = new ButtonContent(THEME, THEME, THEME, THEME, THEME, THEME);
    public static final ButtonContent ICON_ONLY = new ButtonContent(FALSE, TRUE, FALSE, FALSE, FALSE, FALSE);
    public static final ButtonContent TEXT_ONLY = new ButtonContent(FALSE, FALSE, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_AND_TEXT_ONLY = new ButtonContent(FALSE, TRUE, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_THEN_TEXT_ONLY = new ButtonContent(FALSE, TRUE, NOT_IF_ICON, FALSE, FALSE, FALSE);
    public static final ButtonContent TEXT_THEN_ICON_ONLY = new ButtonContent(FALSE, NOT_IF_TEXT, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_ACTIONS = new ButtonContent(FALSE, TRUE, FALSE, FALSE, TRUE, FALSE);
    public static final ButtonContent TEXT_ACTIONS = new ButtonContent(FALSE, FALSE, TRUE, FALSE, TRUE, FALSE);
    public static final ButtonContent ICON_AND_TEXT_ACTIONS = new ButtonContent(FALSE, TRUE, TRUE, FALSE, TRUE, FALSE);
    public static final ButtonContent ICON_THEN_TEXT_ACTIONS = new ButtonContent(FALSE, TRUE, NOT_IF_ICON, FALSE, TRUE, FALSE);
    public static final ButtonContent TEXT_THEN_ICON_ACTIONS = new ButtonContent(FALSE, NOT_IF_TEXT, TRUE, FALSE, TRUE, FALSE);
    private ButtonContentCondition knob;
    private ButtonContentCondition icon;
    private ButtonContentCondition text;
    private ButtonContentCondition actions;
    private ButtonContentCondition filterActions;
    private ButtonContentCondition children;
    private Map<Dockable, List<ButtonContentListener>> listeners = new HashMap<Dockable, List<ButtonContentListener>>();

    public ButtonContent(ButtonContentCondition buttonContentCondition, ButtonContentCondition buttonContentCondition2, ButtonContentCondition buttonContentCondition3, ButtonContentCondition buttonContentCondition4, ButtonContentCondition buttonContentCondition5, ButtonContentCondition buttonContentCondition6) {
        this.knob = this.get(buttonContentCondition);
        this.icon = this.get(buttonContentCondition2);
        this.text = this.get(buttonContentCondition3);
        this.children = this.get(buttonContentCondition4);
        this.actions = this.get(buttonContentCondition5);
        this.filterActions = this.get(buttonContentCondition6);
    }

    private ButtonContentCondition get(ButtonContentCondition buttonContentCondition) {
        if (buttonContentCondition == null) {
            return THEME;
        }
        return buttonContentCondition;
    }

    public void addListener(Dockable dockable, ButtonContentListener buttonContentListener) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list == null) {
            list = new ArrayList<ButtonContentListener>();
            this.listeners.put(dockable, list);
            this.install(dockable);
        }
        list.add(buttonContentListener);
    }

    public void removeListener(Dockable dockable, ButtonContentListener buttonContentListener) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list != null) {
            list.remove(buttonContentListener);
            if (list.isEmpty()) {
                this.uninstall(dockable);
                this.listeners.remove(dockable);
            }
        }
    }

    protected ButtonContentListener[] listeners(Dockable dockable) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list != null) {
            return list.toArray(new ButtonContentListener[list.size()]);
        }
        return new ButtonContentListener[0];
    }

    public void handleChange(Dockable dockable) {
        ButtonContentListener[] buttonContentListenerArray = this.listeners(dockable);
        int n = buttonContentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ButtonContentListener buttonContentListener = buttonContentListenerArray[n2];
            buttonContentListener.changed(this, dockable);
            ++n2;
        }
    }

    private void install(Dockable dockable) {
        this.knob.install(dockable, this);
        this.icon.install(dockable, this);
        this.text.install(dockable, this);
        this.children.install(dockable, this);
        this.actions.install(dockable, this);
        this.filterActions.install(dockable, this);
    }

    private void uninstall(Dockable dockable) {
        this.knob.uninstall(dockable, this);
        this.icon.uninstall(dockable, this);
        this.text.uninstall(dockable, this);
        this.children.uninstall(dockable, this);
        this.actions.uninstall(dockable, this);
        this.filterActions.uninstall(dockable, this);
    }

    public boolean showKnob(Dockable dockable, boolean bl) {
        return this.knob.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getKnob() {
        return this.knob;
    }

    public boolean showActions(Dockable dockable, boolean bl) {
        return this.actions.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getActions() {
        return this.actions;
    }

    public boolean filterActions(Dockable dockable, boolean bl) {
        return this.actions.shouldShow(dockable, bl) && this.filterActions.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getFilterActions() {
        return this.filterActions;
    }

    public boolean showIcon(Dockable dockable, boolean bl) {
        return this.icon.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getIcon() {
        return this.icon;
    }

    public boolean showText(Dockable dockable, boolean bl) {
        return this.text.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getText() {
        return this.text;
    }

    public boolean showChildren(Dockable dockable, boolean bl) {
        return this.children.shouldShow(dockable, bl);
    }

    public ButtonContentCondition getChildren() {
        return this.children;
    }
}

