/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.button;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentCondition;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractButtonContentCondition
implements ButtonContentCondition,
DockableListener {
    private Map<Dockable, List<ButtonContent>> contents = new HashMap<Dockable, List<ButtonContent>>();

    @Override
    public void install(Dockable dockable, ButtonContent buttonContent) {
        List<ButtonContent> list = this.contents.get(dockable);
        if (list == null) {
            list = new ArrayList<ButtonContent>();
            this.contents.put(dockable, list);
            this.install(dockable);
        }
        list.add(buttonContent);
    }

    @Override
    public void uninstall(Dockable dockable, ButtonContent buttonContent) {
        List<ButtonContent> list = this.contents.get(dockable);
        if (list != null) {
            list.remove(buttonContent);
            if (list.isEmpty()) {
                this.contents.remove(dockable);
                this.uninstall(dockable);
            }
        }
    }

    protected void fire(Dockable dockable) {
        List<ButtonContent> list = this.contents.get(dockable);
        if (list != null) {
            for (ButtonContent buttonContent : list) {
                buttonContent.handleChange(dockable);
            }
        }
    }

    protected void install(Dockable dockable) {
        dockable.addDockableListener(this);
    }

    protected void uninstall(Dockable dockable) {
        dockable.removeDockableListener(this);
    }

    @Override
    public void titleBound(Dockable dockable, DockTitle dockTitle) {
    }

    @Override
    public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
    }

    @Override
    public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
    }

    @Override
    public void titleTextChanged(Dockable dockable, String string, String string2) {
    }

    @Override
    public void titleToolTipChanged(Dockable dockable, String string, String string2) {
    }

    @Override
    public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
    }
}

